/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values.connector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.FutureValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;

public class Executor {
    public static void submit(Scheduler scheduler, ObjectValue service, String resourceName, CallableUnitCallback callback, Map<String, Object> properties, Object ... args) {
        Function<Object[], Object> func = objects -> {
            Strand strand = (Strand)objects[0];
            if (ObserveUtils.isObservabilityEnabled() && properties != null && properties.containsKey("__observer_context__")) {
                strand.observerContext = (ObserverContext)properties.remove("__observer_context__");
            }
            return service.call(strand, resourceName, args);
        };
        BUnionType unionType = new BUnionType(new BType[]{BTypes.typeError, BTypes.typeNull});
        scheduler.schedule(new Object[1], func, null, callback, properties, unionType);
    }

    public static Object executeFunction(Strand strand, ObjectValue service, AttachedFunction resource, Object ... args) {
        int requiredArgNo = resource.type.paramTypes.length;
        int providedArgNo = args.length / 2;
        if (requiredArgNo != providedArgNo) {
            throw new RuntimeException("Wrong number of arguments. Required: " + requiredArgNo + " , found: " + providedArgNo + ".");
        }
        return service.call(new Strand(strand.scheduler), resource.getName(), args);
    }

    public static Object executeFunction(Scheduler scheduler, ClassLoader classLoader, String orgName, String packageName, String className, String methodName, Object ... paramValues) {
        try {
            Class<?> clazz = classLoader.loadClass(orgName + "." + packageName + "." + className);
            int paramCount = paramValues.length * 2 + 1;
            Class[] jvmParamTypes = new Class[paramCount];
            Object[] jvmArgs = new Object[paramCount];
            jvmParamTypes[0] = Strand.class;
            jvmArgs[0] = scheduler;
            int j = 1;
            for (int i = 0; i < paramValues.length; ++i) {
                jvmArgs[j] = paramValues[i];
                jvmParamTypes[j++] = Executor.getJvmType(paramValues[i]);
                jvmArgs[j] = true;
                jvmParamTypes[j++] = Boolean.TYPE;
            }
            Method method = clazz.getDeclaredMethod(methodName, jvmParamTypes);
            Function<Object[], Object> func = args -> {
                try {
                    return method.invoke(null, args);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new BallerinaException(methodName + " function invocation failed: " + e.getMessage());
                }
            };
            final CountDownLatch completeFunction = new CountDownLatch(1);
            FutureValue futureValue = scheduler.schedule(jvmArgs, func, null, new CallableUnitCallback(){

                @Override
                public void notifySuccess() {
                    completeFunction.countDown();
                }

                @Override
                public void notifyFailure(ErrorValue error2) {
                    completeFunction.countDown();
                }
            }, new HashMap<String, Object>(), BTypes.typeNull);
            completeFunction.await();
            return futureValue.result;
        }
        catch (ClassNotFoundException | InterruptedException | NoSuchMethodException e) {
            throw new BallerinaException("invocation failed: " + e.getMessage());
        }
    }

    private static Class<?> getJvmType(Object paramValue) {
        if (paramValue instanceof MapValue) {
            return MapValue.class;
        }
        if (paramValue instanceof ObjectValue) {
            return ObjectValue.class;
        }
        if (paramValue instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (paramValue instanceof String) {
            return String.class;
        }
        if (paramValue instanceof Integer) {
            return Integer.TYPE;
        }
        if (paramValue instanceof Float) {
            return Double.TYPE;
        }
        throw new RuntimeException("unknown param type: " + paramValue.getClass());
    }

    private Executor() {
    }
}

