/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values.utils;

import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.AbstractObjectValue;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.RefValue;

public class StringUtils {
    public static String getStringValue(Strand strand, Object value2) {
        if (value2 == null) {
            return "";
        }
        BType type = TypeChecker.getType(value2);
        if (type.getTag() < 7) {
            return String.valueOf(value2);
        }
        if (type.getTag() == 15 || type.getTag() == 12) {
            MapValueImpl mapValue = (MapValueImpl)value2;
            return mapValue.stringValue(strand);
        }
        if (type.getTag() == 20 || type.getTag() == 31) {
            ArrayValue arrayValue = (ArrayValue)value2;
            return arrayValue.stringValue(strand);
        }
        if (type.getTag() == 35) {
            AbstractObjectValue objectValue = (AbstractObjectValue)value2;
            BObjectType objectType = objectValue.getType();
            for (AttachedFunction func : objectType.getAttachedFunctions()) {
                if (!func.funcName.equals("toString") || func.paramTypes.length != 0 || func.type.retType.getTag() != 5) continue;
                return (String)objectValue.call(strand, "toString", new Object[0]);
            }
        }
        if (type.getTag() == 29) {
            RefValue errorValue = (RefValue)value2;
            return errorValue.stringValue(strand);
        }
        RefValue refValue = (RefValue)value2;
        return refValue.stringValue();
    }

    public static String getJsonString(Object value2) {
        if (value2 == null) {
            return "null";
        }
        BType type = TypeChecker.getType(value2);
        if (type.getTag() < 7) {
            return String.valueOf(value2);
        }
        if (type.getTag() == 15) {
            MapValueImpl mapValue = (MapValueImpl)value2;
            return mapValue.getJSONString();
        }
        if (type.getTag() == 20) {
            ArrayValue arrayValue = (ArrayValue)value2;
            return arrayValue.getJSONString();
        }
        RefValue refValue = (RefValue)value2;
        return refValue.stringValue();
    }
}

