/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.utils.ArrayUtils;
import org.ballerinalang.jvm.values.utils.GetFunction;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.array", functionName="slice", args={@Argument(name="arr", type=TypeKind.ARRAY), @Argument(name="startIndex", type=TypeKind.INT), @Argument(name="endIndex", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.ARRAY)}, isPublic=true)
public class Slice {
    public static ArrayValue slice(Strand strand, ArrayValue arr, long startIndex, long endIndex) {
        GetFunction getFn;
        int elemTypeTag;
        ArrayValue slicedArr;
        int size = arr.size();
        if (startIndex < 0L) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, startIndex, size);
        }
        if (endIndex > (long)size) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, endIndex, size);
        }
        long sliceSize = endIndex - startIndex;
        if (sliceSize < 0L) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, sliceSize, size);
        }
        BType arrType = arr.getType();
        switch (arrType.getTag()) {
            case 20: {
                slicedArr = new ArrayValue(arrType);
                elemTypeTag = ((BArrayType)arrType).getElementType().getTag();
                getFn = ArrayValue::get;
                break;
            }
            case 31: {
                BUnionType unionType = new BUnionType(((BTupleType)arrType).getTupleTypes());
                BArrayType slicedArrType = new BArrayType(unionType, (int)(endIndex - startIndex));
                slicedArr = new ArrayValue(slicedArrType);
                elemTypeTag = -1;
                getFn = ArrayValue::getRefValue;
                break;
            }
            default: {
                throw ArrayUtils.createOpNotSupportedError(arrType, "slice()");
            }
        }
        long i = startIndex;
        long j = 0L;
        while (i < endIndex) {
            ArrayUtils.add(slicedArr, elemTypeTag, j, getFn.get(arr, i));
            ++i;
            ++j;
        }
        return slicedArr;
    }
}

