/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.jvm.values.utils.ArrayUtils;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.array", functionName="sort", args={@Argument(name="arr", type=TypeKind.ARRAY), @Argument(name="func", type=TypeKind.FUNCTION)}, returnType={@ReturnType(type=TypeKind.ARRAY)}, isPublic=true)
public class Sort {
    public static ArrayValue sort(Strand strand, ArrayValue arr, FPValue<Object, Long> func) {
        ArrayUtils.checkIsArrayOnlyOperation(arr.getType(), "sort()");
        ArrayValue aux = new ArrayValue(arr.getType());
        Sort.mergesort(arr, aux, 0, arr.size() - 1, strand, func);
        return arr;
    }

    private static void mergesort(ArrayValue input, ArrayValue aux, int lo, int hi, Strand strand, FPValue<Object, Long> comparator) {
        if (hi <= lo) {
            return;
        }
        int mid = lo + (hi - lo) / 2;
        Sort.mergesort(input, aux, lo, mid, strand, comparator);
        Sort.mergesort(input, aux, mid + 1, hi, strand, comparator);
        Sort.merge(input, aux, lo, mid, hi, strand, comparator);
    }

    private static void merge(ArrayValue input, ArrayValue aux, int lo, int mid, int hi, Strand strand, FPValue<Object, Long> comparator) {
        int i;
        int elemTypeTag = input.elementType.getTag();
        for (i = lo; i <= hi; ++i) {
            ArrayUtils.add(aux, elemTypeTag, i, input.get(i));
        }
        i = lo;
        int j = mid + 1;
        for (int k = lo; k <= hi; ++k) {
            if (i > mid) {
                ArrayUtils.add(input, elemTypeTag, k, aux.get(j++));
                continue;
            }
            if (j > hi) {
                ArrayUtils.add(input, elemTypeTag, k, aux.get(i++));
                continue;
            }
            if (comparator.apply(new Object[]{strand, aux.get(j), true, aux.get(i), true}) < 0L) {
                ArrayUtils.add(input, elemTypeTag, k, aux.get(j++));
                continue;
            }
            ArrayUtils.add(input, elemTypeTag, k, aux.get(i++));
        }
    }
}

