/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.array", functionName="toBase16", args={@Argument(name="arr", type=TypeKind.ARRAY)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class ToBase16 {
    private static final char[] chars = "0123456789abcdef".toCharArray();

    public static String toBase16(Strand strand, ArrayValue arr) {
        BType arrType = arr.getType();
        if (arrType.getTag() != 20 || ((BArrayType)arrType).getElementType().getTag() != 2) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "OperationNotSupported"), "toBase16() is only supported on 'byte[]'");
        }
        byte[] bytes = arr.getBytes();
        char[] base16Chars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            base16Chars[i * 2] = chars[v >>> 4];
            base16Chars[i * 2 + 1] = chars[v & 0xF];
        }
        return new String(base16Chars);
    }
}

