/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.c14n.Canonicalizer;
import org.apache.axiom.c14n.exceptions.CanonicalizationException;
import org.apache.axiom.om.DeferredParsingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.ballerinalang.model.TableOMDataSource;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.JsonParser;
import org.ballerinalang.model.util.StringUtils;
import org.ballerinalang.model.util.XMLNodeType;
import org.ballerinalang.model.util.XMLValidationUtils;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BTable;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.model.values.BXMLItem;
import org.ballerinalang.model.values.BXMLQName;
import org.ballerinalang.model.values.BXMLSequence;
import org.ballerinalang.util.exceptions.BallerinaException;

public class XMLUtils {
    private static final String XML_NAMESPACE_PREFIX = "xmlns:";
    private static final String XML_VALUE_TAG = "#text";
    private static final String XML_DCLR_START = "<?xml";
    private static Canonicalizer canonicalizer = null;
    private static final OMFactory OM_FACTORY = OMAbstractFactory.getOMFactory();
    public static final StAXParserConfiguration STAX_PARSER_CONFIGURATION = StAXParserConfiguration.STANDALONE;

    public static BXML<?> parse(String xmlStr) {
        try {
            if (xmlStr.isEmpty()) {
                return new BXMLItem(new TextImpl());
            }
            if (xmlStr.trim().startsWith(XML_DCLR_START)) {
                return new BXMLItem(xmlStr);
            }
            OMElement omElement = XMLUtils.stringToOM("<root>" + xmlStr + "</root>");
            Iterator children = omElement.getChildren();
            OMNode omNode = null;
            if (children.hasNext()) {
                omNode = (OMNode)children.next();
            }
            if (children.hasNext()) {
                throw new BallerinaException("xml item must be one of the types: 'element', 'comment', 'text', 'pi'");
            }
            omNode = omNode.detach();
            OMDocument doc = OM_FACTORY.createOMDocument();
            doc.addChild(omNode);
            return new BXMLItem(omNode);
        }
        catch (BallerinaException e) {
            throw e;
        }
        catch (XMLStreamException | OMException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            throw new BallerinaException(cause.getMessage());
        }
        catch (Throwable e) {
            throw new BallerinaException("failed to parse xml: " + e.getMessage());
        }
    }

    public static BXML<?> parse(InputStream xmlStream) {
        BValueArray elementsSeq = new BValueArray();
        try {
            OMDocument doc = OMXMLBuilderFactory.createOMBuilder(STAX_PARSER_CONFIGURATION, xmlStream).getDocument();
            Iterator docChildItr = doc.getChildren();
            int i = 0;
            while (docChildItr.hasNext()) {
                elementsSeq.add((long)i++, new BXMLItem((OMNode)docChildItr.next()));
            }
        }
        catch (DeferredParsingException e) {
            throw new BallerinaException(e.getCause().getMessage());
        }
        catch (Throwable e) {
            throw new BallerinaException("failed to create xml: " + e.getMessage());
        }
        return new BXMLSequence(elementsSeq);
    }

    public static BXML<?> parse(InputStream xmlStream, String charset) {
        BValueArray elementsSeq = new BValueArray();
        try {
            OMDocument doc = OMXMLBuilderFactory.createOMBuilder(STAX_PARSER_CONFIGURATION, xmlStream, charset).getDocument();
            Iterator docChildItr = doc.getChildren();
            int index = 0;
            while (docChildItr.hasNext()) {
                elementsSeq.add((long)index++, new BXMLItem((OMNode)docChildItr.next()));
            }
        }
        catch (DeferredParsingException e) {
            throw new BallerinaException(e.getCause().getMessage());
        }
        catch (Throwable e) {
            throw new BallerinaException("failed to create xml: " + e.getMessage());
        }
        return new BXMLSequence(elementsSeq);
    }

    public static BXML<?> parse(Reader reader) {
        BValueArray elementsSeq = new BValueArray();
        try {
            OMDocument doc = OMXMLBuilderFactory.createOMBuilder(STAX_PARSER_CONFIGURATION, reader).getDocument();
            Iterator docChildItr = doc.getChildren();
            int i = 0;
            while (docChildItr.hasNext()) {
                elementsSeq.add((long)i++, new BXMLItem((OMNode)docChildItr.next()));
            }
        }
        catch (DeferredParsingException e) {
            throw new BallerinaException(e.getCause().getMessage());
        }
        catch (Throwable e) {
            throw new BallerinaException("failed to create xml: " + e.getMessage());
        }
        return new BXMLSequence(elementsSeq);
    }

    public static BXML<?> concatenate(BXML<?> firstSeq, BXML<?> secondSeq) {
        int i;
        BValueArray seq;
        BValueArray concatSeq = new BValueArray();
        int j = 0;
        firstSeq.build();
        secondSeq.build();
        if (firstSeq.getNodeType() == XMLNodeType.SEQUENCE) {
            seq = ((BXMLSequence)firstSeq).value();
            i = 0;
            while ((long)i < seq.size()) {
                concatSeq.add((long)j++, seq.getRefValue(i));
                ++i;
            }
        } else {
            concatSeq.add((long)j++, firstSeq);
        }
        if (secondSeq.getNodeType() == XMLNodeType.SEQUENCE) {
            seq = ((BXMLSequence)secondSeq).value();
            i = 0;
            while ((long)i < seq.size()) {
                concatSeq.add((long)j++, seq.getRefValue(i));
                ++i;
            }
        } else {
            concatSeq.add((long)j++, secondSeq);
        }
        return new BXMLSequence(concatSeq);
    }

    public static BXML tableToXML(BTable table2) {
        OMSourcedElementImpl omSourcedElement = new OMSourcedElementImpl();
        omSourcedElement.init(new TableOMDataSource(table2, null, null));
        return new BXMLItem(omSourcedElement);
    }

    public static BXML<?> createXMLElement(BXMLQName startTagName, BXMLQName endTagName, String defaultNsUri) {
        OMElement omElement;
        String prefix;
        if (!(StringUtils.isEqual(startTagName.getLocalName(), endTagName.getLocalName()) && StringUtils.isEqual(startTagName.getUri(), endTagName.getUri()) && StringUtils.isEqual(startTagName.getPrefix(), endTagName.getPrefix()))) {
            throw new BallerinaException("start and end tag names mismatch: '" + startTagName + "' and '" + endTagName + "'");
        }
        XMLValidationUtils.validateXMLQName(startTagName);
        String nsUri = startTagName.getUri();
        if (defaultNsUri == null) {
            defaultNsUri = "";
        }
        String string2 = prefix = startTagName.getPrefix() == null ? "" : startTagName.getPrefix();
        if (nsUri == null) {
            omElement = OM_FACTORY.createOMElement(startTagName.getLocalName(), defaultNsUri, prefix);
        } else if (nsUri.isEmpty()) {
            omElement = OM_FACTORY.createOMElement(startTagName.getLocalName(), nsUri, prefix);
        } else if (nsUri.equals(defaultNsUri)) {
            omElement = OM_FACTORY.createOMElement(startTagName.getLocalName(), defaultNsUri, prefix);
        } else {
            QName qname = XMLUtils.getQName(startTagName.getLocalName(), nsUri, prefix);
            omElement = OM_FACTORY.createOMElement(qname);
            if (!defaultNsUri.isEmpty()) {
                omElement.declareDefaultNamespace(defaultNsUri);
            }
        }
        return new BXMLItem(omElement);
    }

    public static BXML<?> createXMLComment(String content) {
        OMComment omComment = OM_FACTORY.createOMComment(OM_FACTORY.createOMDocument(), content);
        return new BXMLItem(omComment);
    }

    public static BXML<?> createXMLText(String content) {
        content = content.replace("\r\n", "\n");
        content = content.replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&");
        OMText omText = OM_FACTORY.createOMText(content);
        return new BXMLItem(omText);
    }

    public static BXML<?> createXMLProcessingInstruction(String tartget, String data) {
        OMProcessingInstruction omText = OM_FACTORY.createOMProcessingInstruction(OM_FACTORY.createOMDocument(), tartget, data);
        return new BXMLItem(omText);
    }

    public static BValue convertToJSON(BXML xml2, String attributePrefix, boolean preserveNamespaces) {
        BRefType json = null;
        if (xml2 instanceof BXMLItem) {
            BXMLItem xmlItem = (BXMLItem)xml2;
            OMNode omNode = xmlItem.value();
            json = 1 == omNode.getType() ? XMLUtils.traverseXMLElement((OMElement)omNode, attributePrefix, preserveNamespaces) : (4 == omNode.getType() ? JsonParser.parse("\"" + ((OMText)omNode).getText() + "\"") : new BMap(BTypes.typeJSON));
        } else {
            BXMLSequence xmlSequence = (BXMLSequence)xml2;
            if (xmlSequence.isEmpty().booleanValue()) {
                return new BValueArray(new BArrayType(BTypes.typeJSON));
            }
            json = XMLUtils.traverseXMLSequence(xmlSequence, attributePrefix, preserveNamespaces);
        }
        return json;
    }

    public static boolean isEqual(BXML<?> xmlOne, BXML<?> xmlTwo) {
        XMLNodeType xmlOneNodeType = xmlOne.getNodeType();
        XMLNodeType xmlTwoNodeType = xmlTwo.getNodeType();
        try {
            if (xmlOneNodeType == XMLNodeType.SEQUENCE && xmlTwoNodeType == XMLNodeType.SEQUENCE) {
                return XMLUtils.isXmlSequenceEqual((BXMLSequence)xmlOne, (BXMLSequence)xmlTwo);
            }
            if (xmlOneNodeType != XMLNodeType.SEQUENCE && xmlTwoNodeType != XMLNodeType.SEQUENCE) {
                return XMLUtils.isXmlItemEqual((BXMLItem)xmlOne, (BXMLItem)xmlTwo);
            }
            if (xmlOneNodeType == XMLNodeType.SEQUENCE && xmlOne.isSingleton().booleanValue()) {
                return XMLUtils.isXmlSingletonSequenceItemEqual((BXMLSequence)xmlOne, (BXMLItem)xmlTwo);
            }
            if (xmlTwoNodeType == XMLNodeType.SEQUENCE && xmlTwo.isSingleton().booleanValue()) {
                return XMLUtils.isXmlSingletonSequenceItemEqual((BXMLSequence)xmlTwo, (BXMLItem)xmlOne);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isXmlSequenceEqual(BXMLSequence xmlSequenceOne, BXMLSequence xmlSequenceTwo) {
        if (xmlSequenceOne.size() != xmlSequenceTwo.size()) {
            return false;
        }
        int i = 0;
        while ((long)i < xmlSequenceOne.value().size()) {
            if (!XMLUtils.isEqual((BXML)xmlSequenceOne.value().getRefValue(i), (BXML)xmlSequenceTwo.value().getRefValue(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isXmlItemEqual(BXMLItem xmlItemOne, BXMLItem xmlItemTwo) throws CanonicalizationException {
        switch (xmlItemOne.getNodeType()) {
            case ELEMENT: {
                return Arrays.equals(XMLUtils.canonicalize(xmlItemOne), XMLUtils.canonicalize(xmlItemTwo));
            }
        }
        return xmlItemOne.stringValue().equals(xmlItemTwo.stringValue());
    }

    private static boolean isXmlSingletonSequenceItemEqual(BXMLSequence singletonXmlSequence, BXMLItem xmlItem) throws CanonicalizationException {
        switch (xmlItem.getNodeType()) {
            case ELEMENT: {
                return Arrays.equals(XMLUtils.canonicalize((BXMLItem)singletonXmlSequence.getItem(0L)), XMLUtils.canonicalize(xmlItem));
            }
        }
        return singletonXmlSequence.getItem(0L).stringValue().equals(xmlItem.stringValue());
    }

    private static byte[] canonicalize(BXMLItem bxmlItem) throws CanonicalizationException {
        return canonicalizer.canonicalize(bxmlItem.value().toString().getBytes());
    }

    private static BMap<String, BRefType<?>> traverseXMLElement(OMElement omElement, String attributePrefix, boolean preserveNamespaces) {
        BMap rootNode = new BMap(BTypes.typeJSON);
        LinkedHashMap<String, String> attributeMap = XMLUtils.collectAttributesAndNamespaces(omElement, preserveNamespaces);
        Iterator iterator = omElement.getChildElements();
        String keyValue = XMLUtils.getElementKey(omElement, preserveNamespaces);
        if (iterator.hasNext()) {
            BMap currentRoot = new BMap(BTypes.typeJSON);
            ArrayList<OMElement> childArray = new ArrayList<OMElement>();
            LinkedHashMap rootMap = new LinkedHashMap();
            while (iterator.hasNext()) {
                OMNode node = (OMNode)iterator.next();
                if (1 != node.getType()) continue;
                OMElement omChildElement = (OMElement)node;
                LinkedHashMap<String, String> childAttributeMap = XMLUtils.collectAttributesAndNamespaces(omChildElement, preserveNamespaces);
                Iterator iteratorChild = omChildElement.getChildElements();
                String childKeyValue = XMLUtils.getElementKey(omChildElement, preserveNamespaces);
                if (iteratorChild.hasNext()) {
                    BMap<String, BRefType<?>> nodeIntermediate = XMLUtils.traverseXMLElement(omChildElement, attributePrefix, preserveNamespaces);
                    XMLUtils.addToRootMap(rootMap, childKeyValue, nodeIntermediate.get(childKeyValue));
                    continue;
                }
                if (childAttributeMap.size() > 0) {
                    BMap<String, BRefType<?>> attrObject = XMLUtils.processAttributeAndNamespaces(null, childAttributeMap, attributePrefix, omChildElement.getText());
                    XMLUtils.addToRootMap(rootMap, childKeyValue, attrObject);
                    continue;
                }
                childArray.add(omChildElement);
            }
            XMLUtils.processAttributeAndNamespaces(currentRoot, attributeMap, attributePrefix, null);
            XMLUtils.processChildelements(currentRoot, childArray, attributePrefix, preserveNamespaces);
            XMLUtils.processRootNodes(currentRoot, rootMap);
            rootNode.put(keyValue, currentRoot);
        } else if (attributeMap.size() > 0) {
            BMap<String, BRefType<?>> attrObject = XMLUtils.processAttributeAndNamespaces(null, attributeMap, attributePrefix, omElement.getText());
            rootNode.put(keyValue, attrObject);
        } else {
            rootNode.put(keyValue, new BString(omElement.getText()));
        }
        return rootNode;
    }

    private static BValue traverseXMLSequence(BXMLSequence xmlSequence, String attributePrefix, boolean preserveNamespaces) {
        BValueArray sequence = xmlSequence.value();
        long count = sequence.size();
        ArrayList<OMElement> childArray = new ArrayList<OMElement>();
        ArrayList<OMText> textArray = new ArrayList<OMText>();
        for (long i = 0L; i < count; ++i) {
            BXMLItem xmlItem = (BXMLItem)sequence.getRefValue(i);
            OMNode omNode = xmlItem.value();
            if (1 == omNode.getType()) {
                childArray.add((OMElement)omNode);
                continue;
            }
            if (4 != omNode.getType()) continue;
            textArray.add((OMText)omNode);
        }
        BValueArray textArrayNode = null;
        if (textArray.size() > 0) {
            textArrayNode = XMLUtils.processTextArray(textArray);
        }
        BMap jsonNode = new BMap(BTypes.typeJSON);
        if (childArray.size() > 0) {
            XMLUtils.processChildelements(jsonNode, childArray, attributePrefix, preserveNamespaces);
            if (textArrayNode != null) {
                textArrayNode.append(jsonNode);
            }
        }
        if (textArrayNode != null) {
            return textArrayNode;
        }
        return jsonNode;
    }

    private static void processChildelements(BMap<String, BRefType<?>> root, ArrayList<OMElement> childArray, String attributePrefix, boolean preserveNamespaces) {
        LinkedHashMap rootMap = new LinkedHashMap();
        for (OMElement oMElement : childArray) {
            String key = oMElement.getLocalName();
            rootMap.putIfAbsent(key, new ArrayList());
            ((ArrayList)rootMap.get(key)).add(oMElement);
        }
        for (Map.Entry entry : rootMap.entrySet()) {
            ArrayList elementList = (ArrayList)entry.getValue();
            if (elementList.size() <= 0) continue;
            String nodeKey = XMLUtils.getElementKey((OMElement)elementList.get(0), preserveNamespaces);
            if (elementList.size() == 1) {
                OMElement element = (OMElement)elementList.get(0);
                if (element.getChildElements().hasNext()) {
                    BMap<String, BRefType<?>> node = XMLUtils.traverseXMLElement(element, attributePrefix, preserveNamespaces);
                    root.put(nodeKey, node.get(nodeKey));
                    continue;
                }
                root.put(nodeKey, new BString(((OMElement)elementList.get(0)).getText()));
                continue;
            }
            BValueArray arrayNode = new BValueArray(new BArrayType(BTypes.typeJSON));
            for (OMElement element : elementList) {
                arrayNode.append(new BString(element.getText()));
            }
            root.put(nodeKey, arrayNode);
        }
    }

    private static void processRootNodes(BMap<String, BRefType<?>> root, LinkedHashMap<String, ArrayList<BRefType<?>>> rootMap) {
        for (Map.Entry<String, ArrayList<BRefType<?>>> entry : rootMap.entrySet()) {
            String key = entry.getKey();
            ArrayList<BRefType<?>> elementList = entry.getValue();
            int elementCount = elementList.size();
            if (elementCount == 1) {
                root.put(key, (BRefType<?>)((BValue)elementList.get(0)));
                continue;
            }
            BValueArray arrayNode = new BValueArray(new BArrayType(BTypes.typeJSON));
            for (BRefType<?> node : elementList) {
                arrayNode.append(node);
            }
            root.put(key, arrayNode);
        }
    }

    private static LinkedHashMap<String, String> collectAttributesAndNamespaces(OMElement element, boolean preserveNamespaces) {
        LinkedHashMap<String, String> attributeMap = new LinkedHashMap<String, String>();
        if (preserveNamespaces) {
            Iterator namespaceIterator = element.getAllDeclaredNamespaces();
            while (namespaceIterator.hasNext()) {
                OMNamespace namespace = (OMNamespace)namespaceIterator.next();
                attributeMap.put(XML_NAMESPACE_PREFIX + namespace.getPrefix(), namespace.getNamespaceURI());
            }
        }
        Iterator attributeIterator = element.getAllAttributes();
        while (attributeIterator.hasNext()) {
            String prefix;
            OMAttribute attribute = (OMAttribute)attributeIterator.next();
            StringBuffer key = new StringBuffer();
            if (preserveNamespaces && (prefix = attribute.getPrefix()) != null) {
                key.append(prefix).append(":");
            }
            key.append(attribute.getLocalName());
            attributeMap.put(key.toString(), attribute.getAttributeValue());
        }
        return attributeMap;
    }

    private static BMap<String, BRefType<?>> processAttributeAndNamespaces(BMap<String, BRefType<?>> rootNode, LinkedHashMap<String, String> attributeMap, String attributePrefix, String singleElementValue) {
        boolean singleElement = false;
        if (rootNode == null) {
            rootNode = new BMap(BTypes.typeJSON);
            singleElement = true;
        }
        for (Map.Entry<String, String> entry : attributeMap.entrySet()) {
            String key = attributePrefix + entry.getKey();
            rootNode.put(key, new BString(entry.getValue()));
        }
        if (singleElement && !singleElementValue.isEmpty()) {
            rootNode.put(XML_VALUE_TAG, new BString(singleElementValue));
        }
        return rootNode;
    }

    private static BValueArray processTextArray(ArrayList<OMText> childArray) {
        BValueArray arrayNode = new BValueArray(new BArrayType(BTypes.typeJSON));
        for (OMText element : childArray) {
            arrayNode.append(new BString(element.getText()));
        }
        return arrayNode;
    }

    private static String getElementKey(OMElement omElement, boolean preserveNamespaces) {
        String prefix;
        StringBuffer stringBuffer = new StringBuffer();
        if (preserveNamespaces && (prefix = omElement.getPrefix()) != null) {
            stringBuffer.append(prefix).append(":");
        }
        stringBuffer.append(omElement.getLocalName());
        return stringBuffer.toString();
    }

    private static void addToRootMap(LinkedHashMap<String, ArrayList<BRefType<?>>> rootMap, String key, BRefType<?> node) {
        rootMap.putIfAbsent(key, new ArrayList());
        rootMap.get(key).add(node);
    }

    private static QName getQName(String localName, String namespaceUri, String prefix) {
        QName qname = prefix != null ? new QName(namespaceUri, localName, prefix) : new QName(namespaceUri, localName);
        return qname;
    }

    public static OMElement stringToOM(String xmlFragment) throws XMLStreamException {
        return XMLUtils.stringToOM(OMAbstractFactory.getOMFactory(), xmlFragment);
    }

    private static OMElement stringToOM(OMFactory omFactory, String xmlFragment) throws XMLStreamException {
        return xmlFragment != null ? OMXMLBuilderFactory.createOMBuilder(omFactory, STAX_PARSER_CONFIGURATION, new StringReader(xmlFragment)).getDocumentElement() : null;
    }

    static {
        Canonicalizer.init();
    }
}

