/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer.providers.bvalue;

import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.XMLUtils;
import org.ballerinalang.model.util.serializer.BPacket;
import org.ballerinalang.model.util.serializer.BValueDeserializer;
import org.ballerinalang.model.util.serializer.BValueSerializer;
import org.ballerinalang.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.model.values.BXMLItem;
import org.ballerinalang.model.values.BXMLQName;
import org.ballerinalang.model.values.BXMLSequence;

public class BXMLBValueProviders {
    private BXMLBValueProviders() {
    }

    public static class BXMLQNameBValueProvider
    implements SerializationBValueProvider<BXMLQName> {
        static final String LOCAL = "LOCAL";
        static final String PREFIX = "PREFIX";

        @Override
        public String typeName() {
            return this.getType().getSimpleName();
        }

        @Override
        public Class<?> getType() {
            return BXMLQName.class;
        }

        @Override
        public BPacket toBValue(BXMLQName bxmlqName, BValueSerializer serializer) {
            return BPacket.from(this.typeName(), new BString(bxmlqName.getUri())).put(LOCAL, new BString(bxmlqName.getLocalName())).put(PREFIX, new BString(bxmlqName.getPrefix()));
        }

        @Override
        public BXMLQName toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            String uri = packet.getValue().stringValue();
            String local = packet.get(LOCAL).stringValue();
            String prefix = packet.get(PREFIX).stringValue();
            return new BXMLQName(local, uri, prefix);
        }
    }

    public static class BXMLSequenceBValueProvider
    implements SerializationBValueProvider<BXMLSequence> {
        @Override
        public String typeName() {
            return this.getType().getSimpleName();
        }

        @Override
        public Class<?> getType() {
            return BXMLSequence.class;
        }

        @Override
        public BPacket toBValue(BXMLSequence bxmlSequence, BValueSerializer serializer) {
            BRefType[] serializedItems = new BRefType[(int)bxmlSequence.size()];
            int i = 0;
            while ((long)i < bxmlSequence.size()) {
                BRefType value2;
                serializedItems[i] = value2 = (BRefType)serializer.toBValue(bxmlSequence.value().getRefValue(i), null);
                ++i;
            }
            BValueArray array2 = new BValueArray(serializedItems, new BArrayType(BTypes.typeAny));
            return BPacket.from(this.typeName(), array2);
        }

        @Override
        public BXMLSequence toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            BValueArray srcArray = (BValueArray)packet.getValue();
            BRefType[] values = new BRefType[(int)srcArray.size()];
            int i = 0;
            while ((long)i < srcArray.size()) {
                values[i] = (BXML)bValueDeserializer.deserialize(srcArray.getRefValue(i), Object.class);
                ++i;
            }
            BValueArray xmlItemArray = new BValueArray(values, new BArrayType(BTypes.typeXML));
            return new BXMLSequence(xmlItemArray);
        }
    }

    public static class BXMLItemBValueProvider
    implements SerializationBValueProvider<BXMLItem> {
        @Override
        public String typeName() {
            return this.getType().getSimpleName();
        }

        @Override
        public Class<?> getType() {
            return BXMLItem.class;
        }

        @Override
        public BPacket toBValue(BXMLItem object, BValueSerializer serializer) {
            return BPacket.from(this.typeName(), new BString(object.toString()));
        }

        @Override
        public BXMLItem toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            String s = packet.getValue().stringValue();
            return (BXMLItem)XMLUtils.parse(s);
        }
    }
}

