/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Map;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.DecimalValueKind;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.BallerinaException;

public final class BDecimal
extends BValueType
implements BRefType<BigDecimal> {
    private static final BDecimal POSITIVE_INF = new BDecimal("9.999999999999999999999999999999999E6144", DecimalValueKind.POSITIVE_INFINITY);
    private static final BDecimal NEGATIVE_INF = new BDecimal("-9.999999999999999999999999999999999E6144", DecimalValueKind.NEGATIVE_INFINITY);
    private static final BDecimal NaN = new BDecimal("-1", DecimalValueKind.NOT_A_NUMBER);
    public DecimalValueKind valueKind = DecimalValueKind.OTHER;
    private BigDecimal value;

    public BDecimal(BigDecimal value2) {
        this.value = value2;
        if (!this.booleanValue()) {
            this.valueKind = DecimalValueKind.ZERO;
        }
    }

    public BDecimal(String value2) {
        this.value = BDecimal.isHexValueString(value2) ? BDecimal.hexToDecimalFloatingPointNumber(value2) : new BigDecimal(value2, MathContext.DECIMAL128);
        if (!this.booleanValue()) {
            this.valueKind = DecimalValueKind.ZERO;
        }
    }

    public BDecimal(String value2, DecimalValueKind valueKind) {
        this(value2);
        this.valueKind = valueKind;
    }

    private static boolean isHexValueString(String value2) {
        String upperCaseValue = value2.toUpperCase();
        return upperCaseValue.startsWith("0X") || upperCaseValue.startsWith("-0X");
    }

    private static BigDecimal hexToDecimalFloatingPointNumber(String value2) {
        String intComponent;
        String upperCaseValue = value2.toUpperCase();
        String hexValue = upperCaseValue.replace("0X", "");
        if (!hexValue.contains("P")) {
            hexValue = hexValue.concat("P0");
        }
        String[] splitAtExponent = hexValue.split("P");
        int binaryExponent = Integer.parseInt(splitAtExponent[1]);
        String numberWithoutExp = splitAtExponent[0];
        if (numberWithoutExp.contains(".")) {
            String[] numberComponents = numberWithoutExp.split("\\.");
            intComponent = numberComponents[0];
            String decimalComponent = numberComponents[1];
            binaryExponent += -4 * decimalComponent.length();
            intComponent = intComponent.concat(decimalComponent);
        } else {
            intComponent = numberWithoutExp;
        }
        BigDecimal exponentValue = binaryExponent >= 0 ? new BigDecimal(2).pow(binaryExponent) : BigDecimal.ONE.divide(new BigDecimal(2).pow(-binaryExponent), MathContext.DECIMAL128);
        BigInteger hexEquivalentNumber = new BigInteger(intComponent, 16);
        return new BigDecimal(hexEquivalentNumber).multiply(exponentValue, MathContext.DECIMAL128);
    }

    @Override
    public BigDecimal decimalValue() {
        return this.value;
    }

    @Override
    public long intValue() {
        switch (this.valueKind) {
            case NOT_A_NUMBER: {
                throw new BallerinaException(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'decimal' value '" + NaN + "' cannot be converted to 'int'");
            }
            case NEGATIVE_INFINITY: {
                throw new BallerinaException(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'decimal' value '" + NEGATIVE_INF + "' cannot be converted to 'int'");
            }
            case POSITIVE_INFINITY: {
                throw new BallerinaException(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'decimal' value '" + POSITIVE_INF + "' cannot be converted to 'int'");
            }
        }
        return Math.round(this.value.doubleValue());
    }

    @Override
    public long byteValue() {
        switch (this.valueKind) {
            case NOT_A_NUMBER: {
                throw new BallerinaException(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'decimal' value '" + NaN + "' cannot be converted to 'byte'");
            }
            case NEGATIVE_INFINITY: {
                throw new BallerinaException(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'decimal' value '" + NEGATIVE_INF + "' cannot be converted to 'byte'");
            }
            case POSITIVE_INFINITY: {
                throw new BallerinaException(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'decimal' value '" + POSITIVE_INF + "' cannot be converted to 'byte'");
            }
        }
        return Math.round(this.value.doubleValue());
    }

    @Override
    public double floatValue() {
        if (this.valueKind == DecimalValueKind.NOT_A_NUMBER) {
            return Double.NaN;
        }
        return this.value.doubleValue();
    }

    @Override
    public boolean booleanValue() {
        return this.value.compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public void setType(BType type) {
    }

    @Override
    public String stringValue() {
        if (this.valueKind != DecimalValueKind.OTHER) {
            return this.valueKind.getValue();
        }
        return this.value.toString();
    }

    @Override
    public BigDecimal value() {
        return this.value;
    }

    @Override
    public BType getType() {
        return BTypes.typeDecimal;
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return this;
    }

    public BDecimal add(BDecimal augend) {
        switch (this.valueKind) {
            case ZERO: {
                return augend;
            }
            case POSITIVE_INFINITY: {
                if (augend.valueKind == DecimalValueKind.NEGATIVE_INFINITY || augend.valueKind == DecimalValueKind.NOT_A_NUMBER) {
                    return NaN;
                }
                return POSITIVE_INF;
            }
            case NEGATIVE_INFINITY: {
                if (augend.valueKind == DecimalValueKind.POSITIVE_INFINITY || augend.valueKind == DecimalValueKind.NOT_A_NUMBER) {
                    return NaN;
                }
                return NEGATIVE_INF;
            }
            case NOT_A_NUMBER: {
                return NaN;
            }
        }
        if (augend.valueKind == DecimalValueKind.ZERO) {
            return this;
        }
        if (augend.valueKind == DecimalValueKind.OTHER) {
            return new BDecimal(this.decimalValue().add(augend.decimalValue(), MathContext.DECIMAL128));
        }
        return augend;
    }

    public BDecimal subtract(BDecimal subtrahend) {
        switch (this.valueKind) {
            case ZERO: {
                if (subtrahend.valueKind == DecimalValueKind.ZERO || subtrahend.valueKind == DecimalValueKind.NOT_A_NUMBER) {
                    return subtrahend;
                }
                return subtrahend.negate();
            }
            case POSITIVE_INFINITY: {
                if (subtrahend.valueKind == DecimalValueKind.POSITIVE_INFINITY || subtrahend.valueKind == DecimalValueKind.NOT_A_NUMBER) {
                    return NaN;
                }
                return POSITIVE_INF;
            }
            case NEGATIVE_INFINITY: {
                if (subtrahend.valueKind == DecimalValueKind.NEGATIVE_INFINITY || subtrahend.valueKind == DecimalValueKind.NOT_A_NUMBER) {
                    return NaN;
                }
                return NEGATIVE_INF;
            }
            case NOT_A_NUMBER: {
                return NaN;
            }
        }
        if (subtrahend.valueKind == DecimalValueKind.ZERO) {
            return this;
        }
        if (subtrahend.valueKind == DecimalValueKind.OTHER) {
            return new BDecimal(this.decimalValue().subtract(subtrahend.decimalValue(), MathContext.DECIMAL128));
        }
        return subtrahend.negate();
    }

    public BDecimal multiply(BDecimal multiplicand) {
        switch (this.valueKind) {
            case ZERO: {
                if (multiplicand.valueKind == DecimalValueKind.ZERO || multiplicand.valueKind == DecimalValueKind.OTHER) {
                    return this;
                }
                return NaN;
            }
            case POSITIVE_INFINITY: {
                if (multiplicand.valueKind == DecimalValueKind.ZERO || multiplicand.valueKind == DecimalValueKind.NOT_A_NUMBER) {
                    return NaN;
                }
                if (multiplicand.decimalValue().compareTo(BigDecimal.ZERO) > 0) {
                    return POSITIVE_INF;
                }
                return NEGATIVE_INF;
            }
            case NEGATIVE_INFINITY: {
                if (multiplicand.valueKind == DecimalValueKind.ZERO || multiplicand.valueKind == DecimalValueKind.NOT_A_NUMBER) {
                    return NaN;
                }
                if (multiplicand.decimalValue().compareTo(BigDecimal.ZERO) > 0) {
                    return NEGATIVE_INF;
                }
                return POSITIVE_INF;
            }
            case NOT_A_NUMBER: {
                return NaN;
            }
        }
        if (multiplicand.valueKind == DecimalValueKind.OTHER) {
            return new BDecimal(this.decimalValue().multiply(multiplicand.decimalValue(), MathContext.DECIMAL128));
        }
        if (this.decimalValue().compareTo(BigDecimal.ZERO) > 0) {
            return multiplicand;
        }
        return multiplicand.negate();
    }

    public BDecimal divide(BDecimal divisor) {
        switch (this.valueKind) {
            case ZERO: {
                if (divisor.valueKind == DecimalValueKind.ZERO || divisor.valueKind == DecimalValueKind.NOT_A_NUMBER) {
                    return NaN;
                }
                return this;
            }
            case POSITIVE_INFINITY: {
                if (divisor.valueKind == DecimalValueKind.ZERO || divisor.valueKind == DecimalValueKind.OTHER && divisor.decimalValue().compareTo(BigDecimal.ZERO) > 0) {
                    return POSITIVE_INF;
                }
                if (divisor.valueKind == DecimalValueKind.OTHER && divisor.decimalValue().compareTo(BigDecimal.ZERO) < 0) {
                    return NEGATIVE_INF;
                }
                return NaN;
            }
            case NEGATIVE_INFINITY: {
                if (divisor.valueKind == DecimalValueKind.ZERO || divisor.valueKind == DecimalValueKind.OTHER && divisor.decimalValue().compareTo(BigDecimal.ZERO) > 0) {
                    return NEGATIVE_INF;
                }
                if (divisor.valueKind == DecimalValueKind.OTHER && divisor.decimalValue().compareTo(BigDecimal.ZERO) < 0) {
                    return POSITIVE_INF;
                }
                return NaN;
            }
            case NOT_A_NUMBER: {
                return NaN;
            }
        }
        if (divisor.valueKind == DecimalValueKind.OTHER) {
            return new BDecimal(this.decimalValue().divide(divisor.decimalValue(), MathContext.DECIMAL128));
        }
        if (divisor.valueKind == DecimalValueKind.POSITIVE_INFINITY || divisor.valueKind == DecimalValueKind.NEGATIVE_INFINITY) {
            return new BDecimal(BigDecimal.ZERO);
        }
        if (divisor.valueKind == DecimalValueKind.NOT_A_NUMBER) {
            return NaN;
        }
        return this.decimalValue().compareTo(BigDecimal.ZERO) > 0 ? POSITIVE_INF : NEGATIVE_INF;
    }

    public BDecimal remainder(BDecimal divisor) {
        switch (this.valueKind) {
            case ZERO: 
            case OTHER: {
                if (divisor.valueKind == DecimalValueKind.OTHER) {
                    return new BDecimal(this.decimalValue().remainder(divisor.decimalValue(), MathContext.DECIMAL128));
                }
                if (divisor.valueKind == DecimalValueKind.ZERO || divisor.valueKind == DecimalValueKind.NOT_A_NUMBER) {
                    return NaN;
                }
                return this;
            }
        }
        return NaN;
    }

    public BDecimal negate() {
        switch (this.valueKind) {
            case OTHER: {
                return new BDecimal(this.decimalValue().negate());
            }
            case POSITIVE_INFINITY: {
                return NEGATIVE_INF;
            }
            case NEGATIVE_INFINITY: {
                return POSITIVE_INF;
            }
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BDecimal bDecimal = (BDecimal)obj;
        return this.value.compareTo(bDecimal.value) == 0 && this.valueKind == bDecimal.valueKind;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

