/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Map;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.BallerinaException;

public final class BFloat
extends BValueType
implements BRefType<Double> {
    private double value;
    private BType type = BTypes.typeFloat;

    public BFloat(double value2) {
        this.value = value2;
    }

    @Override
    public long intValue() {
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            throw new BallerinaException(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'float' value '" + this.value + "' cannot be converted to 'int'");
        }
        return Math.round(this.value);
    }

    @Override
    public long byteValue() {
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            throw new BallerinaException(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'float' value '" + this.value + "' cannot be converted to 'byte'");
        }
        return Math.round(this.value);
    }

    @Override
    public double floatValue() {
        return this.value;
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this.value, MathContext.DECIMAL128);
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0.0;
    }

    @Override
    public String stringValue() {
        return Double.toString(this.value);
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public void setType(BType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BFloat bFloat = (BFloat)o;
        return Double.compare(bFloat.value, this.value) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.value);
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public Double value() {
        return this.value;
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return this;
    }
}

