/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.Map;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;

public final class BXMLQName
implements BRefType {
    private String localName;
    private String uri;
    private String prefix;

    public BXMLQName(String localName, String uri, String prefix) {
        this.localName = localName;
        this.uri = uri;
        this.prefix = prefix;
    }

    @Override
    public String stringValue() {
        return this.uri == null || this.uri.isEmpty() ? this.localName : '{' + this.uri + '}' + this.localName;
    }

    @Override
    public BType getType() {
        return BTypes.typeString;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BXMLQName)) {
            return false;
        }
        return ((BXMLQName)obj).stringValue().equals(this.localName);
    }

    public String value() {
        return null;
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        if (this.isFrozen()) {
            return this;
        }
        return new BXMLQName(this.localName, this.uri, this.prefix);
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String toString() {
        return this.stringValue();
    }
}

