/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.nativeimpl;

import java.util.Set;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.observability.metrics.Counter;
import org.ballerinalang.jvm.observability.metrics.DefaultMetricRegistry;
import org.ballerinalang.jvm.observability.metrics.Gauge;
import org.ballerinalang.jvm.observability.metrics.Metric;
import org.ballerinalang.jvm.observability.metrics.MetricId;
import org.ballerinalang.jvm.observability.metrics.PolledGauge;
import org.ballerinalang.jvm.observability.metrics.Tag;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.observe.nativeimpl.ObserveNativeImplConstants;
import org.ballerinalang.observe.nativeimpl.Utils;

@BallerinaFunction(orgName="ballerina", packageName="observe", functionName="getAllMetrics", returnType={@ReturnType(type=TypeKind.ARRAY)}, isPublic=true)
public class GetAllMetrics {
    private static final BType METRIC_TYPE = BallerinaValues.createRecordValue(ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, "Metric").getType();

    public static ArrayValue getAllMetrics(Strand strand) {
        Metric[] metrics = DefaultMetricRegistry.getInstance().getAllMetrics();
        ArrayValue bMetrics = new ArrayValue(new BArrayType(METRIC_TYPE));
        int metricIndex = 0;
        for (Metric metric : metrics) {
            Metric gauge;
            MetricId metricId = metric.getId();
            Number metricValue = null;
            String metricType = null;
            ArrayValue summary = null;
            if (metric instanceof Counter) {
                metricValue = ((Counter)metric).getValue();
                metricType = "counter";
            } else if (metric instanceof Gauge) {
                gauge = (Gauge)metric;
                metricValue = gauge.getValue();
                metricType = "gauge";
                summary = Utils.createBSnapshots(gauge.getSnapshots(), strand);
            } else if (metric instanceof PolledGauge) {
                gauge = (PolledGauge)metric;
                metricValue = gauge.getValue();
                metricType = "gauge";
            }
            if (metricValue == null) continue;
            MapValue<String, Object> metricStruct = BallerinaValues.createRecordValue(ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, "Metric");
            metricStruct.put("name", metricId.getName());
            metricStruct.put("desc", metricId.getDescription());
            metricStruct.put("tags", GetAllMetrics.getTags(metricId));
            metricStruct.put("metricType", metricType);
            metricStruct.put("value", metricValue);
            metricStruct.put("summary", summary);
            bMetrics.add((long)metricIndex, metricStruct);
            ++metricIndex;
        }
        return bMetrics;
    }

    private static MapValue<String, Object> getTags(MetricId metricId) {
        MapValueImpl<String, Object> bTags = new MapValueImpl<String, Object>(new BMapType(BTypes.typeString));
        Set<Tag> tags = metricId.getTags();
        for (Tag tag : tags) {
            bTags.put(tag.getKey(), tag.getValue());
        }
        return bTags;
    }
}

