/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.nativeimpl;

import io.opentracing.Tracer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.observability.TracingUtils;
import org.ballerinalang.jvm.observability.tracer.TracersStore;
import org.ballerinalang.jvm.scheduling.Strand;

public class OpenTracerBallerinaWrapper {
    private static OpenTracerBallerinaWrapper instance = new OpenTracerBallerinaWrapper();
    private TracersStore tracerStore;
    private final boolean enabled;
    private Map<Long, ObserverContext> observerContextList = new HashMap<Long, ObserverContext>();
    private AtomicLong spanId = new AtomicLong();
    private static final int SYSTEM_TRACE_INDICATOR = -1;
    static final int ROOT_SPAN_INDICATOR = -2;

    private OpenTracerBallerinaWrapper() {
        this.enabled = ConfigRegistry.getInstance().getAsBoolean("b7a.observability.tracing.enabled");
        this.tracerStore = TracersStore.getInstance();
    }

    public static OpenTracerBallerinaWrapper getInstance() {
        return instance;
    }

    private long startSpan(ObserverContext observerContext, boolean isClient, String spanName) {
        observerContext.setActionName(spanName);
        TracingUtils.startObservation(observerContext, isClient);
        long spanId = this.spanId.getAndIncrement();
        this.observerContextList.put(spanId, observerContext);
        return spanId;
    }

    public long startSpan(String serviceName, String spanName, Map<String, String> tags, long parentSpanId, Strand strand) {
        Tracer tracer;
        if (!this.enabled) {
            return -1L;
        }
        if (serviceName == null) {
            serviceName = "Unknown Service";
        }
        if ((tracer = this.tracerStore.getTracer(serviceName)) == null) {
            return -1L;
        }
        ObserverContext observerContext = new ObserverContext();
        observerContext.setServiceName(serviceName);
        observerContext.setResourceName(spanName);
        tags.forEach(observerContext::addTag);
        if (parentSpanId == -1L) {
            observerContext.setSystemSpan(true);
            ObserveUtils.getObserverContextOfCurrentFrame(strand).ifPresent(observerContext::setParent);
            ObserveUtils.setObserverContextToCurrentFrame(strand, observerContext);
            return this.startSpan(observerContext, true, spanName);
        }
        if (parentSpanId != -2L) {
            ObserverContext parentOContext = this.observerContextList.get(parentSpanId);
            if (parentOContext == null) {
                return -1L;
            }
            observerContext.setParent(parentOContext);
            return this.startSpan(observerContext, true, spanName);
        }
        return this.startSpan(observerContext, false, spanName);
    }

    public boolean finishSpan(Strand strand, long spanId) {
        if (!this.enabled) {
            return false;
        }
        ObserverContext observerContext = this.observerContextList.get(spanId);
        if (observerContext != null) {
            if (observerContext.isSystemSpan()) {
                ObserveUtils.setObserverContextToCurrentFrame(strand, observerContext.getParent());
            }
            TracingUtils.stopObservation(observerContext);
            observerContext.setFinished();
            this.observerContextList.remove(spanId);
            return true;
        }
        return false;
    }

    public boolean addTag(String tagKey, String tagValue, long spanId, Strand strand) {
        Optional<ObserverContext> observer;
        if (!this.enabled) {
            return false;
        }
        ObserverContext observerContext = this.observerContextList.get(spanId);
        if (spanId == -1L && (observer = ObserveUtils.getObserverContextOfCurrentFrame(strand)).isPresent()) {
            observer.get().addTag(tagKey, tagValue);
            return true;
        }
        if (observerContext != null) {
            observerContext.addTag(tagKey, tagValue);
            return true;
        }
        return false;
    }
}

