/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.nativeimpl;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.observe.nativeimpl.OpenTracerBallerinaWrapper;
import org.ballerinalang.observe.nativeimpl.Utils;

@BallerinaFunction(orgName="ballerina", packageName="observe", functionName="startSpan", args={@Argument(name="spanName", type=TypeKind.STRING), @Argument(name="tags", type=TypeKind.MAP), @Argument(name="parentSpanId", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.INT)}, isPublic=true)
public class StartSpan {
    public static Object startSpan(Strand strand, String spanName, Object tags, long parentSpanId) {
        if (parentSpanId < -1L) {
            return BallerinaErrors.createError("The given parent span ID " + parentSpanId + " is invalid.");
        }
        long spanId = OpenTracerBallerinaWrapper.getInstance().startSpan((String)strand.getProperty("service_name"), spanName, Utils.toStringMap((MapValue)tags), parentSpanId, strand);
        if (spanId == -1L) {
            return BallerinaErrors.createError("No parent span for ID " + parentSpanId + " found. Please recheck the parent span Id");
        }
        return spanId;
    }
}

