/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TableResourceManager {
    private Connection connection;
    private Statement statement;
    private Set<ResultSet> resultSets;
    private boolean connectionClosable;

    public TableResourceManager(Connection conn, Statement stmt, boolean connectionClosable) {
        this.connection = conn;
        this.statement = stmt;
        this.connectionClosable = connectionClosable;
        this.resultSets = new HashSet<ResultSet>(0);
    }

    public void releaseResources() throws SQLException {
        if (this.statement != null && !this.statement.isClosed()) {
            this.statement.close();
            this.statement = null;
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void addResultSet(ResultSet rs) {
        this.resultSets.add(rs);
    }

    public void addAllResultSets(List<ResultSet> resultSets) {
        this.resultSets.addAll(resultSets);
    }

    public void gracefullyReleaseResources() throws SQLException {
        boolean allResultSetsClosed = true;
        for (ResultSet rs : this.resultSets) {
            if (rs == null || rs.isClosed()) continue;
            allResultSetsClosed = false;
            break;
        }
        if (allResultSetsClosed) {
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
            }
            if (this.connectionClosable && this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
    }
}

