/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.JSONUtils;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.commons.TypeValuePair;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="utils", functionName="convert", args={@Argument(name="convertType", type=TypeKind.TYPEDESC), @Argument(name="value", type=TypeKind.ANY)}, returnType={@ReturnType(type=TypeKind.ANYDATA), @ReturnType(type=TypeKind.ERROR)})
public class Convert {
    public static Object convert(Strand strand, TypedescValue typeDescValue, Object inputValue) {
        BType targetType;
        BType convertType = typeDescValue.getDescribingType();
        if (convertType.getTag() == 21) {
            ArrayList<BType> memberTypes = new ArrayList<BType>(((BUnionType)convertType).getMemberTypes());
            targetType = new BUnionType(memberTypes);
            Predicate<BType> errorPredicate = e -> e.getTag() == 29;
            ((BUnionType)targetType).getMemberTypes().removeIf(errorPredicate);
            if (((BUnionType)targetType).getMemberTypes().size() == 1) {
                targetType = ((BUnionType)convertType).getMemberTypes().get(0);
            }
        } else {
            targetType = convertType;
        }
        if (inputValue == null) {
            if (targetType.getTag() == 7) {
                return null;
            }
            return BallerinaErrors.createError(BallerinaErrorReasons.BALLERINA_PREFIXED_CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.CANNOT_CONVERT_NIL, convertType));
        }
        BType inputValType = TypeChecker.getType(inputValue);
        if (TypeChecker.checkIsLikeType(inputValue, targetType)) {
            if (inputValType.getTag() <= 6) {
                return inputValue;
            }
            try {
                RefValue refValue = (RefValue)inputValue;
                RefValue convertedValue = (RefValue)refValue.copy(new HashMap<Object, Object>());
                convertedValue.stamp(targetType, new ArrayList<TypeValuePair>());
                return convertedValue;
            }
            catch (BallerinaException e2) {
                throw BallerinaErrors.createError(BallerinaErrorReasons.BALLERINA_PREFIXED_CONVERSION_ERROR, e2.getDetail());
            }
        }
        if (inputValType.getTag() == 9) {
            switch (targetType.getTag()) {
                case 7: {
                    return JSONUtils.toJSON((TableValue)inputValue);
                }
            }
        }
        return BallerinaErrors.createConversionError(inputValue, targetType);
    }
}

