/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BFiniteType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="utils", functionName="next", args={@Argument(name="value", type=TypeKind.ANY)}, returnType={@ReturnType(type=TypeKind.ANY)})
public class Next {
    private static final String KEY = "value";

    public static Object next(Strand strand, Object iterator) {
        if (!(iterator instanceof Iterator)) {
            throw new IllegalStateException("Iterator expected");
        }
        Iterator itr = (Iterator)iterator;
        if (!Optional.of(itr).get().hasNext()) {
            return null;
        }
        Object value2 = Optional.of(itr).get().next();
        BMapType mapType = new BMapType(Next.getType(value2));
        MapValueImpl newMap = new MapValueImpl(mapType);
        newMap.put(KEY, value2);
        return newMap;
    }

    private static BType getType(Object value2) {
        if (value2 == null) {
            return BTypes.typeNull;
        }
        if (value2 instanceof Number || value2 instanceof String || value2 instanceof Boolean || value2 instanceof DecimalValue) {
            return Next.getFiniteType(value2);
        }
        return ((RefValue)value2).getType();
    }

    private static BType getFiniteType(Object value2) {
        HashSet<Object> valueSpace = new HashSet<Object>();
        valueSpace.add(value2);
        return new BFiniteType(value2.toString(), valueSpace);
    }
}

