/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.utils;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.TypeConverter;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="utils", functionName="simpleValueConvert", args={@Argument(name="convertType", type=TypeKind.TYPEDESC), @Argument(name="value", type=TypeKind.ANY)}, returnType={@ReturnType(type=TypeKind.ANYDATA), @ReturnType(type=TypeKind.ERROR)})
public class SimpleValueConvert {
    public static Object simpleValueConvert(Strand strand, TypedescValue typedescValue, Object inputValue) {
        BType targetType = typedescValue.getDescribingType();
        if (inputValue == null && targetType.getTag() != 5) {
            return BallerinaErrors.createError(BallerinaErrorReasons.BALLERINA_PREFIXED_CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.CANNOT_CONVERT_NIL, targetType));
        }
        try {
            if (BTypes.isValueType(TypeChecker.getType(inputValue))) {
                return TypeConverter.convertValues(targetType, inputValue);
            }
        }
        catch (ErrorValue e) {
            return e;
        }
        try {
            if (targetType.getTag() == 5) {
                if (inputValue == null) {
                    return "()";
                }
                return ((RefValue)inputValue).stringValue();
            }
            return BallerinaErrors.createConversionError(inputValue, targetType);
        }
        catch (RuntimeException e) {
            return BallerinaErrors.createConversionError(inputValue, targetType);
        }
    }
}

