/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;

public class AlterTableAddConstraint
extends SchemaCommand {
    private int type;
    private String constraintName;
    private String tableName;
    private IndexColumn[] indexColumns;
    private ConstraintActionType deleteAction = ConstraintActionType.RESTRICT;
    private ConstraintActionType updateAction = ConstraintActionType.RESTRICT;
    private Schema refSchema;
    private String refTableName;
    private IndexColumn[] refIndexColumns;
    private Expression checkExpression;
    private Index index;
    private Index refIndex;
    private String comment;
    private boolean checkExisting;
    private boolean primaryKeyHash;
    private boolean ifTableExists;
    private final boolean ifNotExists;
    private final ArrayList<Index> createdIndexes = new ArrayList();

    public AlterTableAddConstraint(Session session, Schema schema, boolean bl) {
        super(session, schema);
        this.ifNotExists = bl;
    }

    public void setIfTableExists(boolean bl) {
        this.ifTableExists = bl;
    }

    private String generateConstraintName(Table table2) {
        if (this.constraintName == null) {
            this.constraintName = this.getSchema().getUniqueConstraintName(this.session, table2);
        }
        return this.constraintName;
    }

    @Override
    public int update() {
        try {
            int n = this.tryUpdate();
            return n;
        }
        catch (DbException dbException) {
            try {
                for (Index index : this.createdIndexes) {
                    this.session.getDatabase().removeSchemaObject(this.session, index);
                }
            }
            catch (Throwable throwable) {
                dbException.addSuppressed(throwable);
            }
            throw dbException;
        }
        finally {
            this.getSchema().freeUniqueName(this.constraintName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryUpdate() {
        Constraint constraint;
        if (!this.transactional) {
            this.session.commit(true);
        }
        Database database = this.session.getDatabase();
        Table table2 = this.getSchema().findTableOrView(this.session, this.tableName);
        if (table2 == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.tableName);
        }
        if (this.constraintName != null && this.getSchema().findConstraint(this.session, this.constraintName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90045, this.constraintName);
        }
        this.session.getUser().checkRight(table2, 15);
        database.lockMeta(this.session);
        table2.lock(this.session, true, true);
        switch (this.type) {
            case 6: {
                Object object;
                Object object2;
                IndexColumn.mapColumns(this.indexColumns, table2);
                this.index = table2.findPrimaryKey();
                ArrayList<Constraint> arrayList = table2.getConstraints();
                for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
                    object2 = arrayList.get(i);
                    if (Constraint.Type.PRIMARY_KEY != ((Constraint)object2).getConstraintType()) continue;
                    throw DbException.get(90017);
                }
                if (this.index != null) {
                    object = this.index.getIndexColumns();
                    if (((IndexColumn[])object).length != this.indexColumns.length) {
                        throw DbException.get(90017);
                    }
                    for (int i = 0; i < ((IndexColumn[])object).length; ++i) {
                        if (object[i].column == this.indexColumns[i].column) continue;
                        throw DbException.get(90017);
                    }
                } else {
                    object = IndexType.createPrimaryKey(table2.isPersistIndexes(), this.primaryKeyHash);
                    object2 = table2.getSchema().getUniqueIndexName(this.session, table2, "PRIMARY_KEY_");
                    int n = this.session.getDatabase().allocateObjectId();
                    try {
                        this.index = table2.addIndex(this.session, (String)object2, n, this.indexColumns, (IndexType)object, true, null);
                    }
                    finally {
                        this.getSchema().freeUniqueName((String)object2);
                    }
                }
                this.index.getIndexType().setBelongsToConstraint(true);
                int n = this.getObjectId();
                String string2 = this.generateConstraintName(table2);
                ConstraintUnique constraintUnique = new ConstraintUnique(this.getSchema(), n, string2, table2, true);
                constraintUnique.setColumns(this.indexColumns);
                constraintUnique.setIndex(this.index, true);
                constraint = constraintUnique;
                break;
            }
            case 4: {
                IndexColumn.mapColumns(this.indexColumns, table2);
                boolean bl = false;
                if (this.index != null && AlterTableAddConstraint.canUseUniqueIndex(this.index, table2, this.indexColumns)) {
                    bl = true;
                    this.index.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.index = AlterTableAddConstraint.getUniqueIndex(table2, this.indexColumns);
                    if (this.index == null) {
                        this.index = this.createIndex(table2, this.indexColumns, true);
                        bl = true;
                    }
                }
                int n = this.getObjectId();
                String string3 = this.generateConstraintName(table2);
                ConstraintUnique constraintUnique = new ConstraintUnique(this.getSchema(), n, string3, table2, false);
                constraintUnique.setColumns(this.indexColumns);
                constraintUnique.setIndex(this.index, bl);
                constraint = constraintUnique;
                break;
            }
            case 3: {
                int n = this.getObjectId();
                String string4 = this.generateConstraintName(table2);
                ConstraintCheck constraintCheck = new ConstraintCheck(this.getSchema(), n, string4, table2);
                TableFilter tableFilter = new TableFilter(this.session, table2, null, false, null, 0, null);
                this.checkExpression.mapColumns(tableFilter, 0, 0);
                this.checkExpression = this.checkExpression.optimize(this.session);
                constraintCheck.setExpression(this.checkExpression);
                constraintCheck.setTableFilter(tableFilter);
                constraint = constraintCheck;
                if (!this.checkExisting) break;
                constraintCheck.checkExistingData(this.session);
                break;
            }
            case 5: {
                Table table3 = this.refSchema.resolveTableOrView(this.session, this.refTableName);
                if (table3 == null) {
                    throw DbException.get(42102, this.refTableName);
                }
                this.session.getUser().checkRight(table3, 15);
                if (!table3.canReference()) {
                    StringBuilder stringBuilder = new StringBuilder("Reference ");
                    table3.getSQL(stringBuilder, false);
                    throw DbException.getUnsupportedException(stringBuilder.toString());
                }
                boolean bl = false;
                IndexColumn.mapColumns(this.indexColumns, table2);
                if (this.index != null && AlterTableAddConstraint.canUseIndex(this.index, table2, this.indexColumns, false)) {
                    bl = true;
                    this.index.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.index = AlterTableAddConstraint.getIndex(table2, this.indexColumns, false);
                    if (this.index == null) {
                        this.index = this.createIndex(table2, this.indexColumns, false);
                        bl = true;
                    }
                }
                if (this.refIndexColumns == null) {
                    Index index = table3.getPrimaryKey();
                    this.refIndexColumns = index.getIndexColumns();
                } else {
                    IndexColumn.mapColumns(this.refIndexColumns, table3);
                }
                if (this.refIndexColumns.length != this.indexColumns.length) {
                    throw DbException.get(21002);
                }
                boolean bl2 = false;
                if (this.refIndex != null && this.refIndex.getTable() == table3 && AlterTableAddConstraint.canUseIndex(this.refIndex, table3, this.refIndexColumns, false)) {
                    bl2 = true;
                    this.refIndex.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.refIndex = null;
                }
                if (this.refIndex == null) {
                    this.refIndex = AlterTableAddConstraint.getIndex(table3, this.refIndexColumns, false);
                    if (this.refIndex == null) {
                        this.refIndex = this.createIndex(table3, this.refIndexColumns, true);
                        bl2 = true;
                    }
                }
                int n = this.getObjectId();
                String string5 = this.generateConstraintName(table2);
                ConstraintReferential constraintReferential = new ConstraintReferential(this.getSchema(), n, string5, table2);
                constraintReferential.setColumns(this.indexColumns);
                constraintReferential.setIndex(this.index, bl);
                constraintReferential.setRefTable(table3);
                constraintReferential.setRefColumns(this.refIndexColumns);
                constraintReferential.setRefIndex(this.refIndex, bl2);
                if (this.checkExisting) {
                    constraintReferential.checkExistingData(this.session);
                }
                table3.addConstraint(constraintReferential);
                constraintReferential.setDeleteAction(this.deleteAction);
                constraintReferential.setUpdateAction(this.updateAction);
                constraint = constraintReferential;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.type);
            }
        }
        constraint.setComment(this.comment);
        if (table2.isTemporary() && !table2.isGlobalTemporary()) {
            this.session.addLocalTempTableConstraint(constraint);
        } else {
            database.addSchemaObject(this.session, constraint);
        }
        table2.addConstraint(constraint);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index createIndex(Table table2, IndexColumn[] indexColumnArray, boolean bl) {
        int n = this.session.getDatabase().allocateObjectId();
        IndexType indexType = bl ? IndexType.createUnique(table2.isPersistIndexes(), false) : IndexType.createNonUnique(table2.isPersistIndexes());
        indexType.setBelongsToConstraint(true);
        String string2 = this.constraintName == null ? "CONSTRAINT" : this.constraintName;
        String string3 = table2.getSchema().getUniqueIndexName(this.session, table2, string2 + "_INDEX_");
        try {
            Index index = table2.addIndex(this.session, string3, n, indexColumnArray, indexType, true, null);
            this.createdIndexes.add(index);
            Index index2 = index;
            return index2;
        }
        finally {
            this.getSchema().freeUniqueName(string3);
        }
    }

    public void setDeleteAction(ConstraintActionType constraintActionType) {
        this.deleteAction = constraintActionType;
    }

    public void setUpdateAction(ConstraintActionType constraintActionType) {
        this.updateAction = constraintActionType;
    }

    private static Index getUniqueIndex(Table table2, IndexColumn[] indexColumnArray) {
        if (table2.getIndexes() == null) {
            return null;
        }
        for (Index index : table2.getIndexes()) {
            if (!AlterTableAddConstraint.canUseUniqueIndex(index, table2, indexColumnArray)) continue;
            return index;
        }
        return null;
    }

    private static Index getIndex(Table table2, IndexColumn[] indexColumnArray, boolean bl) {
        if (table2.getIndexes() == null) {
            return null;
        }
        for (Index index : table2.getIndexes()) {
            if (!AlterTableAddConstraint.canUseIndex(index, table2, indexColumnArray, bl)) continue;
            return index;
        }
        return null;
    }

    private static boolean canUseUniqueIndex(Index index, Table table2, IndexColumn[] indexColumnArray) {
        if (index.getTable() != table2 || !index.getIndexType().isUnique()) {
            return false;
        }
        Column[] columnArray = index.getColumns();
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, columnArray);
        HashSet<Column> hashSet2 = new HashSet<Column>();
        for (IndexColumn indexColumn : indexColumnArray) {
            hashSet2.add(indexColumn.column);
        }
        return hashSet2.equals(hashSet);
    }

    private static boolean canUseIndex(Index index, Table table2, IndexColumn[] indexColumnArray, boolean bl) {
        if (index.getTable() != table2 || index.getCreateSQL() == null) {
            return false;
        }
        Column[] columnArray = index.getColumns();
        if (bl) {
            if (columnArray.length < indexColumnArray.length) {
                return false;
            }
            for (IndexColumn indexColumn : indexColumnArray) {
                int n = index.getColumnIndex(indexColumn.column);
                if (n >= 0 && n < indexColumnArray.length) continue;
                return false;
            }
        } else {
            if (columnArray.length != indexColumnArray.length) {
                return false;
            }
            for (IndexColumn indexColumn : indexColumnArray) {
                int n = index.getColumnIndex(indexColumn.column);
                if (n >= 0) continue;
                return false;
            }
        }
        return true;
    }

    public void setConstraintName(String string2) {
        this.constraintName = string2;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setType(int n) {
        this.type = n;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setCheckExpression(Expression expression) {
        this.checkExpression = expression;
    }

    public void setTableName(String string2) {
        this.tableName = string2;
    }

    public void setIndexColumns(IndexColumn[] indexColumnArray) {
        this.indexColumns = indexColumnArray;
    }

    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    public void setRefTableName(Schema schema, String string2) {
        this.refSchema = schema;
        this.refTableName = string2;
    }

    public void setRefIndexColumns(IndexColumn[] indexColumnArray) {
        this.refIndexColumns = indexColumnArray;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public void setRefIndex(Index index) {
        this.refIndex = index;
    }

    public void setComment(String string2) {
        this.comment = string2;
    }

    public void setCheckExisting(boolean bl) {
        this.checkExisting = bl;
    }

    public void setPrimaryKeyHash(boolean bl) {
        this.primaryKeyHash = bl;
    }
}

