/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.ddl.CommandWithColumns;
import org.h2.command.ddl.CreateTableData;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableView;
import org.h2.util.Utils;

public class AlterTableAlterColumn
extends CommandWithColumns {
    private String tableName;
    private Column oldColumn;
    private Column newColumn;
    private int type;
    private Expression defaultExpression;
    private Expression newSelectivity;
    private boolean addFirst;
    private String addBefore;
    private String addAfter;
    private boolean ifTableExists;
    private boolean ifNotExists;
    private ArrayList<Column> columnsToAdd;
    private ArrayList<Column> columnsToRemove;
    private boolean newVisibility;

    public AlterTableAlterColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfTableExists(boolean bl) {
        this.ifTableExists = bl;
    }

    public void setTableName(String string2) {
        this.tableName = string2;
    }

    public void setOldColumn(Column column) {
        this.oldColumn = column;
    }

    public void setAddFirst() {
        this.addFirst = true;
    }

    public void setAddBefore(String string2) {
        this.addBefore = string2;
    }

    public void setAddAfter(String string2) {
        this.addAfter = string2;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Table table2 = this.getSchema().resolveTableOrView(this.session, this.tableName);
        if (table2 == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.tableName);
        }
        this.session.getUser().checkRight(table2, 15);
        table2.checkSupportAlter();
        table2.lock(this.session, true, true);
        if (this.newColumn != null) {
            AlterTableAlterColumn.checkDefaultReferencesTable(table2, this.newColumn.getDefaultExpression());
            this.checkClustering(this.newColumn);
        }
        if (this.columnsToAdd != null) {
            for (Column column : this.columnsToAdd) {
                AlterTableAlterColumn.checkDefaultReferencesTable(table2, column.getDefaultExpression());
                this.checkClustering(column);
            }
        }
        switch (this.type) {
            case 8: {
                if (!this.oldColumn.isNullable()) break;
                this.checkNoNullValues(table2);
                this.oldColumn.setNullable(false);
                database.updateMeta(this.session, table2);
                break;
            }
            case 9: {
                if (this.oldColumn.isNullable()) break;
                this.checkNullable(table2);
                this.oldColumn.setNullable(true);
                database.updateMeta(this.session, table2);
                break;
            }
            case 10: {
                Object object = this.oldColumn == null ? null : this.oldColumn.getSequence();
                AlterTableAlterColumn.checkDefaultReferencesTable(table2, this.defaultExpression);
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, this.defaultExpression);
                this.removeSequence(table2, (Sequence)object);
                database.updateMeta(this.session, table2);
                break;
            }
            case 90: {
                AlterTableAlterColumn.checkDefaultReferencesTable(table2, this.defaultExpression);
                this.oldColumn.setOnUpdateExpression(this.session, this.defaultExpression);
                database.updateMeta(this.session, table2);
                break;
            }
            case 11: {
                if (this.oldColumn.isWideningConversion(this.newColumn)) {
                    this.convertAutoIncrementColumn(table2, this.newColumn);
                    this.oldColumn.copy(this.newColumn);
                    database.updateMeta(this.session, table2);
                } else {
                    this.oldColumn.setSequence(null);
                    this.oldColumn.setDefaultExpression(this.session, null);
                    this.oldColumn.setConvertNullToDefault(false);
                    if (this.oldColumn.isNullable() && !this.newColumn.isNullable()) {
                        this.checkNoNullValues(table2);
                    } else if (!this.oldColumn.isNullable() && this.newColumn.isNullable()) {
                        this.checkNullable(table2);
                    }
                    if (this.oldColumn.getVisible() ^ this.newColumn.getVisible()) {
                        this.oldColumn.setVisible(this.newColumn.getVisible());
                    }
                    this.convertAutoIncrementColumn(table2, this.newColumn);
                    this.copyData(table2);
                }
                table2.setModified();
                break;
            }
            case 7: {
                if (this.ifNotExists && this.columnsToAdd != null && this.columnsToAdd.size() == 1 && table2.doesColumnExist(this.columnsToAdd.get(0).getName())) break;
                Object object = this.generateSequences(this.columnsToAdd, false);
                if (this.columnsToAdd != null) {
                    this.changePrimaryKeysToNotNull(this.columnsToAdd);
                }
                this.copyData(table2, (ArrayList<Sequence>)object, true);
                break;
            }
            case 12: {
                if (table2.getColumns().length - this.columnsToRemove.size() < 1) {
                    throw DbException.get(90084, this.columnsToRemove.get(0).getSQL(false));
                }
                table2.dropMultipleColumnsConstraintsAndIndexes(this.session, this.columnsToRemove);
                this.copyData(table2);
                break;
            }
            case 13: {
                int n = this.newSelectivity.optimize(this.session).getValue(this.session).getInt();
                this.oldColumn.setSelectivity(n);
                database.updateMeta(this.session, table2);
                break;
            }
            case 87: {
                this.oldColumn.setVisible(this.newVisibility);
                table2.setModified();
                database.updateMeta(this.session, table2);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    private static void checkDefaultReferencesTable(Table table2, Expression expression) {
        if (expression == null) {
            return;
        }
        HashSet<DbObject> hashSet = new HashSet<DbObject>();
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getDependenciesVisitor(hashSet);
        expression.isEverything(expressionVisitor);
        if (hashSet.contains(table2)) {
            throw DbException.get(90083, expression.getSQL(false));
        }
    }

    private void checkClustering(Column column) {
        if (!"''".equals(this.session.getDatabase().getCluster()) && column.isAutoIncrement()) {
            throw DbException.getUnsupportedException("CLUSTERING && auto-increment columns");
        }
    }

    private void convertAutoIncrementColumn(Table table2, Column column) {
        if (column.isAutoIncrement()) {
            if (column.isPrimaryKey()) {
                column.setOriginalSQL("IDENTITY");
            } else {
                int n = this.getObjectId();
                column.convertAutoIncrementToSequence(this.session, this.getSchema(), n, table2.isTemporary());
            }
        }
    }

    private void removeSequence(Table table2, Sequence sequence) {
        if (sequence != null) {
            table2.removeSequence(sequence);
            sequence.setBelongsToTable(false);
            Database database = this.session.getDatabase();
            database.removeSchemaObject(this.session, sequence);
        }
    }

    private void copyData(Table table2) {
        this.copyData(table2, null, false);
    }

    private void copyData(Table table2, ArrayList<Sequence> arrayList, boolean bl) {
        String string2;
        if (table2.isTemporary()) {
            throw DbException.getUnsupportedException("TEMP TABLE");
        }
        Database database = this.session.getDatabase();
        String string3 = table2.getName();
        String string4 = database.getTempTableName(string3, this.session);
        Column[] columnArray = table2.getColumns();
        ArrayList<Column> arrayList3 = new ArrayList<Column>(columnArray.length);
        Table table3 = this.cloneTableStructure(table2, columnArray, database, string4, arrayList3);
        if (arrayList != null) {
            for (Sequence arrayList22 : arrayList) {
                table2.addSequence(arrayList22);
            }
        }
        try {
            this.checkViews(table2, table3);
        }
        catch (DbException dbException) {
            StringBuilder stringBuilder = new StringBuilder("DROP TABLE ");
            table3.getSQL(stringBuilder, true);
            this.execute(stringBuilder.toString(), true);
            throw dbException;
        }
        String string5 = table2.getName();
        ArrayList<TableView> arrayList2 = new ArrayList<TableView>(table2.getDependentViews());
        for (TableView tableView : arrayList2) {
            table2.removeDependentView(tableView);
        }
        StringBuilder stringBuilder = new StringBuilder("DROP TABLE ");
        table2.getSQL(stringBuilder, true).append(" IGNORE");
        this.execute(stringBuilder.toString(), true);
        database.renameSchemaObject(this.session, table3, string5);
        for (DbObject dbObject : table3.getChildren()) {
            if (dbObject instanceof Sequence || (string2 = dbObject.getName()) == null || dbObject.getCreateSQL() == null || !string2.startsWith(string4 + "_")) continue;
            string2 = string2.substring(string4.length() + 1);
            SchemaObject schemaObject = (SchemaObject)dbObject;
            if (schemaObject instanceof Constraint) {
                if (schemaObject.getSchema().findConstraint(this.session, string2) != null) {
                    string2 = schemaObject.getSchema().getUniqueConstraintName(this.session, table3);
                }
            } else if (schemaObject instanceof Index && schemaObject.getSchema().findIndex(this.session, string2) != null) {
                string2 = schemaObject.getSchema().getUniqueIndexName(this.session, table3, string2);
            }
            database.renameSchemaObject(this.session, schemaObject, string2);
        }
        if (bl) {
            this.createConstraints();
        }
        for (TableView tableView : arrayList2) {
            string2 = tableView.getCreateSQL(true, true);
            this.execute(string2, true);
        }
    }

    private Table cloneTableStructure(Table table2, Column[] columnArray, Database database, String string2, ArrayList<Column> arrayList) {
        Object object;
        Object object2;
        for (Column object72 : columnArray) {
            arrayList.add(object72.getClone());
        }
        if (this.type == 12) {
            for (Column column : this.columnsToRemove) {
                Column column2 = null;
                for (Column column3 : arrayList) {
                    if (!column3.getName().equals(column.getName())) continue;
                    column2 = column3;
                    break;
                }
                if (column2 == null) {
                    throw DbException.throwInternalError(column.getCreateSQL());
                }
                arrayList.remove(column2);
            }
        } else if (this.type == 7) {
            int n = this.addFirst ? 0 : (this.addBefore != null ? table2.getColumn(this.addBefore).getColumnId() : (this.addAfter != null ? table2.getColumn(this.addAfter).getColumnId() + 1 : columnArray.length));
            if (this.columnsToAdd != null) {
                for (Column column : this.columnsToAdd) {
                    arrayList.add(n++, column);
                }
            }
        } else if (this.type == 11) {
            int n = this.oldColumn.getColumnId();
            arrayList.set(n, this.newColumn);
        }
        int n = database.allocateObjectId();
        CreateTableData createTableData = new CreateTableData();
        createTableData.tableName = string2;
        createTableData.id = n;
        createTableData.columns = arrayList;
        createTableData.temporary = table2.isTemporary();
        createTableData.persistData = table2.isPersistData();
        createTableData.persistIndexes = table2.isPersistIndexes();
        createTableData.isHidden = table2.isHidden();
        createTableData.create = true;
        createTableData.session = this.session;
        Table table3 = this.getSchema().createTable(createTableData);
        table3.setComment(table2.getComment());
        String string3 = table3.getCreateSQL();
        StringBuilder stringBuilder = new StringBuilder();
        for (Column column : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            if (this.type == 7 && this.columnsToAdd != null && this.columnsToAdd.contains(column)) {
                object2 = column.getDefaultExpression();
                if (object2 == null) {
                    stringBuilder.append("NULL");
                    continue;
                }
                ((Expression)object2).getSQL(stringBuilder, true);
                continue;
            }
            column.getSQL(stringBuilder, true);
        }
        String string4 = table3.getName();
        Schema schema = table3.getSchema();
        table3.removeChildrenAndResources(this.session);
        this.execute(string3, true);
        table3 = schema.getTableOrView(this.session, string4);
        object2 = Utils.newSmallArrayList();
        ArrayList<Object> arrayList2 = Utils.newSmallArrayList();
        boolean bl = false;
        for (DbObject dbObject : table2.getChildren()) {
            SchemaObject schemaObject;
            String string5;
            Index index;
            if (dbObject instanceof Sequence || dbObject instanceof Index && (index = (Index)dbObject).getIndexType().getBelongsToConstraint() || (string5 = dbObject.getCreateSQL()) == null || dbObject instanceof TableView) continue;
            if (dbObject.getType() == 0) {
                DbException.throwInternalError();
            }
            object = Parser.quoteIdentifier(string2 + "_" + dbObject.getName(), true);
            String string6 = null;
            if (dbObject instanceof ConstraintReferential && ((Constraint)(schemaObject = (ConstraintReferential)dbObject)).getTable() != table2) {
                string6 = ((ConstraintReferential)schemaObject).getCreateSQLForCopy(((Constraint)schemaObject).getTable(), table3, (String)object, false);
            }
            if (string6 == null) {
                string6 = dbObject.getCreateSQLForCopy(table3, (String)object);
            }
            if (string6 == null) continue;
            if (dbObject instanceof TriggerObject) {
                arrayList2.add(string6);
                continue;
            }
            if (!bl) {
                schemaObject = null;
                if (dbObject instanceof ConstraintUnique) {
                    ConstraintUnique constraintUnique = (ConstraintUnique)dbObject;
                    if (constraintUnique.getConstraintType() == Constraint.Type.PRIMARY_KEY) {
                        schemaObject = constraintUnique.getUniqueIndex();
                    }
                } else if (dbObject instanceof Index) {
                    schemaObject = (Index)dbObject;
                }
                if (schemaObject != null && TableBase.getMainIndexColumn(schemaObject.getIndexType(), schemaObject.getIndexColumns()) != -1) {
                    this.execute(string6, true);
                    bl = true;
                    continue;
                }
            }
            ((ArrayList)object2).add(string6);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("INSERT INTO ");
        table3.getSQL(stringBuilder2, true);
        stringBuilder2.append(" SELECT ");
        if (stringBuilder.length() == 0) {
            stringBuilder2.append('*');
        } else {
            stringBuilder2.append((CharSequence)stringBuilder);
        }
        stringBuilder2.append(" FROM ");
        table2.getSQL(stringBuilder2, true);
        try {
            this.execute(stringBuilder2.toString(), true);
        }
        catch (Throwable throwable) {
            StringBuilder stringBuilder3 = new StringBuilder("DROP TABLE ");
            table3.getSQL(stringBuilder3, true);
            this.execute(stringBuilder3.toString(), true);
            throw throwable;
        }
        Iterator iterator = ((ArrayList)object2).iterator();
        while (iterator.hasNext()) {
            String string7 = (String)iterator.next();
            this.execute(string7, true);
        }
        table2.setModified();
        for (Column column : arrayList) {
            object = column.getSequence();
            if (object == null) continue;
            table2.removeSequence((Sequence)object);
            column.setSequence(null);
        }
        for (String string8 : arrayList2) {
            this.execute(string8, true);
        }
        return table3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkViews(SchemaObject schemaObject, SchemaObject schemaObject2) {
        String string2 = schemaObject.getName();
        String string3 = schemaObject2.getName();
        Database database = schemaObject.getDatabase();
        String string4 = database.getTempTableName(string2, this.session);
        database.renameSchemaObject(this.session, schemaObject, string4);
        try {
            database.renameSchemaObject(this.session, schemaObject2, string2);
            this.checkViewsAreValid(schemaObject);
        }
        finally {
            try {
                database.renameSchemaObject(this.session, schemaObject2, string3);
            }
            finally {
                database.renameSchemaObject(this.session, schemaObject, string2);
            }
        }
    }

    private void checkViewsAreValid(DbObject dbObject) {
        for (DbObject dbObject2 : dbObject.getChildren()) {
            if (!(dbObject2 instanceof TableView)) continue;
            String string2 = ((TableView)dbObject2).getQuery();
            try {
                this.session.prepare(string2);
            }
            catch (DbException dbException) {
                throw DbException.get(90083, dbException, dbObject2.getSQL(false));
            }
            this.checkViewsAreValid(dbObject2);
        }
    }

    private void execute(String string2, boolean bl) {
        Prepared prepared = this.session.prepare(string2);
        prepared.update();
        if (bl) {
            this.session.commit(true);
        }
    }

    private void checkNullable(Table table2) {
        for (Index index : table2.getIndexes()) {
            IndexType indexType;
            if (index.getColumnIndex(this.oldColumn) < 0 || !(indexType = index.getIndexType()).isPrimaryKey() && !indexType.isHash()) continue;
            throw DbException.get(90075, index.getSQL(false));
        }
    }

    private void checkNoNullValues(Table table2) {
        StringBuilder stringBuilder = new StringBuilder("SELECT COUNT(*) FROM ");
        table2.getSQL(stringBuilder, true).append(" WHERE ");
        this.oldColumn.getSQL(stringBuilder, true).append(" IS NULL");
        String string2 = stringBuilder.toString();
        Prepared prepared = this.session.prepare(string2);
        ResultInterface resultInterface = prepared.query(0);
        resultInterface.next();
        if (resultInterface.currentRow()[0].getInt() > 0) {
            throw DbException.get(90081, this.oldColumn.getSQL(false));
        }
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setSelectivity(Expression expression) {
        this.newSelectivity = expression;
    }

    public void setDefaultExpression(Expression expression) {
        this.defaultExpression = expression;
    }

    public void setNewColumn(Column column) {
        this.newColumn = column;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    @Override
    public void addColumn(Column column) {
        if (this.columnsToAdd == null) {
            this.columnsToAdd = new ArrayList();
        }
        this.columnsToAdd.add(column);
    }

    public void setColumnsToRemove(ArrayList<Column> arrayList) {
        this.columnsToRemove = arrayList;
    }

    public void setVisible(boolean bl) {
        this.newVisibility = bl;
    }
}

