/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Domain;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.value.DataType;

public class CreateDomain
extends DefineCommand {
    private String typeName;
    private Column column;
    private boolean ifNotExists;

    public CreateDomain(Session session) {
        super(session);
    }

    public void setTypeName(String string2) {
        this.typeName = string2;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        if (database.findDomain(this.typeName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90119, this.typeName);
        }
        DataType dataType = DataType.getTypeByName(this.typeName, this.session.getDatabase().getMode());
        if (dataType != null) {
            if (!dataType.hidden) {
                throw DbException.get(90119, this.typeName);
            }
            Table table2 = this.session.getDatabase().getFirstUserTable();
            if (table2 != null) {
                StringBuilder stringBuilder = new StringBuilder(this.typeName).append(" (");
                table2.getSQL(stringBuilder, false).append(')');
                throw DbException.get(90119, stringBuilder.toString());
            }
        }
        int n = this.getObjectId();
        Domain domain = new Domain(database, n, this.typeName);
        domain.setColumn(this.column);
        database.addDatabaseObject(this.session, domain);
        return 0;
    }

    @Override
    public int getType() {
        return 33;
    }
}

