/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.command.ddl.SequenceOptions;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;

public class CreateSequence
extends SchemaCommand {
    private String sequenceName;
    private boolean ifNotExists;
    private SequenceOptions options;
    private boolean belongsToTable;

    public CreateSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setSequenceName(String string2) {
        this.sequenceName = string2;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setOptions(SequenceOptions sequenceOptions) {
        this.options = sequenceOptions;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (this.getSchema().findSequence(this.sequenceName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90035, this.sequenceName);
        }
        int n = this.getObjectId();
        Sequence sequence = new Sequence(this.getSchema(), n, this.sequenceName, this.options.getStartValue(this.session), this.options.getIncrement(this.session), this.options.getCacheSize(this.session), this.options.getMinValue(null, this.session), this.options.getMaxValue(null, this.session), Boolean.TRUE.equals(this.options.getCycle()), this.belongsToTable);
        database.addSchemaObject(this.session, sequence);
        return 0;
    }

    public void setBelongsToTable(boolean bl) {
        this.belongsToTable = bl;
    }

    @Override
    public int getType() {
        return 29;
    }
}

