/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.h2.command.Prepared;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.FunctionCall;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.SortOrder;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

public abstract class Query
extends Prepared {
    ArrayList<Expression> expressions;
    Expression[] expressionArray;
    ArrayList<SelectOrderBy> orderList;
    SortOrder sort;
    Expression limitExpr;
    boolean fetchPercent;
    boolean withTies;
    Expression offsetExpr;
    Expression sampleSizeExpr;
    boolean distinct;
    boolean randomAccessResult;
    private boolean noCache;
    private int lastLimit;
    private long lastEvaluated;
    private ResultInterface lastResult;
    private Value[] lastParameters;
    private boolean cacheableChecked;
    private boolean neverLazy;

    Query(Session session) {
        super(session);
    }

    public void setNeverLazy(boolean bl) {
        this.neverLazy = bl;
    }

    public boolean isNeverLazy() {
        return this.neverLazy;
    }

    public abstract boolean isUnion();

    public abstract void prepareJoinBatch();

    protected abstract ResultInterface queryWithoutCache(int var1, ResultTarget var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultInterface queryWithoutCacheLazyCheck(int n, ResultTarget resultTarget) {
        boolean bl;
        boolean bl2 = bl = this.neverLazy && this.session.isLazyQueryExecution();
        if (bl) {
            this.session.setLazyQueryExecution(false);
        }
        try {
            ResultInterface resultInterface = this.queryWithoutCache(n, resultTarget);
            return resultInterface;
        }
        finally {
            if (bl) {
                this.session.setLazyQueryExecution(true);
            }
        }
    }

    public abstract void init();

    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    public abstract double getCost();

    public int getCostAsExpression() {
        return (int)Math.min(1000000.0, 10.0 + 10.0 * this.getCost());
    }

    public abstract HashSet<Table> getTables();

    public void setOrder(ArrayList<SelectOrderBy> arrayList) {
        this.orderList = arrayList;
    }

    public boolean hasOrder() {
        return this.orderList != null || this.sort != null;
    }

    public abstract void setForUpdate(boolean var1);

    public abstract int getColumnCount();

    public abstract void mapColumns(ColumnResolver var1, int var2);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Parameter var1, int var2, int var3);

    public abstract boolean allowGlobalConditions();

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract void updateAggregate(Session var1, int var2);

    public abstract void fireBeforeSelectTriggers();

    public void setDistinct() {
        this.distinct = true;
    }

    public abstract void setDistinctIfPossible();

    public boolean isStandardDistinct() {
        return this.distinct;
    }

    public boolean isAnyDistinct() {
        return this.distinct;
    }

    public boolean isRandomAccessResult() {
        return this.randomAccessResult;
    }

    public void setRandomAccessResult(boolean bl) {
        this.randomAccessResult = bl;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void disableCache() {
        this.noCache = true;
    }

    private boolean sameResultAsLast(Session session, Value[] valueArray, Value[] valueArray2, long l) {
        if (!this.cacheableChecked) {
            long l2 = this.getMaxDataModificationId();
            boolean bl = this.noCache = l2 == Long.MAX_VALUE;
            if (!this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) || !this.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
                this.noCache = true;
            }
            this.cacheableChecked = true;
        }
        if (this.noCache) {
            return false;
        }
        Database database = session.getDatabase();
        for (int i = 0; i < valueArray.length; ++i) {
            Value value2 = valueArray2[i];
            Value value3 = valueArray[i];
            if (value2.getValueType() == value3.getValueType() && database.areEqual(value2, value3)) continue;
            return false;
        }
        return this.getMaxDataModificationId() <= l;
    }

    private Value[] getParameterValues() {
        ArrayList<Parameter> arrayList = this.getParameters();
        if (arrayList == null) {
            return new Value[0];
        }
        int n = arrayList.size();
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            Value value2;
            valueArray[i] = value2 = arrayList.get(i).getParamValue();
        }
        return valueArray;
    }

    @Override
    public final ResultInterface query(int n) {
        return this.query(n, null);
    }

    public final ResultInterface query(int n, ResultTarget resultTarget) {
        ResultInterface resultInterface;
        if (this.isUnion()) {
            return this.queryWithoutCacheLazyCheck(n, resultTarget);
        }
        this.fireBeforeSelectTriggers();
        if (this.noCache || !this.session.getDatabase().getOptimizeReuseResults() || this.session.isLazyQueryExecution() && !this.neverLazy) {
            return this.queryWithoutCacheLazyCheck(n, resultTarget);
        }
        Value[] valueArray = this.getParameterValues();
        long l = this.session.getDatabase().getModificationDataId();
        if (this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) && this.lastResult != null && !this.lastResult.isClosed() && n == this.lastLimit && this.sameResultAsLast(this.session, valueArray, this.lastParameters, this.lastEvaluated)) {
            this.lastResult = this.lastResult.createShallowCopy(this.session);
            if (this.lastResult != null) {
                this.lastResult.reset();
                return this.lastResult;
            }
        }
        this.lastParameters = valueArray;
        this.closeLastResult();
        this.lastResult = resultInterface = this.queryWithoutCacheLazyCheck(n, resultTarget);
        this.lastEvaluated = l;
        this.lastLimit = n;
        return resultInterface;
    }

    private void closeLastResult() {
        if (this.lastResult != null) {
            this.lastResult.close();
        }
    }

    static void initOrder(Session session, ArrayList<Expression> arrayList, ArrayList<String> arrayList2, List<SelectOrderBy> list, int n, boolean bl, ArrayList<TableFilter> arrayList3) {
        for (SelectOrderBy selectOrderBy : list) {
            Expression expression = selectOrderBy.expression;
            if (expression == null) continue;
            int n2 = Query.initExpression(session, arrayList, arrayList2, expression, n, bl, arrayList3);
            selectOrderBy.columnIndexExpr = ValueExpression.get(ValueInt.get(n2 + 1));
            selectOrderBy.expression = arrayList.get(n2).getNonAliasExpression();
        }
    }

    static int initExpression(Session session, ArrayList<Expression> arrayList, ArrayList<String> arrayList2, Expression expression, int n, boolean bl, ArrayList<TableFilter> arrayList3) {
        Object object;
        Database database = session.getDatabase();
        if (expression instanceof ExpressionColumn) {
            object = (ExpressionColumn)expression;
            String string2 = ((ExpressionColumn)object).getOriginalTableAliasName();
            String string3 = ((ExpressionColumn)object).getOriginalColumnName();
            for (int i = 0; i < n; ++i) {
                Object object3;
                Expression expression2;
                Expression expression3 = arrayList.get(i);
                if (expression3 instanceof ExpressionColumn) {
                    expression2 = (ExpressionColumn)expression3;
                    if (!database.equalsIdentifiers(string3, ((ExpressionColumn)expression2).getColumnName())) continue;
                    if (string2 == null) {
                        return i;
                    }
                    object3 = ((ExpressionColumn)expression2).getOriginalTableAliasName();
                    if (object3 != null) {
                        if (!database.equalsIdentifiers((String)object3, string2)) continue;
                        return i;
                    }
                    if (arrayList3 == null) continue;
                    for (TableFilter tableFilter : arrayList3) {
                        if (!database.equalsIdentifiers(tableFilter.getTableAlias(), string2)) continue;
                        return i;
                    }
                    continue;
                }
                if (!(expression3 instanceof Alias)) continue;
                if (string2 == null && database.equalsIdentifiers(string3, expression3.getAlias())) {
                    return i;
                }
                expression2 = expression3.getNonAliasExpression();
                if (!(expression2 instanceof ExpressionColumn)) continue;
                object3 = (ExpressionColumn)expression2;
                String string4 = ((Expression)object).getSQL(true);
                String string5 = ((Expression)object3).getSQL(true);
                String string6 = ((ExpressionColumn)object3).getColumnName();
                if (!database.equalsIdentifiers(string3, string6) || !database.equalsIdentifiers(string4, string5)) continue;
                return i;
            }
        } else if (arrayList2 != null) {
            object = expression.getSQL(true);
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                if (!database.equalsIdentifiers(arrayList2.get(i), (String)object)) continue;
                return i;
            }
        }
        if (arrayList2 == null || bl && session.getDatabase().getMode().getEnum() != Mode.ModeEnum.MySQL && !Query.checkOrderOther(session, expression, arrayList2)) {
            throw DbException.get(90068, expression.getSQL(false));
        }
        int n3 = arrayList.size();
        arrayList.add(expression);
        arrayList2.add(expression.getSQL(true));
        return n3;
    }

    private static boolean checkOrderOther(Session session, Expression expression, ArrayList<String> arrayList) {
        if (expression.isConstant()) {
            return true;
        }
        String string2 = expression.getSQL(true);
        for (String string3 : arrayList) {
            if (!session.getDatabase().equalsIdentifiers(string2, string3)) continue;
            return true;
        }
        int n = expression.getSubexpressionCount();
        if (expression instanceof FunctionCall ? !((FunctionCall)((Object)expression)).isDeterministic() : n <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Query.checkOrderOther(session, expression.getSubexpression(i), arrayList)) continue;
            return false;
        }
        return true;
    }

    public SortOrder prepareOrder(ArrayList<SelectOrderBy> arrayList, int n) {
        int n2 = arrayList.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            SelectOrderBy selectOrderBy = arrayList.get(i);
            boolean bl = false;
            Value value2 = selectOrderBy.columnIndexExpr.getValue(null);
            if (value2 == ValueNull.INSTANCE) {
                n3 = 0;
            } else {
                n3 = value2.getInt();
                if (n3 < 0) {
                    bl = true;
                    n3 = -n3;
                }
                if (--n3 < 0 || n3 >= n) {
                    throw DbException.get(90068, Integer.toString(n3 + 1));
                }
            }
            nArray[i] = n3;
            int n4 = selectOrderBy.sortType;
            if (bl) {
                n4 ^= 1;
            }
            nArray2[i] = n4;
        }
        return new SortOrder(this.session.getDatabase(), nArray, nArray2, arrayList);
    }

    @Override
    public int getType() {
        return 66;
    }

    public void setOffset(Expression expression) {
        this.offsetExpr = expression;
    }

    public Expression getOffset() {
        return this.offsetExpr;
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    public Expression getLimit() {
        return this.limitExpr;
    }

    public void setFetchPercent(boolean bl) {
        this.fetchPercent = bl;
    }

    public boolean isFetchPercent() {
        return this.fetchPercent;
    }

    public void setWithTies(boolean bl) {
        this.withTies = bl;
    }

    public boolean isWithTies() {
        return this.withTies;
    }

    void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = Utils.newSmallArrayList();
        }
        this.parameters.add(parameter);
    }

    public void setSampleSize(Expression expression) {
        this.sampleSizeExpr = expression;
    }

    int getSampleSizeValue(Session session) {
        if (this.sampleSizeExpr == null) {
            return 0;
        }
        Value value2 = this.sampleSizeExpr.optimize(session).getValue(session);
        if (value2 == ValueNull.INSTANCE) {
            return 0;
        }
        return value2.getInt();
    }

    public final long getMaxDataModificationId() {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getMaxModificationIdVisitor();
        this.isEverything(expressionVisitor);
        return expressionVisitor.getMaxDataModificationId();
    }

    void appendLimitToSQL(StringBuilder stringBuilder, boolean bl) {
        String string2;
        if (this.offsetExpr != null) {
            string2 = StringUtils.unEnclose(this.offsetExpr.getSQL(bl));
            stringBuilder.append("\nOFFSET ").append(string2).append("1".equals(string2) ? " ROW" : " ROWS");
        }
        if (this.limitExpr != null) {
            boolean bl2;
            stringBuilder.append("\nFETCH ").append(this.offsetExpr != null ? "NEXT" : "FIRST");
            string2 = StringUtils.unEnclose(this.limitExpr.getSQL(bl));
            boolean bl3 = bl2 = this.fetchPercent || !"1".equals(string2);
            if (bl2) {
                stringBuilder.append(' ').append(string2);
                if (this.fetchPercent) {
                    stringBuilder.append(" PERCENT");
                }
            }
            stringBuilder.append(!bl2 ? " ROW" : " ROWS").append(this.withTies ? " WITH TIES" : " ONLY");
        }
    }
}

