/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LazyResult;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ColumnNamer;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

public class SelectUnion
extends Query {
    private final UnionType unionType;
    final Query left;
    final Query right;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean isForUpdate;

    public SelectUnion(Session session, UnionType unionType, Query query, Query query2) {
        super(session);
        this.unionType = unionType;
        this.left = query;
        this.right = query2;
    }

    @Override
    public boolean isUnion() {
        return true;
    }

    @Override
    public void prepareJoinBatch() {
        this.left.prepareJoinBatch();
        this.right.prepareJoinBatch();
    }

    public UnionType getUnionType() {
        return this.unionType;
    }

    public Query getLeft() {
        return this.left;
    }

    public Query getRight() {
        return this.right;
    }

    @Override
    public void setDistinctIfPossible() {
        this.setDistinct();
    }

    private Value[] convert(Value[] valueArray, int n) {
        Value[] valueArray2 = n == valueArray.length ? valueArray : new Value[n];
        Mode mode = this.session.getDatabase().getMode();
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)this.expressions.get(i);
            valueArray2[i] = valueArray[i].convertTo(expression.getType(), mode, null);
        }
        return valueArray2;
    }

    @Override
    public ResultInterface queryMeta() {
        int n = this.left.getColumnCount();
        LocalResult localResult = this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, n);
        localResult.done();
        return localResult;
    }

    public LocalResult getEmptyResult() {
        int n = this.left.getColumnCount();
        return this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, n);
    }

    @Override
    protected ResultInterface queryWithoutCache(int n, ResultTarget resultTarget) {
        Object object;
        Object object2;
        if (n != 0) {
            Value value2;
            int n2 = this.limitExpr == null ? -1 : ((value2 = this.limitExpr.getValue(this.session)) == ValueNull.INSTANCE ? -1 : value2.getInt());
            n2 = n2 < 0 ? n : Math.min(n2, n);
            this.limitExpr = ValueExpression.get(ValueInt.get(n2));
        }
        Database database = this.session.getDatabase();
        if (database.getSettings().optimizeInsertFromSelect && this.unionType == UnionType.UNION_ALL && resultTarget != null && this.sort == null && !this.distinct && n == 0 && this.offsetExpr == null && this.limitExpr == null) {
            this.left.query(0, resultTarget);
            this.right.query(0, resultTarget);
            return null;
        }
        int n3 = this.left.getColumnCount();
        if (!(!this.session.isLazyQueryExecution() || this.unionType != UnionType.UNION_ALL || this.distinct || this.sort != null || this.randomAccessResult || this.isForUpdate || this.offsetExpr != null || this.fetchPercent || this.withTies || !this.isReadOnly())) {
            int n4 = -1;
            if (this.limitExpr != null && (object2 = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
                n4 = ((Value)object2).getInt();
            }
            if (n4 != 0) {
                object2 = new LazyResultUnion(this.expressionArray, n3);
                if (n4 > 0) {
                    ((LazyResult)object2).setLimit(n4);
                }
                return object2;
            }
        }
        LocalResult localResult = database.getResultFactory().create(this.session, this.expressionArray, n3);
        if (this.sort != null) {
            localResult.setSortOrder(this.sort);
        }
        if (this.distinct) {
            this.left.setDistinctIfPossible();
            this.right.setDistinctIfPossible();
            localResult.setDistinct();
        }
        switch (this.unionType) {
            case UNION: 
            case EXCEPT: {
                this.left.setDistinctIfPossible();
                this.right.setDistinctIfPossible();
                localResult.setDistinct();
                break;
            }
            case UNION_ALL: {
                break;
            }
            case INTERSECT: {
                this.left.setDistinctIfPossible();
                this.right.setDistinctIfPossible();
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        object2 = this.left.query(0);
        ResultInterface resultInterface = this.right.query(0);
        object2.reset();
        resultInterface.reset();
        switch (this.unionType) {
            case UNION: 
            case UNION_ALL: {
                while (object2.next()) {
                    localResult.addRow(this.convert(object2.currentRow(), n3));
                }
                while (resultInterface.next()) {
                    localResult.addRow(this.convert(resultInterface.currentRow(), n3));
                }
                break;
            }
            case EXCEPT: {
                while (object2.next()) {
                    localResult.addRow(this.convert(object2.currentRow(), n3));
                }
                while (resultInterface.next()) {
                    localResult.removeDistinct(this.convert(resultInterface.currentRow(), n3));
                }
                break;
            }
            case INTERSECT: {
                object = database.getResultFactory().create(this.session, this.expressionArray, n3);
                object.setDistinct();
                while (object2.next()) {
                    object.addRow(this.convert(object2.currentRow(), n3));
                }
                while (resultInterface.next()) {
                    Value[] valueArray = this.convert(resultInterface.currentRow(), n3);
                    if (!object.containsDistinct(valueArray)) continue;
                    localResult.addRow(valueArray);
                }
                object.close();
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        if (this.offsetExpr != null) {
            localResult.setOffset(this.offsetExpr.getValue(this.session).getInt());
        }
        if (this.limitExpr != null && (object = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
            localResult.setLimit(((Value)object).getInt());
            localResult.setFetchPercent(this.fetchPercent);
            if (this.withTies) {
                localResult.setWithTies(this.sort);
            }
        }
        object2.close();
        resultInterface.close();
        localResult.done();
        if (resultTarget != null) {
            while (localResult.next()) {
                resultTarget.addRow(localResult.currentRow());
            }
            localResult.close();
            return null;
        }
        return localResult;
    }

    @Override
    public void init() {
        if (this.checkInit) {
            DbException.throwInternalError();
        }
        this.checkInit = true;
        this.left.init();
        this.right.init();
        int n = this.left.getColumnCount();
        if (n != this.right.getColumnCount()) {
            throw DbException.get(21002);
        }
        ArrayList<Expression> arrayList = this.left.getExpressions();
        this.expressions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            this.expressions.add(expression);
        }
        if (this.withTies && !this.hasOrder()) {
            throw DbException.get(90122);
        }
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            return;
        }
        if (!this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        this.isPrepared = true;
        this.left.prepare();
        this.right.prepare();
        int n = this.left.getColumnCount();
        this.expressions = new ArrayList(n);
        ArrayList<Expression> arrayList = this.left.getExpressions();
        ArrayList<Expression> arrayList2 = this.right.getExpressions();
        ColumnNamer columnNamer = new ColumnNamer(this.session);
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            Expression expression2 = arrayList2.get(i);
            String string2 = columnNamer.getColumnName(expression, i, expression.getAlias());
            Column column = new Column(string2, Value.getHigherType(expression.getType(), expression2.getType()));
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), column);
            this.expressions.add(expressionColumn);
        }
        if (this.orderList != null) {
            SelectUnion.initOrder(this.session, this.expressions, null, this.orderList, this.getColumnCount(), true, null);
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        this.expressionArray = this.expressions.toArray(new Expression[0]);
    }

    @Override
    public double getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> hashSet = this.left.getTables();
        hashSet.addAll(this.right.getTables());
        return hashSet;
    }

    @Override
    public void setForUpdate(boolean bl) {
        this.left.setForUpdate(bl);
        this.right.setForUpdate(bl);
        this.isForUpdate = bl;
    }

    @Override
    public int getColumnCount() {
        return this.left.getColumnCount();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.right.mapColumns(columnResolver, n);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public void addGlobalCondition(Parameter parameter, int n, int n2) {
        this.addParameter(parameter);
        switch (this.unionType) {
            case UNION: 
            case UNION_ALL: 
            case INTERSECT: {
                this.left.addGlobalCondition(parameter, n, n2);
                this.right.addGlobalCondition(parameter, n, n2);
                break;
            }
            case EXCEPT: {
                this.left.addGlobalCondition(parameter, n, n2);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
    }

    @Override
    public String getPlanSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.left.getPlanSQL(bl)).append(')');
        switch (this.unionType) {
            case UNION_ALL: {
                stringBuilder.append("\nUNION ALL\n");
                break;
            }
            case UNION: {
                stringBuilder.append("\nUNION\n");
                break;
            }
            case INTERSECT: {
                stringBuilder.append("\nINTERSECT\n");
                break;
            }
            case EXCEPT: {
                stringBuilder.append("\nEXCEPT\n");
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        stringBuilder.append('(').append(this.right.getPlanSQL(bl)).append(')');
        Expression[] expressionArray = this.expressions.toArray(new Expression[0]);
        if (this.sort != null) {
            stringBuilder.append("\nORDER BY ").append(this.sort.getSQL(expressionArray, expressionArray.length, bl));
        }
        this.appendLimitToSQL(stringBuilder, bl);
        if (this.sampleSizeExpr != null) {
            stringBuilder.append("\nSAMPLE_SIZE ");
            this.sampleSizeExpr.getUnenclosedSQL(stringBuilder, bl);
        }
        if (this.isForUpdate) {
            stringBuilder.append("\nFOR UPDATE");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public boolean isReadOnly() {
        return this.left.isReadOnly() && this.right.isReadOnly();
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        this.right.updateAggregate(session, n);
    }

    @Override
    public void fireBeforeSelectTriggers() {
        this.left.fireBeforeSelectTriggers();
        this.right.fireBeforeSelectTriggers();
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.left.allowGlobalConditions() && this.right.allowGlobalConditions();
    }

    private final class LazyResultUnion
    extends LazyResult {
        int columnCount;
        ResultInterface l;
        ResultInterface r;
        boolean leftDone;
        boolean rightDone;

        LazyResultUnion(Expression[] expressionArray, int n) {
            super(expressionArray);
            this.columnCount = n;
        }

        @Override
        public int getVisibleColumnCount() {
            return this.columnCount;
        }

        @Override
        protected Value[] fetchNextRow() {
            if (this.rightDone) {
                return null;
            }
            if (!this.leftDone) {
                if (this.l == null) {
                    this.l = SelectUnion.this.left.query(0);
                    this.l.reset();
                }
                if (this.l.next()) {
                    return this.l.currentRow();
                }
                this.leftDone = true;
            }
            if (this.r == null) {
                this.r = SelectUnion.this.right.query(0);
                this.r.reset();
            }
            if (this.r.next()) {
                return this.r.currentRow();
            }
            this.rightDone = true;
            return null;
        }

        @Override
        public void close() {
            super.close();
            if (this.l != null) {
                this.l.close();
            }
            if (this.r != null) {
                this.r.close();
            }
        }

        @Override
        public void reset() {
            super.reset();
            if (this.l != null) {
                this.l.reset();
            }
            if (this.r != null) {
                this.r.reset();
            }
            this.leftDone = false;
            this.rightDone = false;
        }
    }

    public static enum UnionType {
        UNION,
        UNION_ALL,
        EXCEPT,
        INTERSECT;

    }
}

