/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResultFactory;
import org.h2.result.ResultInterface;
import org.h2.result.RowFactory;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.security.auth.AuthenticatorFactory;
import org.h2.table.Table;
import org.h2.tools.CompressTool;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;

public class Set
extends Prepared {
    private final int type;
    private Expression expression;
    private String stringValue;
    private String[] stringValueList;

    public Set(Session session, int n) {
        super(session);
        this.type = n;
    }

    public void setString(String string2) {
        this.stringValue = string2;
    }

    @Override
    public boolean isTransactional() {
        switch (this.type) {
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 20: 
            case 26: 
            case 28: 
            case 34: 
            case 35: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Database database = this.session.getDatabase();
        String string2 = SetTypes.getTypeName(this.type);
        block7 : switch (this.type) {
            case 24: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0 || n > 2) {
                    throw DbException.getInvalidValueException("ALLOW_LITERALS", this.getIntValue());
                }
                database.setAllowLiterals(n);
                this.addOrUpdateSetting(string2, null, n);
                break;
            }
            case 8: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("CACHE_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setCacheSize(this.getIntValue());
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 13: {
                Session session;
                String string3;
                if ("TRUE".equals(this.stringValue) || (string3 = StringUtils.quoteStringSQL(this.stringValue)).equals(database.getCluster())) break;
                if (!string3.equals("''")) {
                    this.session.getUser().checkAdmin();
                }
                database.setCluster(string3);
                Session session2 = session = database.getSystemSession();
                synchronized (session2) {
                    Database database2 = database;
                    synchronized (database2) {
                        this.addOrUpdateSetting(session, string2, string3, 0);
                        session.commit(true);
                    }
                }
            }
            case 12: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                CompareMode compareMode2 = database.getCompareMode();
                boolean bl = compareMode2.isBinaryUnsigned();
                boolean bl2 = compareMode2.isUuidUnsigned();
                StringBuilder stringBuilder = new StringBuilder(this.stringValue);
                if (this.stringValue.equals("OFF")) {
                    compareMode = CompareMode.getInstance(null, 0, bl, bl2);
                } else {
                    int n = this.getIntValue();
                    stringBuilder.append(" STRENGTH ");
                    if (n == 3) {
                        stringBuilder.append("IDENTICAL");
                    } else if (n == 0) {
                        stringBuilder.append("PRIMARY");
                    } else if (n == 1) {
                        stringBuilder.append("SECONDARY");
                    } else if (n == 2) {
                        stringBuilder.append("TERTIARY");
                    }
                    compareMode = CompareMode.getInstance(this.stringValue, n, bl, bl2);
                }
                CompareMode compareMode3 = database.getCompareMode();
                if (compareMode3.equals(compareMode)) break;
                Table table2 = database.getFirstUserTable();
                if (table2 != null) {
                    throw DbException.get(90089, table2.getSQL(false));
                }
                this.addOrUpdateSetting(string2, stringBuilder.toString(), 0);
                database.setCompareMode(compareMode);
                break;
            }
            case 37: {
                Object object;
                boolean bl;
                this.session.getUser().checkAdmin();
                if (this.stringValue.equals("SIGNED")) {
                    bl = false;
                } else if (this.stringValue.equals("UNSIGNED")) {
                    bl = true;
                } else {
                    throw DbException.getInvalidValueException("BINARY_COLLATION", this.stringValue);
                }
                CompareMode compareMode = database.getCompareMode();
                if (compareMode.isBinaryUnsigned() != bl && (object = database.getFirstUserTable()) != null) {
                    throw DbException.get(90089, ((SchemaObjectBase)object).getSQL(false));
                }
                object = CompareMode.getInstance(compareMode.getName(), compareMode.getStrength(), bl, compareMode.isUuidUnsigned());
                this.addOrUpdateSetting(string2, this.stringValue, 0);
                database.setCompareMode((CompareMode)object);
                break;
            }
            case 50: {
                Object object;
                boolean bl;
                this.session.getUser().checkAdmin();
                if (this.stringValue.equals("SIGNED")) {
                    bl = false;
                } else if (this.stringValue.equals("UNSIGNED")) {
                    bl = true;
                } else {
                    throw DbException.getInvalidValueException("UUID_COLLATION", this.stringValue);
                }
                CompareMode compareMode = database.getCompareMode();
                if (compareMode.isUuidUnsigned() != bl && (object = database.getFirstUserTable()) != null) {
                    throw DbException.get(90089, ((SchemaObjectBase)object).getSQL(false));
                }
                object = CompareMode.getInstance(compareMode.getName(), compareMode.getStrength(), compareMode.isBinaryUnsigned(), bl);
                this.addOrUpdateSetting(string2, this.stringValue, 0);
                database.setCompareMode((CompareMode)object);
                break;
            }
            case 23: {
                this.session.getUser().checkAdmin();
                int n = CompressTool.getCompressAlgorithm(this.stringValue);
                database.setLobCompressionAlgorithm(n == 0 ? null : this.stringValue);
                this.addOrUpdateSetting(string2, this.stringValue, 0);
                break;
            }
            case 33: {
                this.session.getUser().checkAdmin();
                if (!database.isStarting()) break;
                int n = this.getIntValue();
                this.addOrUpdateSetting(string2, null, n);
                break;
            }
            case 15: {
                this.session.getUser().checkAdmin();
                database.setEventListenerClass(this.stringValue);
                break;
            }
            case 18: {
                int n = this.getIntValue();
                if (n != -1 && n < 0) {
                    throw DbException.getInvalidValueException("DB_CLOSE_DELAY", n);
                }
                this.session.getUser().checkAdmin();
                database.setCloseDelay(this.getIntValue());
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 6: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("DEFAULT_LOCK_TIMEOUT", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 7: {
                this.session.getUser().checkAdmin();
                database.setDefaultTableType(this.getIntValue());
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 32: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                switch (n) {
                    case 0: {
                        database.setExclusiveSession(null, false);
                        break block7;
                    }
                    case 1: {
                        database.setExclusiveSession(this.session, false);
                        break block7;
                    }
                    case 2: {
                        database.setExclusiveSession(this.session, true);
                        break block7;
                    }
                }
                throw DbException.getInvalidValueException("EXCLUSIVE", n);
            }
            case 38: {
                this.session.getUser().checkAdmin();
                Table table3 = database.getFirstUserTable();
                if (table3 != null) {
                    throw DbException.get(90141, table3.getSQL(false));
                }
                database.setJavaObjectSerializerName(this.stringValue);
                this.addOrUpdateSetting(string2, this.stringValue, 0);
                break;
            }
            case 1: {
                this.session.getUser().checkAdmin();
                database.setIgnoreCase(this.getIntValue() == 1);
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                database.setLockMode(this.getIntValue());
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 5: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("LOCK_TIMEOUT", this.getIntValue());
                }
                this.session.setLockTimeout(this.getIntValue());
                break;
            }
            case 19: {
                int n = this.getIntValue();
                if (!database.isPersistent() || n == database.getLogMode()) break;
                this.session.getUser().checkAdmin();
                database.setLogMode(n);
                break;
            }
            case 22: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_LENGTH_INPLACE_LOB", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxLengthInplaceLob(this.getIntValue());
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 2: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_LOG_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxLogSize((long)this.getIntValue() * 1024L * 1024L);
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 16: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_ROWS", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryRows(this.getIntValue());
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 21: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_UNDO", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryUndo(this.getIntValue());
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 31: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("MAX_OPERATION_MEMORY", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                database.setMaxOperationMemory(n);
                break;
            }
            case 3: {
                Mode mode = Mode.getInstance(this.stringValue);
                if (mode == null) {
                    throw DbException.get(90088, this.stringValue);
                }
                if (database.getMode() == mode) break;
                this.session.getUser().checkAdmin();
                database.setMode(mode);
                this.session.getColumnNamerConfiguration().configure(mode.getEnum());
                break;
            }
            case 25: {
                boolean bl;
                boolean bl3 = bl = this.getIntValue() == 1;
                if (database.isMultiThreaded() == bl) break;
                this.session.getUser().checkAdmin();
                database.setMultiThreaded(bl);
                break;
            }
            case 27: {
                this.session.getUser().checkAdmin();
                database.setOptimizeReuseResults(this.getIntValue() != 0);
                break;
            }
            case 35: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("QUERY_TIMEOUT", this.getIntValue());
                }
                int n = this.getIntValue();
                this.session.setQueryTimeout(n);
                break;
            }
            case 36: {
                int n = this.getIntValue();
                this.session.setRedoLogBinary(n == 1);
                break;
            }
            case 30: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0 || n > 1) {
                    throw DbException.getInvalidValueException("REFERENTIAL_INTEGRITY", this.getIntValue());
                }
                database.setReferentialIntegrity(n == 1);
                break;
            }
            case 40: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0 || n > 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS", this.getIntValue());
                }
                database.setQueryStatistics(n == 1);
                break;
            }
            case 41: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS_MAX_ENTRIES", this.getIntValue());
                }
                database.setQueryStatisticsMaxEntries(n);
                break;
            }
            case 26: {
                Schema schema = database.getSchema(this.stringValue);
                this.session.setCurrentSchema(schema);
                break;
            }
            case 28: {
                this.session.setSchemaSearchPath(this.stringValueList);
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                if (this.getPersistedObjectId() != 0) break;
                database.getTraceSystem().setLevelFile(this.getIntValue());
                break;
            }
            case 9: {
                this.session.getUser().checkAdmin();
                if (this.getPersistedObjectId() != 0) break;
                database.getTraceSystem().setLevelSystemOut(this.getIntValue());
                break;
            }
            case 11: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("TRACE_MAX_FILE_SIZE", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                int n = this.getIntValue() * 1024 * 1024;
                database.getTraceSystem().setMaxFileSize(n);
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 20: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("THROTTLE", this.getIntValue());
                }
                this.session.setThrottle(this.getIntValue());
                break;
            }
            case 29: {
                int n = this.getIntValue();
                if (n < 0 || n > 1) {
                    throw DbException.getInvalidValueException("UNDO_LOG", this.getIntValue());
                }
                this.session.setUndoLogEnabled(n == 1);
                break;
            }
            case 34: {
                Expression expression = this.expression.optimize(this.session);
                this.session.setVariable(this.stringValue, expression.getValue(this.session));
                break;
            }
            case 14: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("WRITE_DELAY", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setWriteDelay(this.getIntValue());
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 39: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("RETENTION_TIME", this.getIntValue());
                }
                this.session.getUser().checkAdmin();
                database.setRetentionTime(this.getIntValue());
                this.addOrUpdateSetting(string2, null, this.getIntValue());
                break;
            }
            case 42: {
                RowFactory rowFactory;
                this.session.getUser().checkAdmin();
                String string4 = this.expression.getColumnName();
                Class clazz = JdbcUtils.loadUserClass(string4);
                try {
                    rowFactory = (RowFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
                database.setRowFactory(rowFactory);
                break;
            }
            case 43: {
                int n = this.getIntValue();
                if (n != 0 && n != 1) {
                    throw DbException.getInvalidValueException("BATCH_JOINS", this.getIntValue());
                }
                this.session.setJoinBatchEnabled(n == 1);
                break;
            }
            case 44: {
                int n = this.getIntValue();
                if (n != 0 && n != 1) {
                    throw DbException.getInvalidValueException("FORCE_JOIN_ORDER", n);
                }
                this.session.setForceJoinOrder(n == 1);
                break;
            }
            case 45: {
                int n = this.getIntValue();
                if (n != 0 && n != 1) {
                    throw DbException.getInvalidValueException("LAZY_QUERY_EXECUTION", n);
                }
                this.session.setLazyQueryExecution(n == 1);
                break;
            }
            case 46: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n != 0 && n != 1) {
                    throw DbException.getInvalidValueException("BUILTIN_ALIAS_OVERRIDE", n);
                }
                database.setAllowBuiltinAliasOverride(n == 1);
                break;
            }
            case 47: {
                this.session.getUser().checkAdmin();
                this.session.getColumnNamerConfiguration().configure(this.expression.getColumnName());
                break;
            }
            case 48: {
                this.session.getUser().checkAdmin();
                try {
                    if (this.expression.getBooleanValue(this.session)) {
                        database.setAuthenticator(AuthenticatorFactory.createAuthenticator());
                    } else {
                        database.setAuthenticator(null);
                    }
                    this.addOrUpdateSetting(string2, this.expression.getValue(this.session).getString(), 0);
                    break;
                }
                catch (Exception exception) {
                    if (database.isStarting()) {
                        database.getTrace(2).error(exception, "{0}: failed to set authenticator during database start ", this.expression.toString());
                        break;
                    }
                    throw DbException.convert(exception);
                }
            }
            case 49: {
                this.session.getUser().checkAdmin();
                String string5 = this.expression.getColumnName();
                Class clazz = JdbcUtils.loadUserClass(string5);
                try {
                    LocalResultFactory localResultFactory = (LocalResultFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    database.setResultFactory(localResultFactory);
                    break;
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        database.getNextModificationDataId();
        database.getNextModificationMetaId();
        return 0;
    }

    private int getIntValue() {
        this.expression = this.expression.optimize(this.session);
        return this.expression.getValue(this.session).getInt();
    }

    public void setInt(int n) {
        this.expression = ValueExpression.get(ValueInt.get(n));
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    private void addOrUpdateSetting(String string2, String string3, int n) {
        this.addOrUpdateSetting(this.session, string2, string3, n);
    }

    private void addOrUpdateSetting(Session session, String string2, String string3, int n) {
        Database database = session.getDatabase();
        if (database.isReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(string2);
        boolean bl = false;
        if (setting == null) {
            bl = true;
            int n2 = this.getObjectId();
            setting = new Setting(database, n2, string2);
        }
        if (string3 != null) {
            if (!bl && setting.getStringValue().equals(string3)) {
                return;
            }
            setting.setStringValue(string3);
        } else {
            if (!bl && setting.getIntValue() == n) {
                return;
            }
            setting.setIntValue(n);
        }
        if (bl) {
            database.addDatabaseObject(session, setting);
        } else {
            database.updateMeta(session, setting);
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setStringArray(String[] stringArray) {
        this.stringValueList = stringArray;
    }

    @Override
    public int getType() {
        return 67;
    }
}

