/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import org.h2.engine.Database;
import org.h2.expression.aggregate.AggregateData;
import org.h2.expression.aggregate.AggregateType;
import org.h2.message.DbException;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

class AggregateDataDefault
extends AggregateData {
    private final AggregateType aggregateType;
    private final int dataType;
    private long count;
    private Value value;
    private double m2;
    private double mean;

    AggregateDataDefault(AggregateType aggregateType, int n) {
        this.aggregateType = aggregateType;
        this.dataType = n;
    }

    @Override
    void add(Database database, Value value2) {
        if (value2 == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        switch (this.aggregateType) {
            case SUM: {
                if (this.value == null) {
                    this.value = value2.convertTo(this.dataType);
                    break;
                }
                value2 = value2.convertTo(this.value.getValueType());
                this.value = this.value.add(value2);
                break;
            }
            case AVG: {
                if (this.value == null) {
                    this.value = value2.convertTo(DataType.getAddProofType(this.dataType));
                    break;
                }
                value2 = value2.convertTo(this.value.getValueType());
                this.value = this.value.add(value2);
                break;
            }
            case MIN: {
                if (this.value != null && database.compare(value2, this.value) >= 0) break;
                this.value = value2;
                break;
            }
            case MAX: {
                if (this.value != null && database.compare(value2, this.value) <= 0) break;
                this.value = value2;
                break;
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                double d = value2.getDouble();
                if (this.count == 1L) {
                    this.mean = d;
                    this.m2 = 0.0;
                    break;
                }
                double d2 = d - this.mean;
                this.mean += d2 / (double)this.count;
                this.m2 += d2 * (d - this.mean);
                break;
            }
            case EVERY: {
                value2 = value2.convertTo(1);
                if (this.value == null) {
                    this.value = value2;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() && value2.getBoolean());
                break;
            }
            case ANY: {
                value2 = value2.convertTo(1);
                if (this.value == null) {
                    this.value = value2;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() || value2.getBoolean());
                break;
            }
            case BIT_AND: {
                if (this.value == null) {
                    this.value = value2.convertTo(this.dataType);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() & value2.getLong()).convertTo(this.dataType);
                break;
            }
            case BIT_OR: {
                if (this.value == null) {
                    this.value = value2.convertTo(this.dataType);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() | value2.getLong()).convertTo(this.dataType);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
    }

    @Override
    Value getValue(Database database, int n) {
        Value value2 = null;
        switch (this.aggregateType) {
            case SUM: 
            case MIN: 
            case MAX: 
            case EVERY: 
            case ANY: 
            case BIT_AND: 
            case BIT_OR: {
                value2 = this.value;
                break;
            }
            case AVG: {
                if (this.value == null) break;
                value2 = AggregateDataDefault.divide(this.value, this.count);
                break;
            }
            case STDDEV_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value2 = ValueDouble.get(Math.sqrt(this.m2 / (double)this.count));
                break;
            }
            case STDDEV_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value2 = ValueDouble.get(Math.sqrt(this.m2 / (double)(this.count - 1L)));
                break;
            }
            case VAR_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value2 = ValueDouble.get(this.m2 / (double)this.count);
                break;
            }
            case VAR_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value2 = ValueDouble.get(this.m2 / (double)(this.count - 1L));
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return value2 == null ? ValueNull.INSTANCE : value2.convertTo(n);
    }

    private static Value divide(Value value2, long l) {
        if (l == 0L) {
            return ValueNull.INSTANCE;
        }
        int n = Value.getHigherOrder(value2.getValueType(), 5);
        Value value3 = ValueLong.get(l).convertTo(n);
        value2 = value2.convertTo(n).divide(value3);
        return value2;
    }
}

