/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.NonUniqueHashCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PageStoreTable;
import org.h2.table.TableFilter;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;

public class NonUniqueHashIndex
extends BaseIndex {
    private final int indexColumn;
    private final boolean totalOrdering;
    private Map<Value, ArrayList<Long>> rows;
    private final PageStoreTable tableData;
    private long rowCount;

    public NonUniqueHashIndex(PageStoreTable pageStoreTable, int n, String string2, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(pageStoreTable, n, string2, indexColumnArray, indexType);
        Column column = indexColumnArray[0].column;
        this.indexColumn = column.getColumnId();
        this.totalOrdering = DataType.hasTotalOrdering(column.getType().getValueType());
        this.tableData = pageStoreTable;
        this.reset();
    }

    private void reset() {
        this.rows = this.totalOrdering ? new HashMap() : new TreeMap(this.database.getCompareMode());
        this.rowCount = 0L;
    }

    @Override
    public void truncate(Session session) {
        this.reset();
    }

    @Override
    public void add(Session session, Row row) {
        Value value2 = row.getValue(this.indexColumn);
        ArrayList<Long> arrayList = this.rows.get(value2);
        if (arrayList == null) {
            arrayList = Utils.newSmallArrayList();
            this.rows.put(value2, arrayList);
        }
        arrayList.add(row.getKey());
        ++this.rowCount;
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.rowCount == 1L) {
            this.reset();
        } else {
            Value value2 = row.getValue(this.indexColumn);
            ArrayList<Long> arrayList = this.rows.get(value2);
            if (arrayList.size() == 1) {
                this.rows.remove(value2);
            } else {
                arrayList.remove(row.getKey());
            }
            --this.rowCount;
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == null || searchRow2 == null) {
            throw DbException.throwInternalError(searchRow + " " + searchRow2);
        }
        if (searchRow != searchRow2 && this.compareKeys(searchRow, searchRow2) != 0) {
            throw DbException.throwInternalError();
        }
        Value value2 = searchRow.getValue(this.indexColumn);
        value2 = value2.convertTo(this.tableData.getColumn(this.indexColumn).getType(), this.database.getMode(), null);
        ArrayList<Long> arrayList = this.rows.get(value2);
        return new NonUniqueHashCursor(session, this.tableData, arrayList);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void remove(Session session) {
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        for (Column column : this.columns) {
            int n2 = column.getColumnId();
            int n3 = nArray[n2];
            if ((n3 & 1) == 1) continue;
            return 9.223372036854776E18;
        }
        return 2.0;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.getUnsupportedException("HASH");
    }

    @Override
    public boolean canScan() {
        return false;
    }
}

