/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.h2.command.CommandInterface;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Mode;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionRemote;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcArray;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcCallableStatement;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnectionBackwardsCompat;
import org.h2.jdbc.JdbcDatabaseMetaData;
import org.h2.jdbc.JdbcLob;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcSQLXML;
import org.h2.jdbc.JdbcSavepoint;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.CloseWatcher;
import org.h2.util.JdbcUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBytes;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueString;

public class JdbcConnection
extends TraceObject
implements Connection,
JdbcConnectionBackwardsCompat {
    private static final String NUM_SERVERS = "numServers";
    private static final String PREFIX_SERVER = "server";
    private static boolean keepOpenStackTrace;
    private final String url;
    private final String user;
    private int holdability = 1;
    private SessionInterface session;
    private CommandInterface commit;
    private CommandInterface rollback;
    private CommandInterface getReadOnly;
    private CommandInterface getGeneratedKeys;
    private CommandInterface setLockMode;
    private CommandInterface getLockMode;
    private CommandInterface setQueryTimeout;
    private CommandInterface getQueryTimeout;
    private int savepointId;
    private String catalog;
    private Statement executingStatement;
    private final CloseWatcher watcher;
    private int queryTimeoutCache = -1;
    private Map<String, String> clientInfo;
    private volatile Settings settings;
    private final boolean scopeGeneratedKeys;

    public JdbcConnection(String string2, Properties properties) throws SQLException {
        this(new ConnectionInfo(string2, properties), true);
    }

    public JdbcConnection(ConnectionInfo connectionInfo, boolean bl) throws SQLException {
        try {
            String string2;
            if (bl && (string2 = SysProperties.getBaseDir()) != null) {
                connectionInfo.setBaseDir(string2);
            }
            this.session = new SessionRemote(connectionInfo).connectEmbeddedOrServer(false);
            this.trace = this.session.getTrace();
            int n = JdbcConnection.getNextId(1);
            this.setTrace(this.trace, 1, n);
            this.user = connectionInfo.getUserName();
            if (this.isInfoEnabled()) {
                this.trace.infoCode("Connection " + this.getTraceObjectName() + " = DriverManager.getConnection(" + JdbcConnection.quote(connectionInfo.getOriginalURL()) + ", " + JdbcConnection.quote(this.user) + ", \"\");");
            }
            this.url = connectionInfo.getURL();
            this.scopeGeneratedKeys = connectionInfo.getProperty("SCOPE_GENERATED_KEYS", false);
            this.closeOld();
            this.watcher = CloseWatcher.register(this, this.session, keepOpenStackTrace);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public JdbcConnection(JdbcConnection jdbcConnection) {
        this.session = jdbcConnection.session;
        this.trace = this.session.getTrace();
        int n = JdbcConnection.getNextId(1);
        this.setTrace(this.trace, 1, n);
        this.user = jdbcConnection.user;
        this.url = jdbcConnection.url;
        this.catalog = jdbcConnection.catalog;
        this.commit = jdbcConnection.commit;
        this.getGeneratedKeys = jdbcConnection.getGeneratedKeys;
        this.getLockMode = jdbcConnection.getLockMode;
        this.getQueryTimeout = jdbcConnection.getQueryTimeout;
        this.getReadOnly = jdbcConnection.getReadOnly;
        this.rollback = jdbcConnection.rollback;
        this.scopeGeneratedKeys = jdbcConnection.scopeGeneratedKeys;
        this.watcher = null;
        if (jdbcConnection.clientInfo != null) {
            this.clientInfo = new HashMap<String, String>(jdbcConnection.clientInfo);
        }
    }

    public JdbcConnection(SessionInterface sessionInterface, String string2, String string3) {
        this.session = sessionInterface;
        this.trace = sessionInterface.getTrace();
        int n = JdbcConnection.getNextId(1);
        this.setTrace(this.trace, 1, n);
        this.user = string2;
        this.url = string3;
        this.scopeGeneratedKeys = false;
        this.watcher = null;
    }

    private void closeOld() {
        CloseWatcher closeWatcher;
        while ((closeWatcher = CloseWatcher.pollUnclosed()) != null) {
            try {
                closeWatcher.getCloseable().close();
            }
            catch (Exception exception) {
                this.trace.error(exception, "closing session");
            }
            keepOpenStackTrace = true;
            String string2 = closeWatcher.getOpenStackTrace();
            DbException dbException = DbException.get(90018);
            this.trace.error(dbException, string2);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n, "createStatement()");
            }
            this.checkClosed();
            return new JdbcStatement(this, n, 1003, 1007, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            int n3 = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n3, "createStatement(" + n + ", " + n2 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            this.checkClosed();
            return new JdbcStatement(this, n3, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            int n4 = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n4, "createStatement(" + n + ", " + n2 + ", " + n3 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            JdbcConnection.checkHoldability(n3);
            this.checkClosed();
            return new JdbcStatement(this, n4, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string2) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + JdbcConnection.quote(string2) + ")");
            }
            this.checkClosed();
            string2 = JdbcConnection.translateSQL(string2);
            return new JdbcPreparedStatement(this, string2, n, 1003, 1007, false, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    PreparedStatement prepareAutoCloseStatement(String string2) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + JdbcConnection.quote(string2) + ")");
            }
            this.checkClosed();
            string2 = JdbcConnection.translateSQL(string2);
            return new JdbcPreparedStatement(this, string2, n, 1003, 1007, true, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(2);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("DatabaseMetaData", 2, n, "getMetaData()");
            }
            this.checkClosed();
            return new JdbcDatabaseMetaData(this, this.trace, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public SessionInterface getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            if (this.session == null) {
                return;
            }
            CloseWatcher.unregister(this.watcher);
            this.session.cancel();
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                block19: {
                    if (this.executingStatement != null) {
                        try {
                            this.executingStatement.cancel();
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    try {
                        if (this.session.isClosed()) break block19;
                        try {
                            if (this.session.hasPendingTransaction()) {
                                block20: {
                                    if (!this.session.isReconnectNeeded(true)) {
                                        try {
                                            this.rollbackInternal();
                                        }
                                        catch (DbException dbException) {
                                            if (dbException.getErrorCode() == 90067) break block20;
                                            throw dbException;
                                        }
                                    }
                                }
                                this.session.afterWriting();
                            }
                            this.closePreparedCommands();
                        }
                        finally {
                            this.session.close();
                        }
                    }
                    finally {
                        this.session = null;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    private void closePreparedCommands() {
        this.commit = JdbcConnection.closeAndSetNull(this.commit);
        this.rollback = JdbcConnection.closeAndSetNull(this.rollback);
        this.getReadOnly = JdbcConnection.closeAndSetNull(this.getReadOnly);
        this.getGeneratedKeys = JdbcConnection.closeAndSetNull(this.getGeneratedKeys);
        this.getLockMode = JdbcConnection.closeAndSetNull(this.getLockMode);
        this.setLockMode = JdbcConnection.closeAndSetNull(this.setLockMode);
        this.getQueryTimeout = JdbcConnection.closeAndSetNull(this.getQueryTimeout);
        this.setQueryTimeout = JdbcConnection.closeAndSetNull(this.setQueryTimeout);
    }

    private static CommandInterface closeAndSetNull(CommandInterface commandInterface) {
        if (commandInterface != null) {
            commandInterface.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAutoCommit(" + bl + ");");
            }
            this.checkClosed();
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                if (bl && !this.session.getAutoCommit()) {
                    this.commit();
                }
                this.session.setAutoCommit(bl);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            this.checkClosed();
            this.debugCodeCall("getAutoCommit");
            return this.session.getAutoCommit();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void commit() throws SQLException {
        try {
            this.debugCodeCall("commit");
            this.checkClosedForWrite();
            try {
                this.commit = this.prepareCommand("COMMIT", this.commit);
                this.commit.executeUpdate(false);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() throws SQLException {
        try {
            this.debugCodeCall("rollback");
            this.checkClosedForWrite();
            try {
                this.rollbackInternal();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.session == null || this.session.isClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String nativeSQL(String string2) throws SQLException {
        try {
            this.debugCodeCall("nativeSQL", string2);
            this.checkClosed();
            return JdbcConnection.translateSQL(string2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setReadOnly(" + bl + ");");
            }
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.debugCodeCall("isReadOnly");
            this.checkClosed();
            this.getReadOnly = this.prepareCommand("CALL READONLY()", this.getReadOnly);
            ResultInterface resultInterface = this.getReadOnly.executeQuery(0, false);
            resultInterface.next();
            return resultInterface.currentRow()[0].getBoolean();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setCatalog(String string2) throws SQLException {
        try {
            this.debugCodeCall("setCatalog", string2);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.debugCodeCall("getCatalog");
            this.checkClosed();
            if (this.catalog == null) {
                CommandInterface commandInterface = this.prepareCommand("CALL DATABASE()", Integer.MAX_VALUE);
                ResultInterface resultInterface = commandInterface.executeQuery(0, false);
                resultInterface.next();
                this.catalog = resultInterface.currentRow()[0].getString();
                commandInterface.close();
            }
            return this.catalog;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string2, int n, int n2) throws SQLException {
        try {
            int n3 = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n3, "prepareStatement(" + JdbcConnection.quote(string2) + ", " + n + ", " + n2 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            this.checkClosed();
            string2 = JdbcConnection.translateSQL(string2);
            return new JdbcPreparedStatement(this, string2, n3, n, n2, false, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        try {
            int n2;
            this.debugCodeCall("setTransactionIsolation", n);
            this.checkClosed();
            switch (n) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 8: {
                    n2 = 1;
                    break;
                }
                default: {
                    throw DbException.getInvalidValueException("level", n);
                }
            }
            this.commit();
            this.setLockMode = this.prepareCommand("SET LOCK_MODE ?", this.setLockMode);
            this.setLockMode.getParameters().get(0).setValue(ValueInt.get(n2), false);
            this.setLockMode.executeUpdate(false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", n);
            this.checkClosed();
            this.setQueryTimeout = this.prepareCommand("SET QUERY_TIMEOUT ?", this.setQueryTimeout);
            this.setQueryTimeout.getParameters().get(0).setValue(ValueInt.get(n * 1000), false);
            this.setQueryTimeout.executeUpdate(false);
            this.queryTimeoutCache = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    int getQueryTimeout() throws SQLException {
        try {
            if (this.queryTimeoutCache == -1) {
                this.checkClosed();
                this.getQueryTimeout = this.prepareCommand("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?", this.getQueryTimeout);
                this.getQueryTimeout.getParameters().get(0).setValue(ValueString.get("QUERY_TIMEOUT"), false);
                ResultInterface resultInterface = this.getQueryTimeout.executeQuery(0, false);
                resultInterface.next();
                int n = resultInterface.currentRow()[0].getInt();
                resultInterface.close();
                if (n != 0) {
                    n = (n + 999) / 1000;
                }
                this.queryTimeoutCache = n;
            }
            return this.queryTimeoutCache;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            int n;
            this.debugCodeCall("getTransactionIsolation");
            this.checkClosed();
            this.getLockMode = this.prepareCommand("CALL LOCK_MODE()", this.getLockMode);
            ResultInterface resultInterface = this.getLockMode.executeQuery(0, false);
            resultInterface.next();
            int n2 = resultInterface.currentRow()[0].getInt();
            resultInterface.close();
            switch (n2) {
                case 0: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n = 8;
                    break;
                }
                default: {
                    throw DbException.throwInternalError("lockMode:" + n2);
                }
            }
            return n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        try {
            this.debugCodeCall("setHoldability", n);
            this.checkClosed();
            JdbcConnection.checkHoldability(n);
            this.holdability = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.holdability;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.debugCodeCall("getTypeMap");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTypeMap(" + JdbcConnection.quoteMap(map2) + ");");
            }
            JdbcConnection.checkMap(map2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string2) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n, "prepareCall(" + JdbcConnection.quote(string2) + ")");
            }
            this.checkClosed();
            string2 = JdbcConnection.translateSQL(string2);
            return new JdbcCallableStatement(this, string2, n, 1003, 1007);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string2, int n, int n2) throws SQLException {
        try {
            int n3 = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n3, "prepareCall(" + JdbcConnection.quote(string2) + ", " + n + ", " + n2 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            this.checkClosed();
            string2 = JdbcConnection.translateSQL(string2);
            return new JdbcCallableStatement(this, string2, n3, n, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string2, int n, int n2, int n3) throws SQLException {
        try {
            int n4 = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n4, "prepareCall(" + JdbcConnection.quote(string2) + ", " + n + ", " + n2 + ", " + n3 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            JdbcConnection.checkHoldability(n3);
            this.checkClosed();
            string2 = JdbcConnection.translateSQL(string2);
            return new JdbcCallableStatement(this, string2, n4, n, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, n, "setSavepoint()");
            }
            this.checkClosed();
            CommandInterface commandInterface = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(null, this.savepointId), Integer.MAX_VALUE);
            commandInterface.executeUpdate(false);
            JdbcSavepoint jdbcSavepoint = new JdbcSavepoint(this, this.savepointId, null, this.trace, n);
            ++this.savepointId;
            return jdbcSavepoint;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Savepoint setSavepoint(String string2) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, n, "setSavepoint(" + JdbcConnection.quote(string2) + ")");
            }
            this.checkClosed();
            CommandInterface commandInterface = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(string2, 0), Integer.MAX_VALUE);
            commandInterface.executeUpdate(false);
            return new JdbcSavepoint(this, 0, string2, this.trace, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            JdbcSavepoint jdbcSavepoint = JdbcConnection.convertSavepoint(savepoint);
            if (this.isDebugEnabled()) {
                this.debugCode("rollback(" + jdbcSavepoint.getTraceObjectName() + ");");
            }
            this.checkClosedForWrite();
            try {
                jdbcSavepoint.rollback();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.debugCode("releaseSavepoint(savepoint);");
            this.checkClosed();
            JdbcConnection.convertSavepoint(savepoint).release();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private static JdbcSavepoint convertSavepoint(Savepoint savepoint) {
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw DbException.get(90063, String.valueOf(savepoint));
        }
        return (JdbcSavepoint)savepoint;
    }

    @Override
    public PreparedStatement prepareStatement(String string2, int n, int n2, int n3) throws SQLException {
        try {
            int n4 = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n4, "prepareStatement(" + JdbcConnection.quote(string2) + ", " + n + ", " + n2 + ", " + n3 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            JdbcConnection.checkHoldability(n3);
            this.checkClosed();
            string2 = JdbcConnection.translateSQL(string2);
            return new JdbcPreparedStatement(this, string2, n4, n, n2, false, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string2, int n) throws SQLException {
        try {
            int n2 = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n2, "prepareStatement(" + JdbcConnection.quote(string2) + ", " + n + ");");
            }
            this.checkClosed();
            string2 = JdbcConnection.translateSQL(string2);
            return new JdbcPreparedStatement(this, string2, n2, 1003, 1007, false, n == 1);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string2, int[] nArray) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + JdbcConnection.quote(string2) + ", " + JdbcConnection.quoteIntArray(nArray) + ");");
            }
            this.checkClosed();
            string2 = JdbcConnection.translateSQL(string2);
            return new JdbcPreparedStatement(this, string2, n, 1003, 1007, false, nArray);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string2, String[] stringArray) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + JdbcConnection.quote(string2) + ", " + JdbcConnection.quoteArray(stringArray) + ");");
            }
            this.checkClosed();
            string2 = JdbcConnection.translateSQL(string2);
            return new JdbcPreparedStatement(this, string2, n, 1003, 1007, false, stringArray);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    CommandInterface prepareCommand(String string2, int n) {
        return this.session.prepareCommand(string2, n);
    }

    private CommandInterface prepareCommand(String string2, CommandInterface commandInterface) {
        return commandInterface == null ? this.session.prepareCommand(string2, Integer.MAX_VALUE) : commandInterface;
    }

    private static int translateGetEnd(String string2, int n, char c) {
        int n2 = string2.length();
        switch (c) {
            case '$': {
                if (n < n2 - 1 && string2.charAt(n + 1) == '$' && (n == 0 || string2.charAt(n - 1) <= ' ')) {
                    int n3 = string2.indexOf("$$", n + 2);
                    if (n3 < 0) {
                        throw DbException.getSyntaxError(string2, n);
                    }
                    return n3 + 1;
                }
                return n;
            }
            case '\'': {
                int n4 = string2.indexOf(39, n + 1);
                if (n4 < 0) {
                    throw DbException.getSyntaxError(string2, n);
                }
                return n4;
            }
            case '\"': {
                int n5 = string2.indexOf(34, n + 1);
                if (n5 < 0) {
                    throw DbException.getSyntaxError(string2, n);
                }
                return n5;
            }
            case '/': {
                JdbcConnection.checkRunOver(n + 1, n2, string2);
                if (string2.charAt(n + 1) == '*') {
                    int n6 = string2.indexOf("*/", n + 2);
                    if (n6 < 0) {
                        throw DbException.getSyntaxError(string2, n);
                    }
                    n = n6 + 1;
                } else if (string2.charAt(n + 1) == '/') {
                    n += 2;
                    while (n < n2 && (c = string2.charAt(n)) != '\r' && c != '\n') {
                        ++n;
                    }
                }
                return n;
            }
            case '-': {
                JdbcConnection.checkRunOver(n + 1, n2, string2);
                if (string2.charAt(n + 1) == '-') {
                    n += 2;
                    while (n < n2 && (c = string2.charAt(n)) != '\r' && c != '\n') {
                        ++n;
                    }
                }
                return n;
            }
        }
        throw DbException.throwInternalError("c=" + c);
    }

    private static String translateSQL(String string2) {
        return JdbcConnection.translateSQL(string2, true);
    }

    static String translateSQL(String string2, boolean bl) {
        if (string2 == null) {
            throw DbException.getInvalidValueException("SQL", null);
        }
        if (!bl) {
            return string2;
        }
        if (string2.indexOf(123) < 0) {
            return string2;
        }
        int n = string2.length();
        char[] cArray = null;
        int n2 = 0;
        block9: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '-': 
                case '/': {
                    i = JdbcConnection.translateGetEnd(string2, i, c);
                    continue block9;
                }
                case '{': {
                    ++n2;
                    if (cArray == null) {
                        cArray = string2.toCharArray();
                    }
                    cArray[i] = 32;
                    while (Character.isSpaceChar(cArray[i])) {
                        JdbcConnection.checkRunOver(++i, n, string2);
                    }
                    int n3 = i;
                    if (cArray[i] >= '0' && cArray[i] <= '9') {
                        cArray[i - 1] = 123;
                        while (true) {
                            JdbcConnection.checkRunOver(i, n, string2);
                            c = cArray[i];
                            if (c == '}') break;
                            switch (c) {
                                case '\"': 
                                case '\'': 
                                case '-': 
                                case '/': {
                                    i = JdbcConnection.translateGetEnd(string2, i, c);
                                    break;
                                }
                            }
                            ++i;
                        }
                        --n2;
                        continue block9;
                    }
                    if (cArray[i] == '?') {
                        JdbcConnection.checkRunOver(++i, n, string2);
                        while (Character.isSpaceChar(cArray[i])) {
                            JdbcConnection.checkRunOver(++i, n, string2);
                        }
                        if (string2.charAt(i) != '=') {
                            throw DbException.getSyntaxError(string2, i, "=");
                        }
                        JdbcConnection.checkRunOver(++i, n, string2);
                        while (Character.isSpaceChar(cArray[i])) {
                            JdbcConnection.checkRunOver(++i, n, string2);
                        }
                    }
                    while (!Character.isSpaceChar(cArray[i])) {
                        JdbcConnection.checkRunOver(++i, n, string2);
                    }
                    int n4 = 0;
                    if (JdbcConnection.found(string2, n3, "fn")) {
                        n4 = 2;
                    } else {
                        if (JdbcConnection.found(string2, n3, "escape") || JdbcConnection.found(string2, n3, "call")) continue block9;
                        if (JdbcConnection.found(string2, n3, "oj")) {
                            n4 = 2;
                        } else {
                            if (JdbcConnection.found(string2, n3, "ts") || JdbcConnection.found(string2, n3, "t") || JdbcConnection.found(string2, n3, "d")) continue block9;
                            if (JdbcConnection.found(string2, n3, "params")) {
                                n4 = "params".length();
                            }
                        }
                    }
                    i = n3;
                    while (n4 > 0) {
                        cArray[i] = 32;
                        ++i;
                        --n4;
                    }
                    continue block9;
                }
                case '}': {
                    if (--n2 < 0) {
                        throw DbException.getSyntaxError(string2, i);
                    }
                    cArray[i] = 32;
                    continue block9;
                }
                case '$': {
                    i = JdbcConnection.translateGetEnd(string2, i, c);
                    continue block9;
                }
            }
        }
        if (n2 != 0) {
            throw DbException.getSyntaxError(string2, string2.length() - 1);
        }
        if (cArray != null) {
            string2 = new String(cArray);
        }
        return string2;
    }

    private static void checkRunOver(int n, int n2, String string2) {
        if (n >= n2) {
            throw DbException.getSyntaxError(string2, n);
        }
    }

    private static boolean found(String string2, int n, String string3) {
        return string2.regionMatches(true, n, string3, 0, string3.length());
    }

    private static void checkTypeConcurrency(int n, int n2) {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("resultSetType", n);
            }
        }
        switch (n2) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("resultSetConcurrency", n2);
            }
        }
    }

    private static void checkHoldability(int n) {
        if (n != 1 && n != 2) {
            throw DbException.getInvalidValueException("resultSetHoldability", n);
        }
    }

    protected void checkClosed() {
        this.checkClosed(false);
    }

    private void checkClosedForWrite() {
        this.checkClosed(true);
    }

    protected void checkClosed(boolean bl) {
        if (this.session == null) {
            throw DbException.get(90007);
        }
        if (this.session.isClosed()) {
            throw DbException.get(90121);
        }
        if (this.session.isReconnectNeeded(bl)) {
            this.trace.debug("reconnect");
            this.closePreparedCommands();
            this.session = this.session.reconnect(bl);
            this.trace = this.session.getTrace();
        }
    }

    protected void afterWriting() {
        if (this.session != null) {
            this.session.afterWriting();
        }
    }

    String getURL() {
        this.checkClosed();
        return this.url;
    }

    String getUser() {
        this.checkClosed();
        return this.user;
    }

    private void rollbackInternal() {
        this.rollback = this.prepareCommand("ROLLBACK", this.rollback);
        this.rollback.executeUpdate(false);
    }

    public int getPowerOffCount() {
        return this.session == null || this.session.isClosed() ? 0 : this.session.getPowerOffCount();
    }

    public void setPowerOffCount(int n) {
        if (this.session != null) {
            this.session.setPowerOffCount(n);
        }
    }

    public void setExecutingStatement(Statement statement) {
        this.executingStatement = statement;
    }

    boolean scopeGeneratedKeys() {
        return this.scopeGeneratedKeys;
    }

    JdbcResultSet getGeneratedKeys(JdbcStatement jdbcStatement, int n) {
        this.getGeneratedKeys = this.prepareCommand("SELECT SCOPE_IDENTITY() WHERE SCOPE_IDENTITY() IS NOT NULL", this.getGeneratedKeys);
        ResultInterface resultInterface = this.getGeneratedKeys.executeQuery(0, false);
        return new JdbcResultSet(this, jdbcStatement, this.getGeneratedKeys, resultInterface, n, false, true, false);
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(10);
            this.debugCodeAssign("Clob", 10, n, "createClob()");
            this.checkClosedForWrite();
            return new JdbcClob(this, ValueString.EMPTY, JdbcLob.State.NEW, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(9);
            this.debugCodeAssign("Blob", 9, n, "createClob()");
            this.checkClosedForWrite();
            return new JdbcBlob(this, ValueBytes.EMPTY, JdbcLob.State.NEW, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(10);
            this.debugCodeAssign("NClob", 10, n, "createNClob()");
            this.checkClosedForWrite();
            return new JdbcClob(this, ValueString.EMPTY, JdbcLob.State.NEW, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(17);
            this.debugCodeAssign("SQLXML", 17, n, "createSQLXML()");
            this.checkClosedForWrite();
            return new JdbcSQLXML(this, ValueString.EMPTY, JdbcLob.State.NEW, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Array createArrayOf(String string2, Object[] objectArray) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(16);
            this.debugCodeAssign("Array", 16, n, "createArrayOf()");
            this.checkClosed();
            Value value2 = DataType.convertToValue(this.session, objectArray, 17);
            return new JdbcArray(this, value2, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Struct createStruct(String string2, Object[] objectArray) throws SQLException {
        throw this.unsupported("Struct");
    }

    @Override
    public synchronized boolean isValid(int n) {
        try {
            this.debugCodeCall("isValid", n);
            if (this.session == null || this.session.isClosed()) {
                return false;
            }
            this.getTransactionIsolation();
            return true;
        }
        catch (Exception exception) {
            this.logAndConvert(exception);
            return false;
        }
    }

    @Override
    public void setClientInfo(String string2, String string3) throws SQLClientInfoException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClientInfo(" + JdbcConnection.quote(string2) + ", " + JdbcConnection.quote(string3) + ");");
            }
            this.checkClosed();
            if (Objects.equals(string3, this.getClientInfo(string2))) {
                return;
            }
            if (JdbcConnection.isInternalProperty(string2)) {
                throw new SQLClientInfoException("Property name '" + string2 + " is used internally by H2.", Collections.emptyMap());
            }
            Pattern pattern = this.getMode().supportedClientInfoPropertiesRegEx;
            if (pattern != null && pattern.matcher(string2).matches()) {
                if (this.clientInfo == null) {
                    this.clientInfo = new HashMap<String, String>();
                }
            } else {
                throw new SQLClientInfoException("Client info name '" + string2 + "' not supported.", Collections.emptyMap());
            }
            this.clientInfo.put(string2, string3);
        }
        catch (Exception exception) {
            throw JdbcConnection.convertToClientInfoException(this.logAndConvert(exception));
        }
    }

    private static boolean isInternalProperty(String string2) {
        return NUM_SERVERS.equals(string2) || string2.startsWith(PREFIX_SERVER);
    }

    private static SQLClientInfoException convertToClientInfoException(SQLException sQLException) {
        if (sQLException instanceof SQLClientInfoException) {
            return (SQLClientInfoException)sQLException;
        }
        return new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), null, null);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClientInfo(properties);");
            }
            this.checkClosed();
            if (this.clientInfo == null) {
                this.clientInfo = new HashMap<String, String>();
            } else {
                this.clientInfo.clear();
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.setClientInfo((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (Exception exception) {
            throw JdbcConnection.convertToClientInfoException(this.logAndConvert(exception));
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getClientInfo();");
            }
            this.checkClosed();
            ArrayList<String> arrayList = this.session.getClusterServers();
            Properties properties = new Properties();
            if (this.clientInfo != null) {
                for (Map.Entry<String, String> entry : this.clientInfo.entrySet()) {
                    properties.setProperty(entry.getKey(), entry.getValue());
                }
            }
            properties.setProperty(NUM_SERVERS, Integer.toString(arrayList.size()));
            for (int i = 0; i < arrayList.size(); ++i) {
                properties.setProperty(PREFIX_SERVER + i, arrayList.get(i));
            }
            return properties;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getClientInfo(String string2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getClientInfo", string2);
            }
            this.checkClosed();
            if (string2 == null) {
                throw DbException.getInvalidValueException("name", null);
            }
            return this.getClientInfo().getProperty(string2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            if (this.isWrapperFor(clazz)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", clazz);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    public Value createClob(Reader reader, long l) {
        if (reader == null) {
            return ValueNull.INSTANCE;
        }
        if (l <= 0L) {
            l = -1L;
        }
        Value value2 = this.session.getDataHandler().getLobStorage().createClob(reader, l);
        this.session.addTemporaryLob(value2);
        return value2;
    }

    public Value createBlob(InputStream inputStream2, long l) {
        if (inputStream2 == null) {
            return ValueNull.INSTANCE;
        }
        if (l <= 0L) {
            l = -1L;
        }
        Value value2 = this.session.getDataHandler().getLobStorage().createBlob(inputStream2, l);
        this.session.addTemporaryLob(value2);
        return value2;
    }

    @Override
    public void setSchema(String string2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("setSchema", string2);
            }
            this.checkClosed();
            this.session.setCurrentSchemaName(string2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getSchema");
            }
            this.checkClosed();
            return this.session.getCurrentSchemaName();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void abort(Executor executor) {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) {
    }

    @Override
    public int getNetworkTimeout() {
        return 0;
    }

    static void checkMap(Map<String, Class<?>> map2) {
        if (map2 != null && map2.size() > 0) {
            throw DbException.getUnsupportedException("map.size > 0");
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.url + " user=" + this.user;
    }

    Object convertToDefaultObject(Value value2) {
        switch (value2.getValueType()) {
            case 16: {
                int n = JdbcConnection.getNextId(10);
                return new JdbcClob(this, value2, JdbcLob.State.WITH_VALUE, n);
            }
            case 15: {
                int n = JdbcConnection.getNextId(9);
                return new JdbcBlob(this, value2, JdbcLob.State.WITH_VALUE, n);
            }
            case 19: {
                if (!SysProperties.serializeJavaObject) break;
                return JdbcUtils.deserialize(value2.getBytesNoCopy(), this.session.getDataHandler());
            }
            case 18: {
                int n = JdbcConnection.getNextId(4);
                return new JdbcResultSet(this, null, null, ((ValueResultSet)value2).getResult(), n, false, true, false);
            }
            case 2: 
            case 3: {
                if (SysProperties.OLD_RESULT_SET_GET_OBJECT) break;
                return value2.getInt();
            }
        }
        return value2.getObject();
    }

    CompareMode getCompareMode() {
        return this.session.getDataHandler().getCompareMode();
    }

    public void setTraceLevel(int n) {
        this.trace.setLevel(n);
    }

    Mode getMode() throws SQLException {
        return this.getSettings().mode;
    }

    public Settings getSettings() throws SQLException {
        Settings settings = this.settings;
        if (settings == null) {
            String string2 = Mode.ModeEnum.REGULAR.name();
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            try (Object object = this.prepareStatement("SELECT NAME, VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME IN (?, ?, ?, ?)");){
                object.setString(1, "MODE");
                object.setString(2, "DATABASE_TO_UPPER");
                object.setString(3, "DATABASE_TO_LOWER");
                object.setString(4, "CASE_INSENSITIVE_IDENTIFIERS");
                ResultSet resultSet = object.executeQuery();
                while (resultSet.next()) {
                    String string3 = resultSet.getString(2);
                    switch (resultSet.getString(1)) {
                        case "MODE": {
                            string2 = string3;
                            break;
                        }
                        case "DATABASE_TO_UPPER": {
                            bl = Boolean.valueOf(string3);
                            break;
                        }
                        case "DATABASE_TO_LOWER": {
                            bl2 = Boolean.valueOf(string3);
                            break;
                        }
                        case "CASE_INSENSITIVE_IDENTIFIERS": {
                            bl3 = Boolean.valueOf(string3);
                        }
                    }
                }
            }
            object = Mode.getInstance(string2);
            if (object == null) {
                object = Mode.getRegular();
            }
            if (this.session instanceof SessionRemote && ((SessionRemote)this.session).getClientVersion() < 18) {
                bl3 = !bl;
            }
            this.settings = settings = new Settings((Mode)object, bl, bl2, bl3);
        }
        return settings;
    }

    public boolean isRegularMode() throws SQLException {
        this.settings = null;
        return this.getMode().getEnum() == Mode.ModeEnum.REGULAR;
    }

    public static final class Settings {
        public final Mode mode;
        public final boolean databaseToUpper;
        public final boolean databaseToLower;
        public final boolean caseInsensitiveIdentifiers;

        Settings(Mode mode, boolean bl, boolean bl2, boolean bl3) {
            this.mode = mode;
            this.databaseToUpper = bl;
            this.databaseToLower = bl2;
            this.caseInsensitiveIdentifiers = bl3;
        }
    }
}

