/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.compress.Compressor;
import org.h2.message.DbException;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.CursorPos;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.util.Utils;

public abstract class Page
implements Cloneable {
    public final MVMap<?, ?> map;
    private long pos;
    private int cachedCompare;
    private int memory;
    private int diskSpaceUsed;
    private Object[] keys;
    private volatile boolean removedInMemory;
    static final int PAGE_MEMORY_CHILD = 24;
    private static final int PAGE_MEMORY = 81;
    static final int PAGE_NODE_MEMORY = 121;
    static final int PAGE_LEAF_MEMORY = 113;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final int IN_MEMORY = Integer.MIN_VALUE;
    private static final PageReference[] SINGLE_EMPTY = new PageReference[]{PageReference.EMPTY};

    Page(MVMap<?, ?> mVMap) {
        this.map = mVMap;
    }

    Page(MVMap<?, ?> mVMap, Page page) {
        this(mVMap, page.keys);
        this.memory = page.memory;
    }

    Page(MVMap<?, ?> mVMap, Object[] objectArray) {
        this.map = mVMap;
        this.keys = objectArray;
    }

    static Page createEmptyLeaf(MVMap<?, ?> mVMap) {
        return Page.createLeaf(mVMap, EMPTY_OBJECT_ARRAY, EMPTY_OBJECT_ARRAY, 113);
    }

    static Page createEmptyNode(MVMap<?, ?> mVMap) {
        return Page.createNode(mVMap, EMPTY_OBJECT_ARRAY, SINGLE_EMPTY, 0L, 153);
    }

    public static Page createNode(MVMap<?, ?> mVMap, Object[] objectArray, PageReference[] pageReferenceArray, long l, int n) {
        assert (objectArray != null);
        NonLeaf nonLeaf = new NonLeaf(mVMap, objectArray, pageReferenceArray, l);
        super.initMemoryAccount(n);
        return nonLeaf;
    }

    public static Page createLeaf(MVMap<?, ?> mVMap, Object[] objectArray, Object[] objectArray2, int n) {
        assert (objectArray != null);
        Leaf leaf = new Leaf(mVMap, objectArray, objectArray2);
        super.initMemoryAccount(n);
        return leaf;
    }

    private void initMemoryAccount(int n) {
        if (this.map.store.getFileStore() == null) {
            this.memory = Integer.MIN_VALUE;
        } else if (n == 0) {
            this.recalculateMemory();
        } else {
            this.addMemory(n);
            assert (n == this.getMemory());
        }
    }

    static Object get(Page page, Object object) {
        while (true) {
            int n = page.binarySearch(object);
            if (page.isLeaf()) {
                return n >= 0 ? page.getValue(n) : null;
            }
            if (n++ < 0) {
                n = -n;
            }
            page = page.getChildPage(n);
        }
    }

    static Page read(ByteBuffer byteBuffer, long l, MVMap<?, ?> mVMap) {
        boolean bl = (DataUtils.getPageType(l) & 1) == 0;
        Page page = bl ? new Leaf(mVMap) : new NonLeaf(mVMap);
        page.pos = l;
        int n = DataUtils.getPageChunkId(l);
        super.read(byteBuffer, n);
        return page;
    }

    static void readChildrenPositions(ByteBuffer byteBuffer, long l, final MVStore.ChunkIdsCollector chunkIdsCollector, final ThreadPoolExecutor threadPoolExecutor, final AtomicInteger atomicInteger) {
        int n = DataUtils.readVarInt(byteBuffer);
        byte by = byteBuffer.get();
        if ((by & 1) != 1) {
            throw DataUtils.newIllegalStateException(6, "Position {0} expected to be a non-leaf", l);
        }
        ArrayList arrayList = new ArrayList(n + 1);
        block3: for (int i = 0; i <= n; ++i) {
            int n2;
            final long l2 = byteBuffer.getLong();
            do {
                if ((n2 = atomicInteger.get()) < threadPoolExecutor.getMaximumPoolSize()) continue;
                chunkIdsCollector.visit(l2, threadPoolExecutor, atomicInteger);
                continue block3;
            } while (!atomicInteger.compareAndSet(n2, n2 + 1));
            Future<?> future2 = threadPoolExecutor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        chunkIdsCollector.visit(l2, threadPoolExecutor, atomicInteger);
                    }
                    finally {
                        atomicInteger.decrementAndGet();
                    }
                }
            });
            arrayList.add(future2);
        }
        for (Future future3 : arrayList) {
            try {
                future3.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw DbException.convert(executionException);
            }
        }
    }

    public final int getMapId() {
        return this.map.getId();
    }

    abstract Page copy(MVMap<?, ?> var1);

    public Object getKey(int n) {
        return this.keys[n];
    }

    public abstract Page getChildPage(int var1);

    public abstract Page getChildPageIfLoaded(int var1);

    public abstract long getChildPagePos(int var1);

    public abstract Object getValue(int var1);

    public final int getKeyCount() {
        return this.keys.length;
    }

    public final boolean isLeaf() {
        return this.getNodeType() == 0;
    }

    public abstract int getNodeType();

    public final long getPos() {
        return this.pos;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.dump(stringBuilder);
        return stringBuilder.toString();
    }

    protected void dump(StringBuilder stringBuilder) {
        stringBuilder.append("id: ").append(System.identityHashCode(this)).append('\n');
        stringBuilder.append("pos: ").append(Long.toHexString(this.pos)).append('\n');
        if (this.isSaved()) {
            int n = DataUtils.getPageChunkId(this.pos);
            stringBuilder.append("chunk: ").append(Long.toHexString(n)).append('\n');
        }
    }

    public final Page copy() {
        return this.copy(false);
    }

    public final Page copy(boolean bl) {
        Page page = this.clone();
        page.pos = 0L;
        if (bl) {
            this.removePage();
            if (this.isPersistent()) {
                this.map.store.registerUnsavedPage(page.getMemory());
            }
        }
        return page;
    }

    protected final Page clone() {
        Page page;
        try {
            page = (Page)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        return page;
    }

    int binarySearch(Object object) {
        int n = 0;
        int n2 = this.getKeyCount() - 1;
        int n3 = this.cachedCompare - 1;
        if (n3 < 0 || n3 > n2) {
            n3 = n2 >>> 1;
        }
        Object[] objectArray = this.keys;
        while (n <= n2) {
            int n4 = this.map.compare(object, objectArray[n3]);
            if (n4 > 0) {
                n = n3 + 1;
            } else if (n4 < 0) {
                n2 = n3 - 1;
            } else {
                this.cachedCompare = n3 + 1;
                return n3;
            }
            n3 = n + n2 >>> 1;
        }
        this.cachedCompare = n;
        return -(n + 1);
    }

    abstract Page split(int var1);

    final Object[] splitKeys(int n, int n2) {
        assert (n + n2 <= this.getKeyCount());
        Object[] objectArray = this.createKeyStorage(n);
        Object[] objectArray2 = this.createKeyStorage(n2);
        System.arraycopy(this.keys, 0, objectArray, 0, n);
        System.arraycopy(this.keys, this.getKeyCount() - n2, objectArray2, 0, n2);
        this.keys = objectArray;
        return objectArray2;
    }

    abstract void expand(int var1, Object[] var2, Object[] var3);

    final void expandKeys(int n, Object[] objectArray) {
        int n2 = this.getKeyCount();
        Object[] objectArray2 = this.createKeyStorage(n2 + n);
        System.arraycopy(this.keys, 0, objectArray2, 0, n2);
        System.arraycopy(objectArray, 0, objectArray2, n2, n);
        this.keys = objectArray2;
    }

    public abstract long getTotalCount();

    abstract long getCounts(int var1);

    public abstract void setChild(int var1, Page var2);

    public final void setKey(int n, Object object) {
        this.keys = (Object[])this.keys.clone();
        if (this.isPersistent()) {
            Object object2 = this.keys[n];
            DataType dataType = this.map.getKeyType();
            int n2 = dataType.getMemory(object);
            if (object2 != null) {
                n2 -= dataType.getMemory(object2);
            }
            this.addMemory(n2);
        }
        this.keys[n] = object;
    }

    public abstract Object setValue(int var1, Object var2);

    public abstract void insertLeaf(int var1, Object var2, Object var3);

    public abstract void insertNode(int var1, Object var2, Page var3);

    final void insertKey(int n, Object object) {
        int n2 = this.getKeyCount();
        assert (n <= n2) : n + " > " + n2;
        Object[] objectArray = this.createKeyStorage(n2 + 1);
        DataUtils.copyWithGap(this.keys, objectArray, n2, n);
        this.keys = objectArray;
        this.keys[n] = object;
        if (this.isPersistent()) {
            this.addMemory(8 + this.map.getKeyType().getMemory(object));
        }
    }

    public void remove(int n) {
        Object[] objectArray;
        int n2 = this.getKeyCount();
        DataType dataType = this.map.getKeyType();
        if (n == n2) {
            --n;
        }
        if (this.isPersistent()) {
            objectArray = this.getKey(n);
            this.addMemory(-8 - dataType.getMemory(objectArray));
        }
        objectArray = this.createKeyStorage(n2 - 1);
        DataUtils.copyExcept(this.keys, objectArray, n2, n);
        this.keys = objectArray;
    }

    private void read(ByteBuffer byteBuffer, int n) {
        boolean bl;
        int n2 = byteBuffer.remaining() + 4;
        int n3 = DataUtils.readVarInt(byteBuffer);
        this.keys = this.createKeyStorage(n3);
        byte by = byteBuffer.get();
        if (this.isLeaf() != ((by & 1) == 0)) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected node type {1}, got {2}", n, this.isLeaf() ? "0" : "1", by);
        }
        if (!this.isLeaf()) {
            this.readPayLoad(byteBuffer);
        }
        boolean bl2 = bl = (by & 2) != 0;
        if (bl) {
            Compressor compressor = (by & 6) == 6 ? this.map.getStore().getCompressorHigh() : this.map.getStore().getCompressorFast();
            int n4 = DataUtils.readVarInt(byteBuffer);
            int n5 = byteBuffer.remaining();
            byte[] byArray = Utils.newBytes(n5);
            byteBuffer.get(byArray);
            int n6 = n5 + n4;
            byteBuffer = ByteBuffer.allocate(n6);
            compressor.expand(byArray, 0, n5, byteBuffer.array(), byteBuffer.arrayOffset(), n6);
        }
        this.map.getKeyType().read(byteBuffer, this.keys, n3, true);
        if (this.isLeaf()) {
            this.readPayLoad(byteBuffer);
        }
        this.diskSpaceUsed = n2;
        this.recalculateMemory();
    }

    protected abstract void readPayLoad(ByteBuffer var1);

    public final boolean isSaved() {
        return DataUtils.isPageSaved(this.pos);
    }

    protected final int write(Chunk chunk, WriteBuffer writeBuffer) {
        int n;
        int n2;
        int n3 = writeBuffer.position();
        int n4 = this.getKeyCount();
        int n5 = this.isLeaf() ? 0 : 1;
        writeBuffer.putInt(0).putShort((short)0).putVarInt(this.map.getId()).putVarInt(n4);
        int n6 = writeBuffer.position();
        writeBuffer.put((byte)n5);
        this.writeChildren(writeBuffer, true);
        int n7 = writeBuffer.position();
        this.map.getKeyType().write(writeBuffer, this.keys, n4, true);
        this.writeValues(writeBuffer);
        MVStore mVStore = this.map.getStore();
        int n8 = writeBuffer.position() - n7;
        if (n8 > 16 && (n2 = mVStore.getCompressionLevel()) > 0) {
            Compressor compressor;
            if (n2 == 1) {
                compressor = this.map.getStore().getCompressorFast();
                n = 2;
            } else {
                compressor = this.map.getStore().getCompressorHigh();
                n = 6;
            }
            byte[] byArray = new byte[n8];
            writeBuffer.position(n7).get(byArray);
            byte[] byArray2 = new byte[n8 * 2];
            int n9 = compressor.compress(byArray, n8, byArray2, 0);
            int n10 = DataUtils.getVarIntLen(n9 - n8);
            if (n9 + n10 < n8) {
                writeBuffer.position(n6).put((byte)(n5 + n));
                writeBuffer.position(n7).putVarInt(n8 - n9).put(byArray2, 0, n9);
            }
        }
        n2 = writeBuffer.position() - n3;
        int n11 = chunk.id;
        n = DataUtils.getCheckValue(n11) ^ DataUtils.getCheckValue(n3) ^ DataUtils.getCheckValue(n2);
        writeBuffer.putInt(n3, n2).putShort(n3 + 4, (short)n);
        if (this.isSaved()) {
            throw DataUtils.newIllegalStateException(3, "Page already stored", new Object[0]);
        }
        this.pos = DataUtils.getPagePos(n11, n3, n2, n5);
        mVStore.cachePage(this);
        if (n5 == 1) {
            mVStore.cachePage(this);
        }
        int n12 = DataUtils.getPageMaxLength(this.pos);
        chunk.maxLen += (long)n12;
        chunk.maxLenLive += (long)n12;
        ++chunk.pageCount;
        ++chunk.pageCountLive;
        if (this.removedInMemory) {
            this.map.removePage(this.pos, this.memory);
        }
        this.diskSpaceUsed = n12 != 0x200000 ? n12 : n2;
        return n6 + 1;
    }

    protected abstract void writeValues(WriteBuffer var1);

    protected abstract void writeChildren(WriteBuffer var1, boolean var2);

    abstract void writeUnsavedRecursive(Chunk var1, WriteBuffer var2);

    abstract void writeEnd();

    public abstract int getRawChildPageCount();

    public final boolean equals(Object object) {
        return object == this || object instanceof Page && this.isSaved() && ((Page)object).pos == this.pos;
    }

    public final int hashCode() {
        return this.isSaved() ? (int)(this.pos | this.pos >>> 32) : super.hashCode();
    }

    protected final boolean isPersistent() {
        return this.memory != Integer.MIN_VALUE;
    }

    public final int getMemory() {
        if (this.isPersistent()) {
            return this.memory;
        }
        return 0;
    }

    public long getDiskSpaceUsed() {
        long l = 0L;
        if (this.isPersistent()) {
            l += (long)this.diskSpaceUsed;
        }
        if (!this.isLeaf()) {
            for (int i = 0; i < this.getRawChildPageCount(); ++i) {
                long l2 = this.getChildPagePos(i);
                if (l2 == 0L) continue;
                l += this.getChildPage(i).getDiskSpaceUsed();
            }
        }
        return l;
    }

    final void addMemory(int n) {
        this.memory += n;
    }

    final void recalculateMemory() {
        assert (this.isPersistent());
        this.memory = this.calculateMemory();
    }

    protected int calculateMemory() {
        int n = this.getKeyCount();
        int n2 = n * 8;
        DataType dataType = this.map.getKeyType();
        for (int i = 0; i < n; ++i) {
            n2 += dataType.getMemory(this.keys[i]);
        }
        return n2;
    }

    public boolean isComplete() {
        return true;
    }

    public void setComplete() {
    }

    public final void removePage() {
        if (this.isPersistent()) {
            long l = this.pos;
            if (l == 0L) {
                this.removedInMemory = true;
            }
            this.map.removePage(l, this.memory);
        }
    }

    public abstract CursorPos getAppendCursorPos(CursorPos var1);

    public abstract void removeAllRecursive();

    private Object[] createKeyStorage(int n) {
        return new Object[n];
    }

    final Object[] createValueStorage(int n) {
        return new Object[n];
    }

    private static class Leaf
    extends Page {
        private Object[] values;

        Leaf(MVMap<?, ?> mVMap) {
            super(mVMap);
        }

        private Leaf(MVMap<?, ?> mVMap, Leaf leaf) {
            super(mVMap, leaf);
            this.values = leaf.values;
        }

        Leaf(MVMap<?, ?> mVMap, Object[] objectArray, Object[] objectArray2) {
            super(mVMap, objectArray);
            this.values = objectArray2;
        }

        @Override
        public int getNodeType() {
            return 0;
        }

        @Override
        public Page copy(MVMap<?, ?> mVMap) {
            return new Leaf(mVMap, this);
        }

        @Override
        public Page getChildPage(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Page getChildPageIfLoaded(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getChildPagePos(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue(int n) {
            return this.values[n];
        }

        @Override
        public Page split(int n) {
            Object object;
            assert (!this.isSaved());
            int n2 = this.getKeyCount() - n;
            Object[] objectArray = this.splitKeys(n, n2);
            Object[] objectArray2 = this.createValueStorage(n2);
            if (this.values != null) {
                object = this.createValueStorage(n);
                System.arraycopy(this.values, 0, object, 0, n);
                System.arraycopy(this.values, n, objectArray2, 0, n2);
                this.values = object;
            }
            object = Leaf.createLeaf(this.map, objectArray, objectArray2, 0);
            if (this.isPersistent()) {
                this.recalculateMemory();
            }
            return object;
        }

        @Override
        public void expand(int n, Object[] objectArray, Object[] objectArray2) {
            int n2 = this.getKeyCount();
            this.expandKeys(n, objectArray);
            if (this.values != null) {
                Object[] objectArray3 = this.createValueStorage(n2 + n);
                System.arraycopy(this.values, 0, objectArray3, 0, n2);
                System.arraycopy(objectArray2, 0, objectArray3, n2, n);
                this.values = objectArray3;
            }
            if (this.isPersistent()) {
                this.recalculateMemory();
            }
        }

        @Override
        public long getTotalCount() {
            return this.getKeyCount();
        }

        @Override
        long getCounts(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setChild(int n, Page page) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object setValue(int n, Object object) {
            DataType dataType = this.map.getValueType();
            this.values = (Object[])this.values.clone();
            Object object2 = this.setValueInternal(n, object);
            if (this.isPersistent()) {
                this.addMemory(dataType.getMemory(object) - dataType.getMemory(object2));
            }
            return object2;
        }

        private Object setValueInternal(int n, Object object) {
            Object object2 = this.values[n];
            this.values[n] = object;
            return object2;
        }

        @Override
        public void insertLeaf(int n, Object object, Object object2) {
            int n2 = this.getKeyCount();
            this.insertKey(n, object);
            if (this.values != null) {
                Object[] objectArray = this.createValueStorage(n2 + 1);
                DataUtils.copyWithGap(this.values, objectArray, n2, n);
                this.values = objectArray;
                this.setValueInternal(n, object2);
                if (this.isPersistent()) {
                    this.addMemory(8 + this.map.getValueType().getMemory(object2));
                }
            }
        }

        @Override
        public void insertNode(int n, Object object, Page page) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int n) {
            int n2 = this.getKeyCount();
            super.remove(n);
            if (this.values != null) {
                Object[] objectArray;
                if (this.isPersistent()) {
                    objectArray = this.getValue(n);
                    this.addMemory(-8 - this.map.getValueType().getMemory(objectArray));
                }
                objectArray = this.createValueStorage(n2 - 1);
                DataUtils.copyExcept(this.values, objectArray, n2, n);
                this.values = objectArray;
            }
        }

        @Override
        public void removeAllRecursive() {
            this.removePage();
        }

        @Override
        public CursorPos getAppendCursorPos(CursorPos cursorPos) {
            int n = this.getKeyCount();
            return new CursorPos(this, -n - 1, cursorPos);
        }

        @Override
        protected void readPayLoad(ByteBuffer byteBuffer) {
            int n = this.getKeyCount();
            this.values = this.createValueStorage(n);
            this.map.getValueType().read(byteBuffer, this.values, this.getKeyCount(), false);
        }

        @Override
        protected void writeValues(WriteBuffer writeBuffer) {
            this.map.getValueType().write(writeBuffer, this.values, this.getKeyCount(), false);
        }

        @Override
        protected void writeChildren(WriteBuffer writeBuffer, boolean bl) {
        }

        @Override
        void writeUnsavedRecursive(Chunk chunk, WriteBuffer writeBuffer) {
            if (!this.isSaved()) {
                this.write(chunk, writeBuffer);
            }
        }

        @Override
        void writeEnd() {
        }

        @Override
        public int getRawChildPageCount() {
            return 0;
        }

        @Override
        protected int calculateMemory() {
            int n = this.getKeyCount();
            int n2 = super.calculateMemory() + 113 + n * 8;
            DataType dataType = this.map.getValueType();
            for (int i = 0; i < n; ++i) {
                n2 += dataType.getMemory(this.values[i]);
            }
            return n2;
        }

        @Override
        public void dump(StringBuilder stringBuilder) {
            super.dump(stringBuilder);
            int n = this.getKeyCount();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.getKey(i));
                if (this.values == null) continue;
                stringBuilder.append(':');
                stringBuilder.append(this.getValue(i));
            }
        }
    }

    private static class IncompleteNonLeaf
    extends NonLeaf {
        private boolean complete;

        IncompleteNonLeaf(MVMap<?, ?> mVMap, NonLeaf nonLeaf) {
            super(mVMap, nonLeaf, IncompleteNonLeaf.constructEmptyPageRefs(nonLeaf.getRawChildPageCount()), nonLeaf.getTotalCount());
        }

        private static PageReference[] constructEmptyPageRefs(int n) {
            Object[] objectArray = new PageReference[n];
            Arrays.fill(objectArray, PageReference.EMPTY);
            return objectArray;
        }

        @Override
        void writeUnsavedRecursive(Chunk chunk, WriteBuffer writeBuffer) {
            if (this.complete) {
                super.writeUnsavedRecursive(chunk, writeBuffer);
            } else if (!this.isSaved()) {
                this.writeChildrenRecursive(chunk, writeBuffer);
            }
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public void setComplete() {
            this.recalculateTotalCount();
            this.complete = true;
        }

        @Override
        public void dump(StringBuilder stringBuilder) {
            super.dump(stringBuilder);
            stringBuilder.append(", complete:").append(this.complete);
        }
    }

    private static class NonLeaf
    extends Page {
        private PageReference[] children;
        private long totalCount;

        NonLeaf(MVMap<?, ?> mVMap) {
            super(mVMap);
        }

        NonLeaf(MVMap<?, ?> mVMap, NonLeaf nonLeaf, PageReference[] pageReferenceArray, long l) {
            super(mVMap, nonLeaf);
            this.children = pageReferenceArray;
            this.totalCount = l;
        }

        NonLeaf(MVMap<?, ?> mVMap, Object[] objectArray, PageReference[] pageReferenceArray, long l) {
            super(mVMap, objectArray);
            this.children = pageReferenceArray;
            this.totalCount = l;
        }

        @Override
        public int getNodeType() {
            return 1;
        }

        @Override
        public Page copy(MVMap<?, ?> mVMap) {
            return new IncompleteNonLeaf(mVMap, this);
        }

        @Override
        public Page getChildPage(int n) {
            PageReference pageReference = this.children[n];
            Page page = pageReference.getPage();
            if (page == null) {
                page = this.map.readPage(pageReference.getPos());
                assert (pageReference.getPos() == page.getPos());
                assert (pageReference.count == page.getTotalCount());
            }
            return page;
        }

        @Override
        public Page getChildPageIfLoaded(int n) {
            return this.children[n].getPage();
        }

        @Override
        public long getChildPagePos(int n) {
            return this.children[n].getPos();
        }

        @Override
        public Object getValue(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Page split(int n) {
            assert (!this.isSaved());
            int n2 = this.getKeyCount() - n;
            Object[] objectArray = this.splitKeys(n, n2 - 1);
            PageReference[] pageReferenceArray = new PageReference[n + 1];
            PageReference[] pageReferenceArray2 = new PageReference[n2];
            System.arraycopy(this.children, 0, pageReferenceArray, 0, n + 1);
            System.arraycopy(this.children, n + 1, pageReferenceArray2, 0, n2);
            this.children = pageReferenceArray;
            long l = 0L;
            for (PageReference pageReference : pageReferenceArray) {
                l += pageReference.count;
            }
            this.totalCount = l;
            l = 0L;
            for (PageReference pageReference : pageReferenceArray2) {
                l += pageReference.count;
            }
            Page page = NonLeaf.createNode(this.map, objectArray, pageReferenceArray2, l, 0);
            if (this.isPersistent()) {
                this.recalculateMemory();
            }
            return page;
        }

        @Override
        public void expand(int n, Object[] objectArray, Object[] objectArray2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTotalCount() {
            assert (!this.isComplete() || this.totalCount == this.calculateTotalCount()) : "Total count: " + this.totalCount + " != " + this.calculateTotalCount();
            return this.totalCount;
        }

        private long calculateTotalCount() {
            long l = 0L;
            int n = this.getKeyCount();
            for (int i = 0; i <= n; ++i) {
                l += this.children[i].count;
            }
            return l;
        }

        protected void recalculateTotalCount() {
            this.totalCount = this.calculateTotalCount();
        }

        @Override
        long getCounts(int n) {
            return this.children[n].count;
        }

        @Override
        public void setChild(int n, Page page) {
            assert (page != null);
            PageReference pageReference = this.children[n];
            if (page != pageReference.getPage() || page.getPos() != pageReference.getPos()) {
                this.totalCount += page.getTotalCount() - pageReference.count;
                this.children = (PageReference[])this.children.clone();
                this.children[n] = new PageReference(page);
            }
        }

        @Override
        public Object setValue(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertLeaf(int n, Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertNode(int n, Object object, Page page) {
            int n2 = this.getRawChildPageCount();
            this.insertKey(n, object);
            PageReference[] pageReferenceArray = new PageReference[n2 + 1];
            DataUtils.copyWithGap(this.children, pageReferenceArray, n2, n);
            this.children = pageReferenceArray;
            this.children[n] = new PageReference(page);
            this.totalCount += page.getTotalCount();
            if (this.isPersistent()) {
                this.addMemory(32);
            }
        }

        @Override
        public void remove(int n) {
            int n2 = this.getRawChildPageCount();
            super.remove(n);
            if (this.isPersistent()) {
                this.addMemory(-32);
            }
            this.totalCount -= this.children[n].count;
            PageReference[] pageReferenceArray = new PageReference[n2 - 1];
            DataUtils.copyExcept(this.children, pageReferenceArray, n2, n);
            this.children = pageReferenceArray;
        }

        @Override
        public void removeAllRecursive() {
            if (this.isPersistent()) {
                int n = this.map.getChildPageCount(this);
                for (int i = 0; i < n; ++i) {
                    PageReference pageReference = this.children[i];
                    Page page = pageReference.getPage();
                    if (page != null) {
                        page.removeAllRecursive();
                        continue;
                    }
                    long l = pageReference.getPos();
                    int n2 = DataUtils.getPageType(l);
                    if (n2 == 0) {
                        int n3 = DataUtils.getPageMaxLength(l);
                        this.map.removePage(l, n3);
                        continue;
                    }
                    this.map.readPage(l).removeAllRecursive();
                }
            }
            this.removePage();
        }

        @Override
        public CursorPos getAppendCursorPos(CursorPos cursorPos) {
            int n = this.getKeyCount();
            Page page = this.getChildPage(n);
            return page.getAppendCursorPos(new CursorPos(this, n, cursorPos));
        }

        @Override
        protected void readPayLoad(ByteBuffer byteBuffer) {
            int n = this.getKeyCount();
            this.children = new PageReference[n + 1];
            long[] lArray = new long[n + 1];
            for (int i = 0; i <= n; ++i) {
                lArray[i] = byteBuffer.getLong();
            }
            long l = 0L;
            for (int i = 0; i <= n; ++i) {
                long l2 = DataUtils.readVarLong(byteBuffer);
                long l3 = lArray[i];
                assert (l3 != 0L ? l2 >= 0L : l2 == 0L);
                l += l2;
                this.children[i] = l3 == 0L ? PageReference.EMPTY : new PageReference(l3, l2);
            }
            this.totalCount = l;
        }

        @Override
        protected void writeValues(WriteBuffer writeBuffer) {
        }

        @Override
        protected void writeChildren(WriteBuffer writeBuffer, boolean bl) {
            int n;
            int n2 = this.getKeyCount();
            for (n = 0; n <= n2; ++n) {
                writeBuffer.putLong(this.children[n].getPos());
            }
            if (bl) {
                for (n = 0; n <= n2; ++n) {
                    writeBuffer.putVarLong(this.children[n].count);
                }
            }
        }

        @Override
        void writeUnsavedRecursive(Chunk chunk, WriteBuffer writeBuffer) {
            if (!this.isSaved()) {
                int n = this.write(chunk, writeBuffer);
                this.writeChildrenRecursive(chunk, writeBuffer);
                int n2 = writeBuffer.position();
                writeBuffer.position(n);
                this.writeChildren(writeBuffer, false);
                writeBuffer.position(n2);
            }
        }

        void writeChildrenRecursive(Chunk chunk, WriteBuffer writeBuffer) {
            int n = this.getRawChildPageCount();
            for (int i = 0; i < n; ++i) {
                PageReference pageReference = this.children[i];
                Page page = pageReference.getPage();
                if (page == null) continue;
                page.writeUnsavedRecursive(chunk, writeBuffer);
                pageReference.resetPos();
            }
        }

        @Override
        void writeEnd() {
            int n = this.getRawChildPageCount();
            for (int i = 0; i < n; ++i) {
                this.children[i].clearPageReference();
            }
        }

        @Override
        public int getRawChildPageCount() {
            return this.getKeyCount() + 1;
        }

        @Override
        protected int calculateMemory() {
            return super.calculateMemory() + 121 + this.getRawChildPageCount() * 32;
        }

        @Override
        public void dump(StringBuilder stringBuilder) {
            super.dump(stringBuilder);
            int n = this.getKeyCount();
            for (int i = 0; i <= n; ++i) {
                if (i > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append("[").append(Long.toHexString(this.children[i].getPos())).append("]");
                if (i >= n) continue;
                stringBuilder.append(" ").append(this.getKey(i));
            }
        }
    }

    public static final class PageReference {
        public static final PageReference EMPTY = new PageReference(null, 0L, 0L);
        private long pos;
        private Page page;
        final long count;

        public PageReference(Page page) {
            this(page, page.getPos(), page.getTotalCount());
        }

        PageReference(long l, long l2) {
            this(null, l, l2);
            assert (DataUtils.isPageSaved(l));
        }

        private PageReference(Page page, long l, long l2) {
            this.page = page;
            this.pos = l;
            this.count = l2;
        }

        public Page getPage() {
            return this.page;
        }

        void clearPageReference() {
            if (this.page != null) {
                this.page.writeEnd();
                assert (this.page.isSaved() || !this.page.isComplete());
                if (this.page.isSaved()) {
                    assert (this.pos == this.page.getPos());
                    assert (this.count == this.page.getTotalCount()) : this.count + " != " + this.page.getTotalCount();
                    this.page = null;
                }
            }
        }

        long getPos() {
            return this.pos;
        }

        void resetPos() {
            Page page = this.page;
            if (page != null && page.isSaved()) {
                this.pos = page.getPos();
                assert (this.count == page.getTotalCount());
            }
        }

        public String toString() {
            return "Cnt:" + this.count + ", pos:" + DataUtils.getPageChunkId(this.pos) + "-" + DataUtils.getPageOffset(this.pos) + ":" + DataUtils.getPageMaxLength(this.pos) + (this.page == null ? Boolean.valueOf(DataUtils.getPageType(this.pos) == 0) : (this.page.isLeaf() ? " leaf" : " node")) + ", " + this.page;
        }
    }
}

