/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public class RowImpl
implements Row {
    private long key;
    private final Value[] data;
    private int memory;
    private boolean deleted;

    public RowImpl(Value[] valueArray, int n) {
        this.data = valueArray;
        this.memory = n;
    }

    @Override
    public void setKey(SearchRow searchRow) {
        this.setKey(searchRow.getKey());
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public void setKey(long l) {
        this.key = l;
    }

    @Override
    public Value getValue(int n) {
        return n == -1 ? ValueLong.get(this.key) : this.data[n];
    }

    @Override
    public int getByteCount(Data data) {
        int n = 0;
        for (Value value2 : this.data) {
            n += data.getValueLen(value2);
        }
        return n;
    }

    @Override
    public void setValue(int n, Value value2) {
        if (n == -1) {
            this.key = value2.getLong();
        } else {
            this.data[n] = value2;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data == null;
    }

    @Override
    public int getColumnCount() {
        return this.data.length;
    }

    @Override
    public int getMemory() {
        if (this.memory != -1) {
            return this.memory;
        }
        int n = 40;
        if (this.data != null) {
            int n2 = this.data.length;
            n += 24 + n2 * 8;
            for (Value value2 : this.data) {
                if (value2 == null) continue;
                n += value2.getMemory();
            }
        }
        this.memory = n;
        return n;
    }

    public String toString() {
        return RowImpl.toString(this.key, this.deleted, this.data);
    }

    static String toString(long l, boolean bl, Value[] valueArray) {
        StringBuilder stringBuilder = new StringBuilder("( /* key:").append(l);
        if (bl) {
            stringBuilder.append(" deleted");
        }
        stringBuilder.append(" */ ");
        if (valueArray != null) {
            int n = valueArray.length;
            for (int i = 0; i < n; ++i) {
                Value value2;
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((value2 = valueArray[i]) == null ? "null" : value2.getTraceSQL());
            }
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public Value[] getValueList() {
        return this.data;
    }

    @Override
    public boolean hasSharedData(Row row) {
        if (row.getClass() == RowImpl.class) {
            RowImpl rowImpl = (RowImpl)row;
            return this.data == rowImpl.data;
        }
        return false;
    }
}

