/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebApp;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebSession;

public class WebServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient WebServer server;

    public void init() {
        Object object;
        ServletConfig servletConfig = this.getServletConfig();
        Enumeration enumeration = servletConfig.getInitParameterNames();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement().toString();
            String string2 = servletConfig.getInitParameter((String)object);
            if (!object.startsWith("-")) {
                object = "-" + (String)object;
            }
            arrayList.add(object);
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        object = arrayList.toArray(new String[0]);
        this.server = new WebServer();
        this.server.setAllowChunked(false);
        this.server.init((String)object);
    }

    public void destroy() {
        this.server.stop();
    }

    private boolean allow(HttpServletRequest httpServletRequest) {
        if (this.server.getAllowOthers()) {
            return true;
        }
        String string2 = httpServletRequest.getRemoteAddr();
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            return inetAddress.isLoopbackAddress();
        }
        catch (NoClassDefFoundError | UnknownHostException throwable) {
            return false;
        }
    }

    private String getAllowedFile(HttpServletRequest httpServletRequest, String string2) {
        if (!this.allow(httpServletRequest)) {
            return "notAllowed.jsp";
        }
        if (string2.length() == 0) {
            return "index.do";
        }
        return string2;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string2;
        String string3;
        Object object;
        httpServletRequest.setCharacterEncoding("utf-8");
        String string4 = httpServletRequest.getPathInfo();
        if (string4 == null) {
            httpServletResponse.sendRedirect(httpServletRequest.getRequestURI() + "/");
            return;
        }
        if (string4.startsWith("/")) {
            string4 = string4.substring(1);
        }
        string4 = this.getAllowedFile(httpServletRequest, string4);
        Properties properties = new Properties();
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement().toString();
            string3 = httpServletRequest.getAttribute((String)object).toString();
            properties.put(object, string3);
        }
        enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement().toString();
            string3 = httpServletRequest.getParameter((String)object);
            properties.put(object, string3);
        }
        object = null;
        string3 = properties.getProperty("jsessionid");
        if (string3 != null) {
            object = this.server.getSession(string3);
        }
        WebApp webApp = new WebApp(this.server);
        webApp.setSession((WebSession)object, properties);
        String string5 = httpServletRequest.getHeader("if-modified-since");
        String string6 = httpServletRequest.getRemoteAddr();
        string4 = webApp.processRequest(string4, string6);
        object = webApp.getSession();
        String string7 = webApp.getMimeType();
        boolean bl = webApp.getCache();
        if (bl && this.server.getStartDateTime().equals(string5)) {
            httpServletResponse.setStatus(304);
            return;
        }
        byte[] byArray = this.server.getFile(string4);
        if (byArray == null) {
            httpServletResponse.sendError(404);
            byArray = ("File not found: " + string4).getBytes(StandardCharsets.UTF_8);
        } else {
            if (object != null && string4.endsWith(".jsp")) {
                string2 = new String(byArray, StandardCharsets.UTF_8);
                string2 = PageParser.parse(string2, ((WebSession)object).map);
                byArray = string2.getBytes(StandardCharsets.UTF_8);
            }
            httpServletResponse.setContentType(string7);
            if (!bl) {
                httpServletResponse.setHeader("Cache-Control", "no-cache");
            } else {
                httpServletResponse.setHeader("Cache-Control", "max-age=10");
                httpServletResponse.setHeader("Last-Modified", this.server.getStartDateTime());
            }
        }
        if (byArray != null) {
            string2 = httpServletResponse.getOutputStream();
            string2.write(byArray);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }
}

