/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.util.MathUtils;

public abstract class FilePath {
    private static FilePath defaultProvider;
    private static ConcurrentHashMap<String, FilePath> providers;
    private static String tempRandom;
    private static long tempSequence;
    protected String name;

    public static FilePath get(String string2) {
        string2 = string2.replace('\\', '/');
        int n = string2.indexOf(58);
        FilePath.registerDefaultProviders();
        if (n < 2) {
            return defaultProvider.getPath(string2);
        }
        String string3 = string2.substring(0, n);
        FilePath filePath = providers.get(string3);
        if (filePath == null) {
            filePath = defaultProvider;
        }
        return filePath.getPath(string2);
    }

    private static void registerDefaultProviders() {
        if (providers == null || defaultProvider == null) {
            ConcurrentHashMap<String, FilePath> concurrentHashMap = new ConcurrentHashMap<String, FilePath>();
            for (String string2 : new String[]{"org.h2.store.fs.FilePathDisk", "org.h2.store.fs.FilePathMem", "org.h2.store.fs.FilePathMemLZF", "org.h2.store.fs.FilePathNioMem", "org.h2.store.fs.FilePathNioMemLZF", "org.h2.store.fs.FilePathSplit", "org.h2.store.fs.FilePathNio", "org.h2.store.fs.FilePathNioMapped", "org.h2.store.fs.FilePathAsync", "org.h2.store.fs.FilePathZip", "org.h2.store.fs.FilePathRetryOnInterrupt"}) {
                try {
                    FilePath filePath = (FilePath)Class.forName(string2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    concurrentHashMap.put(filePath.getScheme(), filePath);
                    if (defaultProvider != null) continue;
                    defaultProvider = filePath;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            providers = concurrentHashMap;
        }
    }

    public static void register(FilePath filePath) {
        FilePath.registerDefaultProviders();
        providers.put(filePath.getScheme(), filePath);
    }

    public static void unregister(FilePath filePath) {
        FilePath.registerDefaultProviders();
        providers.remove(filePath.getScheme());
    }

    public abstract long size();

    public abstract void moveTo(FilePath var1, boolean var2);

    public abstract boolean createFile();

    public abstract boolean exists();

    public abstract void delete();

    public abstract List<FilePath> newDirectoryStream();

    public abstract FilePath toRealPath();

    public abstract FilePath getParent();

    public abstract boolean isDirectory();

    public abstract boolean isAbsolute();

    public abstract long lastModified();

    public abstract boolean canWrite();

    public abstract void createDirectory();

    public String getName() {
        int n = Math.max(this.name.indexOf(58), this.name.lastIndexOf(47));
        return n < 0 ? this.name : this.name.substring(n + 1);
    }

    public abstract OutputStream newOutputStream(boolean var1) throws IOException;

    public abstract FileChannel open(String var1) throws IOException;

    public abstract InputStream newInputStream() throws IOException;

    public abstract boolean setReadOnly();

    public FilePath createTempFile(String string2, boolean bl) throws IOException {
        FilePath filePath;
        while ((filePath = this.getPath(this.name + FilePath.getNextTempFileNamePart(false) + string2)).exists() || !filePath.createFile()) {
            FilePath.getNextTempFileNamePart(true);
        }
        filePath.open("rw").close();
        return filePath;
    }

    protected static synchronized String getNextTempFileNamePart(boolean bl) {
        if (bl || tempRandom == null) {
            tempRandom = MathUtils.randomInt(Integer.MAX_VALUE) + ".";
        }
        return tempRandom + tempSequence++;
    }

    public String toString() {
        return this.name;
    }

    public abstract String getScheme();

    public abstract FilePath getPath(String var1);

    public FilePath unwrap() {
        return this;
    }
}

