/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.Objects;
import org.h2.command.Parser;
import org.h2.command.ddl.SequenceOptions;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Domain;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.SequenceValue;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.table.SingleColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueUuid;

public class Column {
    public static final String ROWID = "_ROWID_";
    public static final int NOT_NULLABLE = 0;
    public static final int NULLABLE = 1;
    public static final int NULLABLE_UNKNOWN = 2;
    private final TypeInfo type;
    private Table table;
    private String name;
    private int columnId;
    private boolean nullable = true;
    private Expression defaultExpression;
    private Expression onUpdateExpression;
    private Expression checkConstraint;
    private String checkConstraintSQL;
    private String originalSQL;
    private SequenceOptions autoIncrementOptions;
    private boolean convertNullToDefault;
    private Sequence sequence;
    private boolean isComputed;
    private TableFilter computeTableFilter;
    private int selectivity;
    private SingleColumnResolver resolver;
    private String comment;
    private boolean primaryKey;
    private boolean visible = true;
    private boolean rowId;
    private Domain domain;

    public static StringBuilder writeColumns(StringBuilder stringBuilder, Column[] columnArray, boolean bl) {
        int n = columnArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            columnArray[i].getSQL(stringBuilder, bl);
        }
        return stringBuilder;
    }

    public static StringBuilder writeColumns(StringBuilder stringBuilder, Column[] columnArray, String string2, String string3, boolean bl) {
        int n = columnArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(string2);
            }
            columnArray[i].getSQL(stringBuilder, bl).append(string3);
        }
        return stringBuilder;
    }

    public Column(String string2, int n) {
        this(string2, TypeInfo.getTypeInfo(n));
    }

    public Column(String string2, TypeInfo typeInfo) {
        this.name = string2;
        this.type = typeInfo;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Column)) {
            return false;
        }
        Column column = (Column)object;
        if (this.table == null || column.table == null || this.name == null || column.name == null) {
            return false;
        }
        if (this.table != column.table) {
            return false;
        }
        return this.name.equals(column.name);
    }

    public int hashCode() {
        if (this.table == null || this.name == null) {
            return 0;
        }
        return this.table.getId() ^ this.name.hashCode();
    }

    public Column getClone() {
        Column column = new Column(this.name, this.type);
        column.copy(this);
        return column;
    }

    public Value convert(Value value2) {
        return this.convert(value2, null);
    }

    public Value convert(Value value2, Mode mode) {
        try {
            return value2.convertTo(this.type, mode, this);
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 22018) {
                String string2 = (this.table == null ? "" : this.table.getName() + ": ") + this.getCreateSQL();
                throw DbException.get(22018, dbException, value2.getTraceSQL() + " (" + string2 + ")");
            }
            throw dbException;
        }
    }

    boolean getComputed() {
        return this.isComputed;
    }

    synchronized Value computeValue(Session session, Row row) {
        this.computeTableFilter.setSession(session);
        this.computeTableFilter.set(row);
        return this.defaultExpression.getValue(session);
    }

    public void setComputedExpression(Expression expression) {
        this.isComputed = true;
        this.defaultExpression = expression;
    }

    public void setTable(Table table2, int n) {
        this.table = table2;
        this.columnId = n;
    }

    public Table getTable() {
        return this.table;
    }

    public void setDefaultExpression(Session session, Expression expression) {
        if (expression != null && (expression = expression.optimize(session)).isConstant()) {
            expression = ValueExpression.get(expression.getValue(session));
        }
        this.defaultExpression = expression;
    }

    public void setOnUpdateExpression(Session session, Expression expression) {
        if (expression != null && (expression = expression.optimize(session)).isConstant()) {
            expression = ValueExpression.get(expression.getValue(session));
        }
        this.onUpdateExpression = expression;
    }

    public int getColumnId() {
        return this.columnId;
    }

    public String getSQL(boolean bl) {
        return this.rowId ? this.name : Parser.quoteIdentifier(this.name, bl);
    }

    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return this.rowId ? stringBuilder.append(this.name) : Parser.quoteIdentifier(stringBuilder, this.name, bl);
    }

    public String getName() {
        return this.name;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public boolean isRowId() {
        return this.rowId;
    }

    public void setRowId(boolean bl) {
        this.rowId = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value validateConvertUpdateSequence(Session session, Value value2) {
        Object object;
        Expression expression;
        Object object2 = this;
        synchronized (object2) {
            expression = this.defaultExpression;
        }
        object2 = session.getDatabase().getMode();
        if (value2 == null) {
            if (expression == null) {
                value2 = ValueNull.INSTANCE;
            } else {
                value2 = this.convert(expression.getValue(session), (Mode)object2);
                if (!expression.isConstant()) {
                    session.getGeneratedKeys().add(this);
                }
                if (this.primaryKey) {
                    session.setLastIdentity(value2);
                }
            }
        }
        if (value2 == ValueNull.INSTANCE) {
            if (this.convertNullToDefault) {
                value2 = this.convert(expression.getValue(session), (Mode)object2);
                if (!expression.isConstant()) {
                    session.getGeneratedKeys().add(this);
                }
            }
            if (value2 == ValueNull.INSTANCE && !this.nullable) {
                if (((Mode)object2).convertInsertNullToZero) {
                    int n = this.type.getValueType();
                    object = DataType.getDataType(n);
                    value2 = ((DataType)object).decimal ? ValueInt.get(0).convertTo(n) : (((DataType)object).type == 11 ? session.getCurrentCommandStart().convertTo(11) : (((DataType)object).type == 24 ? session.getCurrentCommandStart() : (((DataType)object).type == 9 ? ValueTime.fromNanos(0L) : (((DataType)object).type == 10 ? session.getCurrentCommandStart().convertTo(10) : ValueString.get("").convertTo(n)))));
                } else {
                    throw DbException.get(23502, this.name);
                }
            }
        }
        if (this.checkConstraint != null) {
            Value value3;
            this.resolver.setValue(value2);
            object = this;
            synchronized (object) {
                value3 = this.checkConstraint.getValue(session);
            }
            if (value3 != ValueNull.INSTANCE && !value3.getBoolean()) {
                throw DbException.get(23513, this.checkConstraint.getSQL(false));
            }
        }
        value2 = value2.convertScale(((Mode)object2).convertOnlyToSmallerScale, this.type.getScale());
        long l = this.type.getPrecision();
        if (l > 0L && !value2.checkPrecision(l)) {
            String string2 = value2.getTraceSQL();
            if (string2.length() > 127) {
                string2 = string2.substring(0, 128) + "...";
            }
            throw DbException.get(22001, this.getCreateSQL(), string2 + " (" + value2.getType().getPrecision() + ')');
        }
        if (value2 != ValueNull.INSTANCE && DataType.isExtInfoType(this.type.getValueType()) && this.type.getExtTypeInfo() != null) {
            value2 = this.type.getExtTypeInfo().cast(value2);
        }
        this.updateSequenceIfRequired(session, value2);
        return value2;
    }

    private void updateSequenceIfRequired(Session session, Value value2) {
        if (this.sequence != null) {
            long l = this.sequence.getCurrentValue();
            long l2 = this.sequence.getIncrement();
            long l3 = value2.getLong();
            boolean bl = false;
            if (l2 > 0L && l3 > l) {
                bl = true;
            } else if (l2 < 0L && l3 < l) {
                bl = true;
            }
            if (bl) {
                this.sequence.modify(l3 + l2, null, null, null);
                session.setLastIdentity(ValueLong.get(l3));
                this.sequence.flush(session);
            }
        }
    }

    public void convertAutoIncrementToSequence(Session session, Schema schema, int n, boolean bl) {
        Object object;
        Object object2;
        String string2;
        if (this.autoIncrementOptions == null) {
            DbException.throwInternalError();
        }
        if ("IDENTITY".equals(this.originalSQL)) {
            this.originalSQL = "BIGINT";
        } else if ("SERIAL".equals(this.originalSQL)) {
            this.originalSQL = "INT";
        }
        do {
            object = ValueUuid.getNewRandom();
            object2 = ((ValueUuid)object).getString();
            object2 = StringUtils.toUpperEnglish(((String)object2).replace('-', '_'));
        } while (schema.findSequence(string2 = "SYSTEM_SEQUENCE_" + (String)object2) != null);
        object = new Sequence(schema, n, string2, this.autoIncrementOptions.getStartValue(session), this.autoIncrementOptions.getIncrement(session), this.autoIncrementOptions.getCacheSize(session), this.autoIncrementOptions.getMinValue(null, session), this.autoIncrementOptions.getMaxValue(null, session), Boolean.TRUE.equals(this.autoIncrementOptions.getCycle()), true);
        ((DbObjectBase)object).setTemporary(bl);
        session.getDatabase().addSchemaObject(session, (SchemaObject)object);
        this.setAutoIncrementOptions(null);
        object2 = new SequenceValue((Sequence)object);
        this.setDefaultExpression(session, (Expression)object2);
        this.setSequence((Sequence)object);
    }

    public void prepareExpression(Session session) {
        if (this.defaultExpression != null || this.onUpdateExpression != null) {
            this.computeTableFilter = new TableFilter(session, this.table, null, false, null, 0, null);
            if (this.defaultExpression != null) {
                this.defaultExpression.mapColumns(this.computeTableFilter, 0, 0);
                this.defaultExpression = this.defaultExpression.optimize(session);
            }
            if (this.onUpdateExpression != null) {
                this.onUpdateExpression.mapColumns(this.computeTableFilter, 0, 0);
                this.onUpdateExpression = this.onUpdateExpression.optimize(session);
            }
        }
    }

    public String getCreateSQLWithoutName() {
        return this.getCreateSQL(false);
    }

    public String getCreateSQL() {
        return this.getCreateSQL(true);
    }

    private String getCreateSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl && this.name != null) {
            Parser.quoteIdentifier(stringBuilder, this.name, true).append(' ');
        }
        if (this.originalSQL != null) {
            stringBuilder.append(this.originalSQL);
        } else {
            this.type.getSQL(stringBuilder);
        }
        if (!this.visible) {
            stringBuilder.append(" INVISIBLE ");
        }
        if (this.defaultExpression != null) {
            if (this.isComputed) {
                stringBuilder.append(" AS ");
                this.defaultExpression.getSQL(stringBuilder, true);
            } else if (this.defaultExpression != null) {
                stringBuilder.append(" DEFAULT ");
                this.defaultExpression.getSQL(stringBuilder, true);
            }
        }
        if (this.onUpdateExpression != null) {
            stringBuilder.append(" ON UPDATE ");
            this.onUpdateExpression.getSQL(stringBuilder, true);
        }
        if (!this.nullable) {
            stringBuilder.append(" NOT NULL");
        } else if (this.domain != null && !this.domain.getColumn().isNullable()) {
            stringBuilder.append(" NULL");
        }
        if (this.convertNullToDefault) {
            stringBuilder.append(" NULL_TO_DEFAULT");
        }
        if (this.sequence != null) {
            stringBuilder.append(" SEQUENCE ");
            this.sequence.getSQL(stringBuilder, true);
        }
        if (this.selectivity != 0) {
            stringBuilder.append(" SELECTIVITY ").append(this.selectivity);
        }
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ");
            StringUtils.quoteStringSQL(stringBuilder, this.comment);
        }
        if (this.checkConstraint != null) {
            stringBuilder.append(" CHECK ").append(this.checkConstraintSQL);
        }
        return stringBuilder.toString();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setOriginalSQL(String string2) {
        this.originalSQL = string2;
    }

    public String getOriginalSQL() {
        return this.originalSQL;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    public Expression getOnUpdateExpression() {
        return this.onUpdateExpression;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrementOptions != null;
    }

    public void setAutoIncrementOptions(SequenceOptions sequenceOptions) {
        this.autoIncrementOptions = sequenceOptions;
        this.nullable = false;
        if (sequenceOptions != null) {
            this.convertNullToDefault = true;
        }
    }

    public void setConvertNullToDefault(boolean bl) {
        this.convertNullToDefault = bl;
    }

    public void rename(String string2) {
        this.name = string2;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public int getSelectivity() {
        return this.selectivity == 0 ? 50 : this.selectivity;
    }

    public void setSelectivity(int n) {
        this.selectivity = n = n < 0 ? 0 : (n > 100 ? 100 : n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheckConstraint(Session session, Expression expression) {
        if (expression == null) {
            return;
        }
        if (this.resolver == null) {
            this.resolver = new SingleColumnResolver(this);
        }
        Column column = this;
        synchronized (column) {
            String string2 = this.name;
            if (this.name == null) {
                this.name = "VALUE";
            }
            expression.mapColumns(this.resolver, 0, 0);
            this.name = string2;
        }
        expression = expression.optimize(session);
        this.resolver.setValue(ValueNull.INSTANCE);
        column = this;
        synchronized (column) {
            expression.getValue(session);
        }
        if (this.checkConstraint == null) {
            this.checkConstraint = expression;
        } else if (!expression.getSQL(true).equals(this.checkConstraintSQL)) {
            this.checkConstraint = new ConditionAndOr(0, this.checkConstraint, expression);
        }
        this.checkConstraintSQL = this.getCheckConstraintSQL(session, this.name);
    }

    public void removeCheckConstraint() {
        this.checkConstraint = null;
        this.checkConstraintSQL = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getCheckConstraint(Session session, String string2) {
        String string3;
        if (this.checkConstraint == null) {
            return null;
        }
        Parser parser = new Parser(session);
        Column column = this;
        synchronized (column) {
            String string4 = this.name;
            this.name = string2;
            string3 = this.checkConstraint.getSQL(true);
            this.name = string4;
        }
        return parser.parseExpression(string3);
    }

    String getDefaultSQL() {
        return this.defaultExpression == null ? null : this.defaultExpression.getSQL(true);
    }

    String getOnUpdateSQL() {
        return this.onUpdateExpression == null ? null : this.onUpdateExpression.getSQL(true);
    }

    int getPrecisionAsInt() {
        return MathUtils.convertLongToInt(this.type.getPrecision());
    }

    DataType getDataType() {
        return DataType.getDataType(this.type.getValueType());
    }

    String getCheckConstraintSQL(Session session, String string2) {
        Expression expression = this.getCheckConstraint(session, string2);
        return expression == null ? "" : expression.getSQL(true);
    }

    public void setComment(String string2) {
        this.comment = string2;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPrimaryKey(boolean bl) {
        this.primaryKey = bl;
    }

    boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (expressionVisitor.getType() == 7 && this.sequence != null) {
            expressionVisitor.getDependencies().add(this.sequence);
        }
        if (this.defaultExpression != null && !this.defaultExpression.isEverything(expressionVisitor)) {
            return false;
        }
        return this.checkConstraint == null || this.checkConstraint.isEverything(expressionVisitor);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String toString() {
        return this.name;
    }

    public boolean isWideningConversion(Column column) {
        if (this.type != column.type) {
            return false;
        }
        if (this.type.getPrecision() > column.type.getPrecision()) {
            return false;
        }
        if (this.type.getScale() != column.type.getScale()) {
            return false;
        }
        if (this.nullable && !column.nullable) {
            return false;
        }
        if (this.convertNullToDefault != column.convertNullToDefault) {
            return false;
        }
        if (this.primaryKey != column.primaryKey) {
            return false;
        }
        if (this.autoIncrementOptions != null || column.autoIncrementOptions != null) {
            return false;
        }
        if (this.checkConstraint != null || column.checkConstraint != null) {
            return false;
        }
        if (this.convertNullToDefault || column.convertNullToDefault) {
            return false;
        }
        if (this.defaultExpression != null || column.defaultExpression != null) {
            return false;
        }
        if (this.isComputed || column.isComputed) {
            return false;
        }
        if (this.onUpdateExpression != null || column.onUpdateExpression != null) {
            return false;
        }
        return Objects.equals(this.type.getExtTypeInfo(), column.type.getExtTypeInfo());
    }

    public void copy(Column column) {
        this.checkConstraint = column.checkConstraint;
        this.checkConstraintSQL = column.checkConstraintSQL;
        this.name = column.name;
        this.nullable = column.nullable;
        this.defaultExpression = column.defaultExpression;
        this.onUpdateExpression = column.onUpdateExpression;
        this.originalSQL = column.originalSQL;
        this.convertNullToDefault = column.convertNullToDefault;
        this.sequence = column.sequence;
        this.comment = column.comment;
        this.computeTableFilter = column.computeTableFilter;
        this.isComputed = column.isComputed;
        this.selectivity = column.selectivity;
        this.primaryKey = column.primaryKey;
        this.visible = column.visible;
    }
}

