/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.Connection;
import java.sql.SQLException;
import org.h2.server.ShutdownHandler;
import org.h2.tools.Server;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;

public class Console
extends Tool
implements ShutdownHandler {
    Server web;
    private Server tcp;
    private Server pg;
    boolean isWindows;

    public static void main(String ... stringArray) throws SQLException {
        Console console;
        try {
            console = (Console)Utils.newInstance("org.h2.tools.GUIConsole", new Object[0]);
        }
        catch (Exception | NoClassDefFoundError throwable) {
            console = new Console();
        }
        console.runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        SQLException sQLException;
        block43: {
            boolean bl;
            boolean bl2;
            block42: {
                Connection connection;
                this.isWindows = Utils.getProperty("os.name", "").startsWith("Windows");
                boolean bl3 = false;
                bl2 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = true;
                bl = stringArray != null && stringArray.length > 0;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                boolean bl8 = false;
                boolean bl9 = false;
                String string6 = "";
                String string7 = "";
                boolean bl10 = false;
                boolean bl11 = false;
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    String string8 = stringArray[i];
                    if (string8 == null) continue;
                    if ("-?".equals(string8) || "-help".equals(string8)) {
                        this.showUsage();
                        return;
                    }
                    if ("-url".equals(string8)) {
                        bl7 = false;
                        string3 = stringArray[++i];
                        continue;
                    }
                    if ("-driver".equals(string8)) {
                        string2 = stringArray[++i];
                        continue;
                    }
                    if ("-user".equals(string8)) {
                        string4 = stringArray[++i];
                        continue;
                    }
                    if ("-password".equals(string8)) {
                        string5 = stringArray[++i];
                        continue;
                    }
                    if (string8.startsWith("-web")) {
                        if ("-web".equals(string8)) {
                            bl7 = false;
                            bl4 = true;
                            continue;
                        }
                        if ("-webAllowOthers".equals(string8)) {
                            bl11 = true;
                            continue;
                        }
                        if ("-webDaemon".equals(string8) || "-webSSL".equals(string8)) continue;
                        if ("-webPort".equals(string8)) {
                            ++i;
                            continue;
                        }
                        this.showUsageAndThrowUnsupportedOption(string8);
                        continue;
                    }
                    if ("-tool".equals(string8)) {
                        bl7 = false;
                        bl4 = true;
                        bl5 = true;
                        continue;
                    }
                    if ("-browser".equals(string8)) {
                        bl7 = false;
                        bl4 = true;
                        bl6 = true;
                        continue;
                    }
                    if (string8.startsWith("-tcp")) {
                        if ("-tcp".equals(string8)) {
                            bl7 = false;
                            bl3 = true;
                            continue;
                        }
                        if ("-tcpAllowOthers".equals(string8) || "-tcpDaemon".equals(string8) || "-tcpSSL".equals(string8)) continue;
                        if ("-tcpPort".equals(string8)) {
                            ++i;
                            continue;
                        }
                        if ("-tcpPassword".equals(string8)) {
                            string6 = stringArray[++i];
                            continue;
                        }
                        if ("-tcpShutdown".equals(string8)) {
                            bl7 = false;
                            bl8 = true;
                            string7 = stringArray[++i];
                            continue;
                        }
                        if ("-tcpShutdownForce".equals(string8)) {
                            bl9 = true;
                            continue;
                        }
                        this.showUsageAndThrowUnsupportedOption(string8);
                        continue;
                    }
                    if (string8.startsWith("-pg")) {
                        if ("-pg".equals(string8)) {
                            bl7 = false;
                            bl2 = true;
                            continue;
                        }
                        if ("-pgAllowOthers".equals(string8) || "-pgDaemon".equals(string8)) continue;
                        if ("-pgPort".equals(string8)) {
                            ++i;
                            continue;
                        }
                        this.showUsageAndThrowUnsupportedOption(string8);
                        continue;
                    }
                    if ("-properties".equals(string8)) {
                        ++i;
                        continue;
                    }
                    if ("-trace".equals(string8)) continue;
                    if ("-ifExists".equals(string8)) {
                        bl10 = true;
                        continue;
                    }
                    if ("-baseDir".equals(string8)) {
                        ++i;
                        continue;
                    }
                    this.showUsageAndThrowUnsupportedOption(string8);
                }
                if (bl7) {
                    bl4 = true;
                    bl5 = true;
                    bl6 = true;
                    bl3 = true;
                    bl2 = true;
                }
                if (bl8) {
                    this.out.println("Shutting down TCP Server at " + string7);
                    Server.shutdownTcpServer(string7, string6, bl9, false);
                }
                sQLException = null;
                boolean bl12 = false;
                if (string3 != null) {
                    connection = JdbcUtils.getConnection(string2, string3, string4, string5);
                    Server.startWebServer(connection);
                }
                if (bl4) {
                    try {
                        connection = bl11 ? null : StringUtils.convertBytesToHex(MathUtils.secureRandomBytes(32));
                        this.web = Server.createWebServer(stringArray, (String)((Object)connection), !bl10);
                        this.web.setShutdownHandler(this);
                        this.web.start();
                        if (bl) {
                            this.out.println(this.web.getStatus());
                        }
                        bl12 = true;
                    }
                    catch (SQLException sQLException2) {
                        this.printProblem(sQLException2, this.web);
                        sQLException = sQLException2;
                    }
                }
                if (bl5 && bl12) {
                    this.show();
                }
                if (bl6 && this.web != null) {
                    this.openBrowser(this.web.getURL());
                }
                if (bl3) {
                    try {
                        this.tcp = Server.createTcpServer(stringArray);
                        this.tcp.start();
                        if (bl) {
                            this.out.println(this.tcp.getStatus());
                        }
                        this.tcp.setShutdownHandler(this);
                    }
                    catch (SQLException sQLException3) {
                        this.printProblem(sQLException3, this.tcp);
                        if (sQLException != null) break block42;
                        sQLException = sQLException3;
                    }
                }
            }
            if (bl2) {
                try {
                    this.pg = Server.createPgServer(stringArray);
                    this.pg.start();
                    if (bl) {
                        this.out.println(this.pg.getStatus());
                    }
                }
                catch (SQLException sQLException4) {
                    this.printProblem(sQLException4, this.pg);
                    if (sQLException != null) break block43;
                    sQLException = sQLException4;
                }
            }
        }
        if (sQLException != null) {
            this.shutdown();
            throw sQLException;
        }
    }

    void show() {
    }

    private void printProblem(Exception exception, Server server) {
        if (server == null) {
            exception.printStackTrace();
        } else {
            this.out.println(server.getStatus());
            this.out.println("Root cause: " + exception.getMessage());
        }
    }

    @Override
    public void shutdown() {
        if (this.web != null && this.web.isRunning(false)) {
            this.web.stop();
            this.web = null;
        }
        if (this.tcp != null && this.tcp.isRunning(false)) {
            this.tcp.stop();
            this.tcp = null;
        }
        if (this.pg != null && this.pg.isRunning(false)) {
            this.pg.stop();
            this.pg = null;
        }
    }

    void openBrowser(String string2) {
        try {
            Server.openBrowser(string2);
        }
        catch (Exception exception) {
            this.out.println(exception.getMessage());
        }
    }
}

