/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.util.ColumnNamerConfiguration;
import org.h2.util.StringUtils;

public class ColumnNamer {
    private static final String DEFAULT_COLUMN_NAME = "DEFAULT";
    private final ColumnNamerConfiguration configuration;
    private final Set<String> existingColumnNames = new HashSet<String>();

    public ColumnNamer(Session session) {
        if (session != null && session.getColumnNamerConfiguration() != null) {
            this.configuration = session.getColumnNamerConfiguration();
        } else {
            this.configuration = ColumnNamerConfiguration.getDefault();
            if (session != null) {
                session.setColumnNamerConfiguration(this.configuration);
            }
        }
    }

    public String getColumnName(Expression expression, int n, String[] stringArray) {
        String string2 = null;
        if (stringArray != null && stringArray.length > n) {
            string2 = stringArray[n];
        }
        return this.getColumnName(expression, n, string2);
    }

    public String getColumnName(Expression expression, int n, String string2) {
        String string3 = this.getColumnName(string2, null);
        if (string3 == null && (string3 = this.getColumnName(expression.getAlias(), DEFAULT_COLUMN_NAME)) == null && (string3 = this.getColumnName(expression.getColumnName(), DEFAULT_COLUMN_NAME)) == null && (string3 = this.getColumnName(expression.getSQL(false), DEFAULT_COLUMN_NAME)) == null) {
            string3 = this.configuration.getDefaultColumnNamePattern().replace("$$", Integer.toString(n + 1));
        }
        if (this.existingColumnNames.contains(string3) && this.configuration.isGenerateUniqueColumnNames()) {
            string3 = this.generateUniqueName(string3);
        }
        this.existingColumnNames.add(string3);
        return string3;
    }

    private String getColumnName(String string2, String string3) {
        String string4 = null;
        if (string2 != null && !string2.equals(string3)) {
            if (this.isAllowableColumnName(string2)) {
                string4 = string2;
            } else if (this.isAllowableColumnName(string2 = this.fixColumnName(string2))) {
                string4 = string2;
            }
        }
        return string4;
    }

    private String generateUniqueName(String string2) {
        String string3 = string2;
        int n = 2;
        while (this.existingColumnNames.contains(string3)) {
            String string4 = "_" + n;
            string3 = string2.substring(0, Math.min(string2.length(), this.configuration.getMaxIdentiferLength() - string4.length())) + string4;
            ++n;
        }
        return string3;
    }

    private boolean isAllowableColumnName(String string2) {
        if (string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n > this.configuration.getMaxIdentiferLength() || n == 0) {
            return false;
        }
        Pattern pattern = this.configuration.getCompiledRegularExpressionMatchAllowed();
        return pattern == null || pattern.matcher(string2).matches();
    }

    private String fixColumnName(String string2) {
        int n;
        Pattern pattern = this.configuration.getCompiledRegularExpressionMatchDisallowed();
        string2 = pattern == null ? StringUtils.replaceAll(string2, "\u0000", "") : pattern.matcher(string2).replaceAll("");
        int n2 = string2.length();
        if (n2 > (n = this.configuration.getMaxIdentiferLength())) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public ColumnNamerConfiguration getConfiguration() {
        return this.configuration;
    }
}

