/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.runtime.nativeimpl;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.natives.annotations.BallerinaFunction;

@BallerinaFunction(orgName="ballerina", packageName="runtime", functionName="sleep", isPublic=true)
public class Sleep {
    private static final int CORE_THREAD_POOL_SIZE = 1;
    private static ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public static void sleep(Strand strand, long delayMillis) {
        Sleep.schedule(() -> ((NonBlockingCallback)new NonBlockingCallback(strand)).notifySuccess(), delayMillis);
    }

    public static void schedule(TimerCallback callback, long delayMillis) {
        executor.schedule(callback::execute, delayMillis, TimeUnit.MILLISECONDS);
    }

    public static interface TimerCallback {
        public void execute();
    }
}

