/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.tcp.client;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="close", receiver=@Receiver(type=TypeKind.OBJECT, structType="Client", structPackage="ballerina/socket"), isPublic=true)
public class Close {
    private static final Logger log = LoggerFactory.getLogger(Close.class);

    public static Object close(Strand strand, ObjectValue client) {
        SocketChannel socketChannel = (SocketChannel)client.getNativeData("Socket");
        try {
            Object isClient;
            if (socketChannel != null) {
                socketChannel.close();
                SelectorManager.getInstance().unRegisterChannel(socketChannel);
            }
            if ((isClient = client.getNativeData("isClient")) != null && Boolean.parseBoolean(isClient.toString())) {
                SelectorManager.getInstance().stop();
            }
        }
        catch (IOException e) {
            log.error("Unable to close the connection", (Throwable)e);
            return SocketUtils.createSocketError("unable to close the client socket connection");
        }
        return null;
    }
}

