/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.tcp.client;

import java.nio.channels.SocketChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.tcp.ReadPendingCallback;
import org.ballerinalang.stdlib.socket.tcp.ReadPendingSocketMap;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="read", receiver=@Receiver(type=TypeKind.OBJECT, structType="Client", structPackage="ballerina/socket"), isPublic=true)
public class Read {
    private static final Logger log = LoggerFactory.getLogger(Read.class);

    public static Object read(Strand strand, ObjectValue client, long length) {
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        if (length != -100L && length < 1L) {
            String msg = "requested byte length need to be 1 or more";
            callback.setReturnValues((Object)SocketUtils.createSocketError(msg));
            callback.notifySuccess();
            return null;
        }
        SocketService socketService = (SocketService)client.getNativeData("socketService");
        SocketChannel socketChannel = (SocketChannel)client.getNativeData("Socket");
        int socketHash = socketChannel.hashCode();
        ReadPendingCallback readPendingCallback = new ReadPendingCallback(callback, (int)length, socketHash, socketService.getReadTimeout());
        ReadPendingSocketMap.getInstance().add(socketChannel.hashCode(), readPendingCallback);
        log.debug("Notify to invokeRead");
        SelectorManager.getInstance().invokeRead(socketHash, socketService.getService() != null);
        return null;
    }
}

