/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.tcp.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.exceptions.SelectorInitializeException;
import org.ballerinalang.stdlib.socket.tcp.ChannelRegisterCallback;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="start", receiver=@Receiver(type=TypeKind.OBJECT, structType="Client", structPackage="ballerina/socket"), isPublic=true)
public class Start {
    private static final Logger log = LoggerFactory.getLogger(Start.class);

    public static Object start(Strand strand, ObjectValue client) {
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        SelectorManager selectorManager = null;
        ErrorValue error = null;
        SocketChannel channel = null;
        try {
            channel = (SocketChannel)client.getNativeData("Socket");
            MapValue config = (MapValue)client.getNativeData("config");
            int port = Math.toIntExact(config.getIntValue("port"));
            String host = config.getStringValue("host");
            channel.connect(new InetSocketAddress(host, port));
            channel.finishConnect();
            channel.configureBlocking(false);
            selectorManager = SelectorManager.getInstance();
            selectorManager.start();
        }
        catch (SelectorInitializeException e) {
            log.error(e.getMessage(), (Throwable)e);
            error = SocketUtils.createSocketError("unable to initialize the selector");
        }
        catch (CancelledKeyException e) {
            error = SocketUtils.createSocketError("unable to start the client socket");
        }
        catch (AlreadyBoundException e) {
            error = SocketUtils.createSocketError("client socket is already bound to a port");
        }
        catch (UnsupportedAddressTypeException e) {
            log.error("Address not supported", (Throwable)e);
            error = SocketUtils.createSocketError("provided address is not supported");
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            error = SocketUtils.createSocketError("unable to start the client socket: " + e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            error = SocketUtils.createSocketError("unable to start the socket client.");
        }
        if (error != null) {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException e) {
                log.error("Unable to close the channel during the error report", (Throwable)e);
            }
            callback.notifyFailure(error);
            return null;
        }
        SocketService socketService = (SocketService)client.getNativeData("socketService");
        selectorManager.registerChannel(new ChannelRegisterCallback(socketService, callback, 1));
        return null;
    }
}

