/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.tcp.server;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="initServer", receiver=@Receiver(type=TypeKind.OBJECT, structType="Listener", structPackage="ballerina/socket"), isPublic=true)
public class InitServer {
    private static final Logger log = LoggerFactory.getLogger(InitServer.class);

    public static Object initServer(Strand strand, ObjectValue listener, long port, MapValue<String, Object> config) {
        try {
            ServerSocketChannel serverSocket = ServerSocketChannel.open();
            serverSocket.configureBlocking(false);
            serverSocket.socket().setReuseAddress(true);
            listener.addNativeData("ServerSocket", (Object)serverSocket);
            listener.addNativeData("config", config);
            listener.addNativeData("port", (Object)((int)port));
            long timeout = config.getIntValue("readTimeoutInMillis");
            listener.addNativeData("readTimeoutInMillis", (Object)timeout);
        }
        catch (SocketException e) {
            return SocketUtils.createSocketError("unable to bind the socket port");
        }
        catch (IOException e) {
            log.error("Unable to initiate the socket listener", (Throwable)e);
            return SocketUtils.createSocketError("unable to initiate the socket listener");
        }
        return null;
    }
}

