/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.udp.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.exceptions.SelectorInitializeException;
import org.ballerinalang.stdlib.socket.tcp.ChannelRegisterCallback;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="initEndpoint", receiver=@Receiver(type=TypeKind.OBJECT, structType="UdpClient", structPackage="ballerina/socket"), isPublic=true)
public class InitEndpoint {
    private static final Logger log = LoggerFactory.getLogger(InitEndpoint.class);

    public static Object initEndpoint(Strand strand, ObjectValue client, Object address, MapValue<String, Object> config) {
        SelectorManager selectorManager;
        SocketService socketService;
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        try {
            DatagramChannel socketChannel = DatagramChannel.open();
            socketChannel.configureBlocking(false);
            socketChannel.socket().setReuseAddress(true);
            client.addNativeData("Socket", (Object)socketChannel);
            client.addNativeData("isClient", (Object)true);
            if (address != null) {
                MapValue addressRecord = (MapValue)address;
                String host = addressRecord.getStringValue("host");
                int port = addressRecord.getIntValue("port").intValue();
                if (host == null) {
                    socketChannel.bind(new InetSocketAddress(port));
                } else {
                    socketChannel.bind(new InetSocketAddress(host, port));
                }
            }
            long timeout = config.getIntValue("readTimeoutInMillis");
            socketService = new SocketService(socketChannel, strand.scheduler, null, timeout);
            client.addNativeData("socketService", (Object)socketService);
            selectorManager = SelectorManager.getInstance();
            selectorManager.start();
        }
        catch (SelectorInitializeException e) {
            log.error(e.getMessage(), (Throwable)e);
            callback.notifyFailure(SocketUtils.createSocketError("unable to initialize the selector"));
            return null;
        }
        catch (SocketException e) {
            callback.notifyFailure(SocketUtils.createSocketError("unable to bind the local socket port"));
            return null;
        }
        catch (IOException e) {
            log.error("Unable to initiate the client socket", (Throwable)e);
            callback.notifyFailure(SocketUtils.createSocketError("unable to initiate the socket: " + e.getMessage()));
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            callback.notifyFailure(SocketUtils.createSocketError("unable to start the socket client."));
            return null;
        }
        selectorManager.registerChannel(new ChannelRegisterCallback(socketService, callback, 1));
        return null;
    }
}

