/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.stdlib.socket.SocketConstants;
import org.ballerinalang.stdlib.socket.exceptions.SelectorInitializeException;
import org.ballerinalang.stdlib.socket.tcp.ChannelRegisterCallback;
import org.ballerinalang.stdlib.socket.tcp.ReadPendingCallback;
import org.ballerinalang.stdlib.socket.tcp.ReadPendingSocketMap;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientActions {
    private static final Logger log = LoggerFactory.getLogger(ClientActions.class);

    public static Object initEndpoint(ObjectValue client, MapValue<String, Object> config) {
        ErrorValue returnValue = null;
        try {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(true);
            socketChannel.socket().setReuseAddress(true);
            client.addNativeData("Socket", (Object)socketChannel);
            client.addNativeData("isClient", (Object)true);
            ObjectValue callbackService = (ObjectValue)config.get((Object)"callbackService");
            client.addNativeData("config", config);
            long readTimeout = config.getIntValue("readTimeoutInMillis");
            client.addNativeData("socketService", (Object)new SocketService(socketChannel, Scheduler.getStrand().scheduler, callbackService, readTimeout));
        }
        catch (SocketException e) {
            returnValue = SocketUtils.createSocketError("unable to bind the local socket port");
        }
        catch (IOException e) {
            log.error("Unable to initiate the client socket", (Throwable)e);
            returnValue = SocketUtils.createSocketError("unable to initiate the socket");
        }
        return returnValue;
    }

    public static Object close(ObjectValue client) {
        SocketChannel socketChannel = (SocketChannel)client.getNativeData("Socket");
        try {
            Object isClient;
            if (socketChannel != null) {
                socketChannel.close();
                SelectorManager.getInstance().unRegisterChannel(socketChannel);
            }
            if ((isClient = client.getNativeData("isClient")) != null && Boolean.parseBoolean(isClient.toString())) {
                SelectorManager.getInstance().stop(true);
            }
        }
        catch (IOException e) {
            log.error("Unable to close the connection", (Throwable)e);
            return SocketUtils.createSocketError("unable to close the client socket connection");
        }
        return null;
    }

    public static Object read(ObjectValue client, long length) {
        NonBlockingCallback callback = new NonBlockingCallback(Scheduler.getStrand());
        if (length != -100L && length < 1L) {
            String msg = "requested byte length need to be 1 or more";
            callback.setReturnValues((Object)SocketUtils.createSocketError(SocketConstants.ErrorCode.ReadTimedOutError, msg));
            callback.notifySuccess();
            return null;
        }
        SocketService socketService = (SocketService)client.getNativeData("socketService");
        SocketChannel socketChannel = (SocketChannel)client.getNativeData("Socket");
        int socketHash = socketChannel.hashCode();
        ReadPendingCallback readPendingCallback = new ReadPendingCallback(callback, (int)length, socketHash, socketService.getReadTimeout());
        ReadPendingSocketMap.getInstance().add(socketChannel.hashCode(), readPendingCallback);
        log.debug("Notify to invokeRead");
        SelectorManager.getInstance().invokeRead(socketHash, socketService.getService() != null);
        return null;
    }

    public static Object shutdownRead(ObjectValue client) {
        SocketChannel socketChannel = (SocketChannel)client.getNativeData("Socket");
        try {
            if (socketChannel != null) {
                socketChannel.shutdownInput();
            }
        }
        catch (ClosedChannelException e) {
            return SocketUtils.createSocketError("socket is already closed");
        }
        catch (IOException e) {
            log.error("Unable to shutdown the read", (Throwable)e);
            return SocketUtils.createSocketError("unable to shutdown the write");
        }
        catch (NotYetConnectedException e) {
            return SocketUtils.createSocketError("socket is not yet connected");
        }
        return null;
    }

    public static Object shutdownWrite(ObjectValue client) {
        SocketChannel socketChannel = (SocketChannel)client.getNativeData("Socket");
        try {
            if (socketChannel != null) {
                socketChannel.shutdownOutput();
            }
        }
        catch (ClosedChannelException e) {
            return SocketUtils.createSocketError("socket is already closed");
        }
        catch (IOException e) {
            log.error("Unable to shutdown the write", (Throwable)e);
            return SocketUtils.createSocketError("unable to shutdown the write");
        }
        catch (NotYetConnectedException e) {
            return SocketUtils.createSocketError("socket is not yet connected");
        }
        return null;
    }

    public static Object start(ObjectValue client) {
        NonBlockingCallback callback = new NonBlockingCallback(Scheduler.getStrand());
        SelectorManager selectorManager = null;
        ErrorValue error = null;
        SocketChannel channel = null;
        try {
            channel = (SocketChannel)client.getNativeData("Socket");
            MapValue config = (MapValue)client.getNativeData("config");
            int port = Math.toIntExact(config.getIntValue("port"));
            String host = config.getStringValue("host");
            channel.connect(new InetSocketAddress(host, port));
            channel.finishConnect();
            channel.configureBlocking(false);
            selectorManager = SelectorManager.getInstance();
            selectorManager.start();
        }
        catch (SelectorInitializeException e) {
            log.error(e.getMessage(), (Throwable)e);
            error = SocketUtils.createSocketError("unable to initialize the selector");
        }
        catch (CancelledKeyException e) {
            error = SocketUtils.createSocketError("unable to start the client socket");
        }
        catch (AlreadyBoundException e) {
            error = SocketUtils.createSocketError("client socket is already bound to a port");
        }
        catch (UnsupportedAddressTypeException e) {
            log.error("Address not supported", (Throwable)e);
            error = SocketUtils.createSocketError("provided address is not supported");
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            error = SocketUtils.createSocketError("unable to start the client socket: " + e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            error = SocketUtils.createSocketError("unable to start the socket client.");
        }
        if (error != null) {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException e) {
                log.error("Unable to close the channel during the error report", (Throwable)e);
            }
            callback.notifyFailure(error);
            return null;
        }
        SocketService socketService = (SocketService)client.getNativeData("socketService");
        selectorManager.registerChannel(new ChannelRegisterCallback(socketService, callback, 1));
        return null;
    }

    public static Object write(ObjectValue client, ArrayValue content) {
        SocketChannel socketChannel = (SocketChannel)client.getNativeData("Socket");
        byte[] byteContent = content.getBytes();
        if (log.isDebugEnabled()) {
            log.debug(String.format("No of byte going to write[%d]: %d", socketChannel.hashCode(), byteContent.length));
        }
        ByteBuffer buffer = ByteBuffer.wrap(byteContent);
        try {
            int write = socketChannel.write(buffer);
            if (log.isDebugEnabled()) {
                log.debug(String.format("No of byte written for the client[%d]: %d", socketChannel.hashCode(), write));
            }
            return (long)write;
        }
        catch (ClosedChannelException e) {
            return SocketUtils.createSocketError("client socket close already.");
        }
        catch (IOException e) {
            log.error("Unable to perform write[" + socketChannel.hashCode() + "]", (Throwable)e);
            return SocketUtils.createSocketError("write failed. " + e.getMessage());
        }
        catch (NotYetConnectedException e) {
            return SocketUtils.createSocketError("client socket not connected yet.");
        }
    }
}

