/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.tcp;

import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.TCPSocketCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPSocketReadCallback
extends TCPSocketCallback {
    private static final Logger log = LoggerFactory.getLogger(TCPSocketReadCallback.class);
    private SocketService socketService;

    TCPSocketReadCallback(SocketService socketService) {
        super(socketService);
        this.socketService = socketService;
    }

    @Override
    public void notifySuccess() {
        this.socketService.getResourceLock().release();
        SelectorManager.getInstance().invokePendingReadReadyResources(this.socketService.getSocketChannel().hashCode());
        log.debug("Socket resource dispatch succeed.");
    }

    @Override
    public void notifyFailure(ErrorValue error) {
        this.socketService.getResourceLock().release();
        super.notifyFailure(error);
    }
}

