/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.sql.Constants;
import org.ballerinalang.sql.datasource.SQLDatasource;
import org.ballerinalang.sql.utils.ErrorGenerator;
import org.ballerinalang.sql.utils.Utils;

public class ExecuteUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object nativeExecute(ObjectValue client, String sqlQuery) {
        Object dbClient = client.getNativeData("Client");
        if (dbClient != null) {
            MapValue mapValue;
            SQLDatasource sqlDatasource = (SQLDatasource)dbClient;
            Connection connection = null;
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            try {
                connection = sqlDatasource.getSQLConnection();
                statement = connection.prepareStatement(sqlQuery, 1);
                int count = statement.executeUpdate();
                Object lastInsertedId = null;
                if (!ExecuteUtils.isDdlStatement(sqlQuery) && (resultSet = statement.getGeneratedKeys()).next()) {
                    lastInsertedId = ExecuteUtils.getGeneratedKeys(resultSet);
                }
                HashMap<String, Object> resultFields = new HashMap<String, Object>();
                resultFields.put("affectedRowCount", count);
                resultFields.put("lastInsertId", lastInsertedId);
                mapValue = BallerinaValues.createRecordValue((BPackage)Constants.SQL_PACKAGE_ID, (String)"ExecuteResult", resultFields);
            }
            catch (SQLException e) {
                ErrorValue errorValue;
                try {
                    errorValue = ErrorGenerator.getSQLDatabaseError(e, "Error while executing sql query: " + sqlQuery + ". ");
                }
                catch (Throwable throwable) {
                    Utils.closeResources(resultSet, statement, connection);
                    throw throwable;
                }
                Utils.closeResources(resultSet, statement, connection);
                return errorValue;
            }
            Utils.closeResources(resultSet, statement, connection);
            return mapValue;
        }
        return ErrorGenerator.getSQLApplicationError("Client is not properly initialized!");
    }

    private static Object getGeneratedKeys(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        if (columnCount > 0) {
            int sqlType = metaData.getColumnType(1);
            switch (sqlType) {
                case -7: 
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 16: {
                    return rs.getLong(1);
                }
            }
            return rs.getString(1);
        }
        return null;
    }

    private static boolean isDdlStatement(String query) {
        String upperCaseQuery = query.trim().toUpperCase(Locale.ENGLISH);
        return Arrays.stream(DdlKeyword.values()).anyMatch(ddlKeyword -> upperCaseQuery.startsWith(ddlKeyword.name()));
    }

    private static enum DdlKeyword {
        CREATE,
        ALTER,
        DROP,
        TRUNCATE,
        COMMENT,
        RENAME;

    }
}

