/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BStreamType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.TypeFlags;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.StreamValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.sql.Constants;
import org.ballerinalang.sql.datasource.SQLDatasource;
import org.ballerinalang.sql.exception.ApplicationError;
import org.ballerinalang.sql.utils.ColumnDefinition;
import org.ballerinalang.sql.utils.ErrorGenerator;
import org.ballerinalang.sql.utils.Utils;

public class QueryUtils {
    public static StreamValue nativeQuery(ObjectValue client, String sqlQuery, Object recordType) {
        Object dbClient = client.getNativeData("Client");
        if (dbClient != null) {
            SQLDatasource sqlDatasource = (SQLDatasource)dbClient;
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                BStructureType streamConstraint;
                List<ColumnDefinition> columnDefinitions;
                connection = sqlDatasource.getSQLConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(sqlQuery);
                if (recordType == null) {
                    columnDefinitions = QueryUtils.getColumnDefinitions(resultSet, null);
                    BRecordType defaultRecord = QueryUtils.getDefaultStreamConstraint();
                    HashMap<String, BField> fieldMap = new HashMap<String, BField>();
                    for (ColumnDefinition column : columnDefinitions) {
                        int flags = 1;
                        flags = column.isNullable() ? (flags += 8192) : (flags += 256);
                        fieldMap.put(column.getSqlName(), new BField(column.getBallerinaType(), column.getSqlName(), flags));
                    }
                    defaultRecord.setFields(fieldMap);
                    streamConstraint = defaultRecord;
                } else {
                    streamConstraint = (BStructureType)((TypedescValue)recordType).getDescribingType();
                    columnDefinitions = QueryUtils.getColumnDefinitions(resultSet, streamConstraint);
                }
                return new StreamValue((BType)new BStreamType((BType)streamConstraint), QueryUtils.createRecordIterator(resultSet, statement, connection, columnDefinitions, streamConstraint));
            }
            catch (SQLException e) {
                Utils.closeResources(resultSet, statement, connection);
                ErrorValue errorValue = ErrorGenerator.getSQLDatabaseError(e, "Error while executing sql query: " + sqlQuery + ". ");
                return new StreamValue((BType)new BStreamType((BType)QueryUtils.getDefaultStreamConstraint()), QueryUtils.createRecordIterator(errorValue));
            }
            catch (ApplicationError applicationError) {
                Utils.closeResources(resultSet, statement, connection);
                ErrorValue errorValue = ErrorGenerator.getSQLApplicationError(applicationError.getMessage());
                return QueryUtils.getErrorStream(recordType, errorValue);
            }
        }
        ErrorValue errorValue = ErrorGenerator.getSQLApplicationError("Client is not properly initialized!");
        return QueryUtils.getErrorStream(recordType, errorValue);
    }

    private static StreamValue getErrorStream(Object recordType, ErrorValue errorValue) {
        if (recordType == null) {
            return new StreamValue((BType)new BStreamType((BType)QueryUtils.getDefaultStreamConstraint()), QueryUtils.createRecordIterator(errorValue));
        }
        return new StreamValue((BType)new BStreamType(((TypedescValue)recordType).getDescribingType()), QueryUtils.createRecordIterator(errorValue));
    }

    private static BRecordType getDefaultStreamConstraint() {
        BRecordType defaultRecord = new BRecordType("$stream$anon$constraint$", new BPackage("ballerina", "lang.annotations", "0.0.0"), 0, false, TypeFlags.asMask((int[])new int[]{2, 4}));
        defaultRecord.restFieldType = BTypes.typeAnydata;
        return defaultRecord;
    }

    private static List<ColumnDefinition> getColumnDefinitions(ResultSet resultSet, BStructureType streamConstraint) throws SQLException, ApplicationError {
        ArrayList<ColumnDefinition> columnDefs = new ArrayList<ColumnDefinition>();
        HashSet<String> columnNames = new HashSet<String>();
        ResultSetMetaData rsMetaData = resultSet.getMetaData();
        int cols = rsMetaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String colName = rsMetaData.getColumnLabel(i);
            if (columnNames.contains(colName)) {
                String tableName = rsMetaData.getTableName(i).toUpperCase(Locale.getDefault());
                colName = tableName + "." + colName;
            }
            int sqlType = rsMetaData.getColumnType(i);
            String sqlTypeName = rsMetaData.getColumnTypeName(i);
            boolean isNullable = true;
            if (rsMetaData.isNullable(i) == 0) {
                isNullable = false;
            }
            columnDefs.add(QueryUtils.generateColumnDefinition(colName, sqlType, sqlTypeName, streamConstraint, isNullable));
            columnNames.add(colName);
        }
        return columnDefs;
    }

    private static ColumnDefinition generateColumnDefinition(String columnName, int sqlType, String sqlTypeName, BStructureType streamConstraint, boolean isNullable) throws ApplicationError {
        String ballerinaFieldName = null;
        BType ballerinaType = null;
        if (streamConstraint != null) {
            for (Map.Entry field : streamConstraint.getFields().entrySet()) {
                if (!((String)field.getKey()).equalsIgnoreCase(columnName)) continue;
                ballerinaFieldName = (String)field.getKey();
                ballerinaType = Utils.validFieldConstraint(sqlType, ((BField)field.getValue()).type);
                if (ballerinaType != null) break;
                throw new ApplicationError(((BField)field.getValue()).type.getName() + " cannot be mapped to sql type '" + sqlTypeName + "'");
            }
            if (ballerinaFieldName == null) {
                throw new ApplicationError("No mapping field found for SQL table column '" + columnName + "' in the record type '" + streamConstraint.getName() + "'");
            }
        } else {
            ballerinaType = QueryUtils.getDefaultBallerinaType(sqlType);
            ballerinaFieldName = columnName;
        }
        return new ColumnDefinition(columnName, ballerinaFieldName, sqlType, ballerinaType, isNullable);
    }

    private static ObjectValue createRecordIterator(ResultSet resultSet, Statement statement, Connection connection, List<ColumnDefinition> columnDefinitions, BStructureType streamConstraint) {
        ObjectValue resultIterator = BallerinaValues.createObjectValue((BPackage)Constants.SQL_PACKAGE_ID, (String)"ResultIterator", (Object[])new Object[1]);
        resultIterator.addNativeData("ResultSet", (Object)resultSet);
        resultIterator.addNativeData("Statement", (Object)statement);
        resultIterator.addNativeData("Connection", (Object)connection);
        resultIterator.addNativeData("ColumnDefinition", columnDefinitions);
        resultIterator.addNativeData("recordType", (Object)streamConstraint);
        return resultIterator;
    }

    private static ObjectValue createRecordIterator(ErrorValue errorValue) {
        return BallerinaValues.createObjectValue((BPackage)Constants.SQL_PACKAGE_ID, (String)"ResultIterator", (Object[])new Object[]{errorValue});
    }

    private static BType getDefaultBallerinaType(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return new BArrayType(BTypes.typeAnydata);
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2005: 
            case 2011: 
            case 2013: 
            case 2014: {
                return BTypes.typeString;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return BTypes.typeInt;
            }
            case -7: 
            case 16: {
                return BTypes.typeBoolean;
            }
            case 2: 
            case 3: {
                return BTypes.typeDecimal;
            }
            case 6: 
            case 7: 
            case 8: {
                return BTypes.typeFloat;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return new BArrayType(BTypes.typeByte);
            }
            case 2002: {
                return QueryUtils.getDefaultStreamConstraint();
            }
        }
        return BTypes.typeAnydata;
    }
}

