/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.system.nativeimpl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.system.utils.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="system", functionName="exec", isPublic=true)
public class Exec {
    private static final Logger log = LoggerFactory.getLogger(Exec.class);

    public static Object exec(Strand strand, String command, MapValue<String, String> env, Object dir, ArrayValue args) {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(command);
        commandList.addAll(Arrays.asList(args.getStringArray()));
        ProcessBuilder pb = new ProcessBuilder(commandList);
        if (dir != null) {
            pb.directory(new File((String)dir));
        }
        if (env != null) {
            pb.environment().putAll((Map<String, String>)env);
        }
        try {
            return SystemUtils.getProcessObject(pb.start());
        }
        catch (IOException e) {
            log.error("IO error while executing the command: " + commandList, (Throwable)e);
            return SystemUtils.getBallerinaError("{ballerina/system}ProcessExecError", e);
        }
    }
}

