/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.system.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.system.nativeimpl.WaitForExit;
import org.ballerinalang.stdlib.system.utils.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="system", functionName="exitCode", receiver=@Receiver(type=TypeKind.OBJECT, structType="Process", structPackage="ballerina/system"), returnType={@ReturnType(type=TypeKind.INT), @ReturnType(type=TypeKind.ERROR)})
public class ExitCode {
    private static final Logger log = LoggerFactory.getLogger(WaitForExit.class);

    public static Object exitCode(Strand strand, ObjectValue objVal) {
        Process process = SystemUtils.processFromObject(objVal);
        try {
            return process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            log.error("Error while getting process exit code", (Throwable)e);
            return SystemUtils.getBallerinaError("{ballerina/system}ProcessExecError", e);
        }
    }
}

