/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.system.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.stdlib.time.util.TimeUtils;

public class SystemUtils {
    private static final String UNKNOWN_MESSAGE = "Unknown Error";

    public static ErrorValue getBallerinaError(String error, Throwable ex) {
        String errorMsg = error != null && ex.getMessage() != null ? ex.getMessage() : UNKNOWN_MESSAGE;
        return SystemUtils.getBallerinaError(error, errorMsg);
    }

    public static ErrorValue getBallerinaError(String error, String details) {
        return BallerinaErrors.createError((String)error, (MapValue)SystemUtils.populateSystemErrorRecord(details));
    }

    private static MapValue populateSystemErrorRecord(String message) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        if (message != null) {
            valueMap.put("message", message);
        } else {
            valueMap.put("message", UNKNOWN_MESSAGE);
        }
        return BallerinaValues.createRecordValue((String)"ballerina/system", (String)"Detail", valueMap);
    }

    public static ObjectValue getFileInfo(File inputFile) throws IOException {
        FileTime lastModified = Files.getLastModifiedTime(inputFile.toPath(), new LinkOption[0]);
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(lastModified.toString());
        MapValue lastModifiedInstance = TimeUtils.createTimeRecord((MapValue)TimeUtils.getTimeZoneRecord(), (MapValue)TimeUtils.getTimeRecord(), (long)lastModified.toMillis(), (String)zonedDateTime.getZone().toString());
        return BallerinaValues.createObjectValue((String)"ballerina/system", (String)"FileInfo", (Object[])new Object[]{inputFile.getName(), inputFile.length(), lastModifiedInstance, inputFile.isDirectory()});
    }

    public static ObjectValue getProcessObject(Process process) throws IOException {
        ObjectValue obj = BallerinaValues.createObjectValue((String)"ballerina/system", (String)"Process", (Object[])new Object[0]);
        obj.addNativeData("ProcessField", (Object)process);
        return obj;
    }

    public static Process processFromObject(ObjectValue objVal) {
        return (Process)objVal.getNativeData("ProcessField");
    }

    public static String getSystemProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            return (String)BTypes.typeString.getZeroValue();
        }
        return value;
    }

    private SystemUtils() {
    }
}

