/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.wso2.ballerinalang.compiler.util.Names;

public class BFileUtil {
    private static final String IGNORE = ".gitignore";

    public static void copy(final Path sourcePath, final Path targetPath) {
        try {
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (Files.exists(dir, new LinkOption[0])) {
                        Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!BFileUtil.IGNORE.equals(file.getFileName().toString()) && Files.exists(file, new LinkOption[0])) {
                        CopyOption[] option = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
                        Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), option);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new BLangRuntimeException("error occured while copying from '" + sourcePath + "' to '" + targetPath + "'", (Throwable)e);
        }
    }

    public static void delete(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (Files.exists(file, new LinkOption[0])) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (Files.exists(dir, new LinkOption[0])) {
                        Files.list(dir).forEach(BFileUtil::delete);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new BLangRuntimeException("error occurred while deleting '" + path + "'", (Throwable)e);
        }
    }

    public static String getQualifiedClassName(String orgName, String packageName, String version, String className) {
        if (!Names.DEFAULT_PACKAGE.value.equals(packageName)) {
            className = packageName.replace('.', '_') + "." + version.replace('.', '_') + "." + className;
        }
        if (!Names.ANON_ORG.value.equals(orgName)) {
            className = orgName.replace('.', '_') + "." + className;
        }
        return className;
    }
}

