/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.transactions;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.transactions.TransactionConstants;
import org.ballerinalang.jvm.transactions.TransactionLocalContext;
import org.ballerinalang.jvm.transactions.TransactionResourceManager;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.jvm.values.MapValue;

public class Utils {
    private static final String STRUCT_TYPE_TRANSACTION_CONTEXT = "TransactionContext";

    public static void notifyResourceManagerOnAbort(String transactionBlockId) {
        Strand strand = Scheduler.getStrand();
        TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
        TransactionResourceManager.getInstance().notifyAbort(transactionLocalContext.getGlobalTransactionId(), transactionBlockId);
    }

    public static void rollbackTransaction(String transactionBlockId) {
        Strand strand = Scheduler.getStrand();
        TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
        transactionLocalContext.rollbackTransaction(transactionBlockId);
    }

    public static void cleanupTransactionContext(String transactionBlockId) {
        Strand strand = Scheduler.getStrand();
        strand.removeLocalTransactionContext();
    }

    public static boolean getAndClearFailure() {
        Strand strand = Scheduler.getStrand();
        return strand.transactionLocalContext.getAndClearFailure() != null;
    }

    public static void notifyRemoteParticipantOnFailure() {
        Strand strand = Scheduler.getStrand();
        TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
        if (transactionLocalContext == null) {
            return;
        }
        transactionLocalContext.notifyLocalRemoteParticipantFailure();
    }

    public static void notifyLocalParticipantOnFailure() {
        Strand strand = Scheduler.getStrand();
        TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
        if (transactionLocalContext == null) {
            return;
        }
        transactionLocalContext.notifyLocalParticipantFailure();
    }

    public static Object registerRemoteParticipant(String transactionBlockId, FPValue fpCommitted, FPValue fpAborted) {
        TransactionLocalContext transactionLocalContext;
        Strand strand = Scheduler.getStrand();
        String gTransactionId = (String)strand.getProperty("globalTransactionId");
        if (gTransactionId == null) {
            return null;
        }
        strand.transactionLocalContext = transactionLocalContext = TransactionLocalContext.create((String)gTransactionId, (String)strand.getProperty("transactionUrl").toString(), (String)"2pc");
        TransactionResourceManager transactionResourceManager = TransactionResourceManager.getInstance();
        transactionResourceManager.registerParticipation(transactionLocalContext.getGlobalTransactionId(), transactionBlockId, fpCommitted, fpAborted, strand);
        MapValue trxContext = BallerinaValues.createRecordValue((BPackage)TransactionConstants.TRANSACTION_PACKAGE_ID, (String)STRUCT_TYPE_TRANSACTION_CONTEXT);
        Object[] trxContextData = new Object[]{"1.0", transactionLocalContext.getGlobalTransactionId(), transactionBlockId, transactionLocalContext.getProtocol(), transactionLocalContext.getURL()};
        return BallerinaValues.createRecord((MapValue)trxContext, (Object[])trxContextData);
    }

    public static Object registerLocalParticipant(String transactionBlockId, FPValue fpCommitted, FPValue fpAborted) {
        Strand strand = Scheduler.getStrand();
        TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
        if (transactionLocalContext == null) {
            return null;
        }
        TransactionResourceManager transactionResourceManager = TransactionResourceManager.getInstance();
        transactionResourceManager.registerParticipation(transactionLocalContext.getGlobalTransactionId(), transactionBlockId, fpCommitted, fpAborted, strand);
        MapValue trxContext = BallerinaValues.createRecordValue((BPackage)TransactionConstants.TRANSACTION_PACKAGE_ID, (String)STRUCT_TYPE_TRANSACTION_CONTEXT);
        Object[] trxContextData = new Object[]{"1.0", transactionLocalContext.getGlobalTransactionId(), transactionBlockId, transactionLocalContext.getProtocol(), transactionLocalContext.getURL()};
        return BallerinaValues.createRecord((MapValue)trxContext, (Object[])trxContextData);
    }

    public static void setTransactionContext(MapValue txDataStruct) {
        Strand strand = Scheduler.getStrand();
        String globalTransactionId = txDataStruct.get((Object)"transactionId").toString();
        String transactionBlockId = txDataStruct.get((Object)"transactionBlockId").toString();
        String url = txDataStruct.get((Object)"registerAtURL").toString();
        String protocol = txDataStruct.get((Object)"coordinationType").toString();
        TransactionLocalContext trxCtx = TransactionLocalContext.createTransactionParticipantLocalCtx((String)globalTransactionId, (String)url, (String)protocol);
        trxCtx.beginTransactionBlock(transactionBlockId);
        strand.transactionLocalContext = trxCtx;
    }

    public static boolean isNestedTransaction() {
        Strand strand = Scheduler.getStrand();
        return strand.transactionLocalContext != null;
    }

    public static String getCurrentTransactionId() {
        Strand strand = Scheduler.getStrand();
        String currentTransactionId = "";
        TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
        if (transactionLocalContext != null) {
            currentTransactionId = transactionLocalContext.getGlobalTransactionId() + ":" + transactionLocalContext.getCurrentTransactionBlockId();
        }
        return currentTransactionId;
    }

    public static boolean abortResourceManagers(String transactionId, String transactionBlockId) {
        return TransactionResourceManager.getInstance().notifyAbort(transactionId, transactionBlockId);
    }

    public static boolean commitResourceManagers(String transactionId, String transactionBlockId) {
        Strand strand = Scheduler.getStrand();
        return TransactionResourceManager.getInstance().notifyCommit(strand, transactionId, transactionBlockId);
    }

    public static boolean prepareResourceManagers(String transactionId, String transactionBlockId) {
        return TransactionResourceManager.getInstance().prepare(transactionId, transactionBlockId);
    }

    public static long getAvailablePort() {
        return Utils.findFreePort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n = port;
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new IllegalStateException("Could not find a free TCP/IP port");
    }

    public static String getHostAddress() {
        return Utils.getLocalHostLANAddress().getHostAddress();
    }

    private static InetAddress getLocalHostLANAddress() throws RuntimeException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to determine LAN address: " + e, e);
        }
    }
}

