/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.composer.service.fs.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.ReadOnlyFileSystemException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.ballerinalang.composer.server.spi.ComposerService;
import org.ballerinalang.composer.server.spi.ServiceInfo;
import org.ballerinalang.composer.server.spi.ServiceType;
import org.ballerinalang.composer.service.fs.FileSystem;
import org.ballerinalang.composer.service.fs.service.request.CreateFileRequest;
import org.ballerinalang.composer.service.fs.service.request.DeleteFileRequest;
import org.ballerinalang.composer.service.fs.service.request.FileExistsRequest;
import org.ballerinalang.composer.service.fs.service.request.ListFilesRequest;
import org.ballerinalang.composer.service.fs.service.request.MoveCopyFileRequest;
import org.ballerinalang.composer.service.fs.service.request.ReadFileRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/composer/fs")
public class FileSystemService
implements ComposerService {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemService.class);
    private static final String STATUS = "status";
    private static final String SUCCESS = "success";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    private static final String MIME_APPLICATION_JSON = "application/json";
    private List<java.nio.file.Path> rootPaths;
    private final FileSystem fileSystem;

    public FileSystemService(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @OPTIONS
    @Path(value="/list/roots")
    public Response listRootsOptions() {
        return this.createCORSResponse();
    }

    @POST
    @Path(value="/list/roots")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response listRoots(ListFilesRequest request) {
        try {
            List<String> extensionList = Arrays.asList(request.getExtensions().split(","));
            JsonArray roots = this.rootPaths == null || this.rootPaths.isEmpty() ? this.fileSystem.listRoots(extensionList) : this.fileSystem.getJsonForRoots(this.rootPaths, extensionList);
            return this.createOKResponse(roots);
        }
        catch (Throwable throwable) {
            logger.error("/root service error", (Object)throwable.getMessage(), (Object)throwable);
            return this.createErrorResponse(throwable);
        }
    }

    @OPTIONS
    @Path(value="/exists")
    public Response pathExistsOptions() {
        return this.createCORSResponse();
    }

    @POST
    @Path(value="/exists")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response pathExists(FileExistsRequest request) {
        try {
            JsonObject exists = this.fileSystem.exists(request.getPath());
            return this.createOKResponse(exists);
        }
        catch (Throwable throwable) {
            logger.error("/exists service error", (Object)throwable.getMessage(), (Object)throwable);
            return this.createErrorResponse(throwable);
        }
    }

    @OPTIONS
    @Path(value="/create")
    public Response createOptions() {
        return this.createCORSResponse();
    }

    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(CreateFileRequest request) {
        try {
            String filePath = request.getFullPath() != null ? request.getFullPath() : Paths.get(request.getPath(), request.getName()).toString();
            this.fileSystem.create(filePath, request.getType(), request.getContent());
            JsonObject entity = new JsonObject();
            entity.addProperty(STATUS, SUCCESS);
            return this.createOKResponse(entity);
        }
        catch (Throwable throwable) {
            logger.error("/create service error", (Object)throwable.getMessage(), (Object)throwable);
            return this.createErrorResponse(throwable);
        }
    }

    @OPTIONS
    @Path(value="/move")
    public Response moveOptions() {
        return this.createCORSResponse();
    }

    @POST
    @Path(value="/move")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response move(MoveCopyFileRequest request) {
        try {
            this.fileSystem.move(request.getSrcPath(), request.getDestPath());
            JsonObject entity = new JsonObject();
            entity.addProperty(STATUS, SUCCESS);
            return this.createOKResponse(entity);
        }
        catch (Throwable throwable) {
            logger.error("/create service error", (Object)throwable.getMessage(), (Object)throwable);
            return this.createErrorResponse(throwable);
        }
    }

    @OPTIONS
    @Path(value="/copy")
    public Response copyOptions() {
        return this.createCORSResponse();
    }

    @POST
    @Path(value="/copy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response copy(MoveCopyFileRequest request) {
        try {
            this.fileSystem.copy(request.getSrcPath(), request.getDestPath());
            JsonObject entity = new JsonObject();
            entity.addProperty(STATUS, SUCCESS);
            return this.createOKResponse(entity);
        }
        catch (Throwable throwable) {
            logger.error("/create service error", (Object)throwable.getMessage(), (Object)throwable);
            return this.createErrorResponse(throwable);
        }
    }

    @OPTIONS
    @Path(value="/delete")
    public Response deleteOptions() {
        return this.createCORSResponse();
    }

    @POST
    @Path(value="/delete")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response delete(DeleteFileRequest request) {
        try {
            this.fileSystem.delete(request.getPath());
            JsonObject entity = new JsonObject();
            entity.addProperty(STATUS, SUCCESS);
            return this.createOKResponse(entity);
        }
        catch (Throwable throwable) {
            logger.error("/delete service error", (Object)throwable.getMessage(), (Object)throwable);
            return this.createErrorResponse(throwable);
        }
    }

    @OPTIONS
    @Path(value="/list/files")
    public Response filesInPathOptions() {
        return this.createCORSResponse();
    }

    @POST
    @Path(value="/list/files")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response filesInPath(ListFilesRequest request) {
        try {
            List<String> extensionList = Arrays.asList(request.getExtensions().split(","));
            JsonArray filesInPath = this.fileSystem.listFilesInPath(request.getPath(), extensionList);
            return this.createOKResponse(filesInPath);
        }
        catch (Throwable throwable) {
            logger.error("/list service error", (Object)throwable.getMessage(), (Object)throwable);
            return this.createErrorResponse(throwable);
        }
    }

    @OPTIONS
    @Path(value="/write")
    public Response writeOptions() {
        return this.createCORSResponse();
    }

    @POST
    @Path(value="/write")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response write(CreateFileRequest request) {
        try {
            java.nio.file.Path filePath = request.getFullPath() != null ? Paths.get(request.getFullPath(), new String[0]) : Paths.get(request.getPath(), request.getName());
            byte[] content = request.isBase64Encoded() ? Base64.getDecoder().decode(request.getContent()) : request.getContent().getBytes(Charset.defaultCharset());
            Files.write(filePath, content, new OpenOption[0]);
            JsonObject entity = new JsonObject();
            entity.addProperty(STATUS, SUCCESS);
            return this.createOKResponse(entity);
        }
        catch (Throwable throwable) {
            logger.error("/write service error", (Object)throwable.getMessage(), (Object)throwable);
            return this.createErrorResponse(throwable);
        }
    }

    @OPTIONS
    @Path(value="/read")
    public Response readOptions() {
        return this.createCORSResponse();
    }

    @POST
    @Path(value="/read")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response read(ReadFileRequest request) {
        try {
            return this.createOKResponse(this.fileSystem.read(request.getPath()));
        }
        catch (Throwable throwable) {
            logger.error("/read service error", (Object)throwable.getMessage(), (Object)throwable);
            return this.createErrorResponse(throwable);
        }
    }

    @OPTIONS
    @Path(value="/user/home")
    public Response userHomeOptions() {
        return this.createCORSResponse();
    }

    @GET
    @Path(value="/user/home")
    @Produces(value={"application/json"})
    public Response userHome() {
        try {
            return this.createOKResponse(this.fileSystem.getUserHome());
        }
        catch (Throwable throwable) {
            logger.error("/userHome service error", (Object)throwable.getMessage(), (Object)throwable);
            return this.createErrorResponse(throwable);
        }
    }

    private Response createOKResponse(Object entity) {
        return Response.status((Response.Status)Response.Status.OK).entity(entity).header(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, (Object)Character.valueOf('*')).type(MIME_APPLICATION_JSON).build();
    }

    private Response createErrorResponse(Throwable ex) {
        JsonObject entity = new JsonObject();
        String errMsg = ex.getMessage();
        if (ex instanceof AccessDeniedException) {
            errMsg = "Access Denied to " + ex.getMessage();
        } else if (ex instanceof NoSuchFileException) {
            errMsg = "No such file: " + ex.getMessage();
        } else if (ex instanceof FileAlreadyExistsException) {
            errMsg = "File already exists: " + ex.getMessage();
        } else if (ex instanceof NotDirectoryException) {
            errMsg = "Not a directory: " + ex.getMessage();
        } else if (ex instanceof ReadOnlyFileSystemException) {
            errMsg = "Read only: " + ex.getMessage();
        } else if (ex instanceof DirectoryNotEmptyException) {
            errMsg = "Directory not empty: " + ex.getMessage();
        } else if (ex instanceof FileNotFoundException) {
            errMsg = "File not found: " + ex.getMessage();
        }
        entity.addProperty("Error", errMsg);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)entity).header(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, (Object)Character.valueOf('*')).type(MIME_APPLICATION_JSON).build();
    }

    public Response createCORSResponse() {
        return Response.ok().header(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), (Object)"*").header(HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS.toString(), (Object)"true").header(HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), (Object)"POST, GET, OPTIONS ").header(HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString(), (Object)(HttpHeaderNames.CONTENT_TYPE.toString() + ", " + HttpHeaderNames.ACCEPT.toString() + ", X-Requested-With")).build();
    }

    public List<java.nio.file.Path> getRootPaths() {
        return this.rootPaths;
    }

    public void setRootPaths(List<java.nio.file.Path> rootPaths) {
        this.rootPaths = rootPaths;
    }

    public ServiceInfo getServiceInfo() {
        return new ServiceInfo("filesystem", "fs", ServiceType.HTTP);
    }
}

